/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class InclinometerModule
extends Module {
    String plutoGatewayName;
    PlutoGatewayModule plutoGateway;
    double inclinaison;

    public InclinometerModule(String name, int tickMillis, String plutoGatewayName) {
        super(name, tickMillis);
        this.plutoGatewayName = plutoGatewayName;
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
    }

    public double readInclinaison() throws FcsHardwareException {
        this.updateInclinaison();
        return this.inclinaison;
    }

    public void updateInclinaison() throws FcsHardwareException {
        this.inclinaison = InclinometerModule.convertVoltage2Degree(this.plutoGateway.readNewAnalogValue() / 10);
    }

    public static double convertVoltage2Degree(int voltage) {
        if (voltage < 0 || voltage > 5) {
            throw new IllegalArgumentException("Voltage has to be between 0.5 and 4.5.");
        }
        double sin_angle = ((double)voltage - 2.5) / 11.52;
        Math.asin(sin_angle);
        return Math.toDegrees(Math.asin(sin_angle));
    }
}

