/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoLatches
extends MobileItemModule {
    AutochangerLatchModule latchXminus;
    AutochangerLatchModule latchXplus;
    volatile FcsEnumerations.LockStatus lockStatus;
    volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    final Condition stateUpdated;
    protected volatile boolean updatingState;

    public AutochangerTwoLatches(String moduleName, int aTickMillis, AutochangerLatchModule latchXminus, AutochangerLatchModule latchXplus) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public EPOSController getLatchXminusController() {
        return this.latchXminus.getLatchController();
    }

    public EPOSController getLatchXplusController() {
        return this.latchXplus.getLatchController();
    }

    @Override
    public boolean isHardwareReady() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.latchXminus.checkHardware();
        this.latchXplus.checkHardware();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            boolean inTravel;
            this.updatingState = true;
            this.latchXminus.updateStateWithSensors(readHexaValues);
            this.latchXplus.updateStateWithSensors(readHexaValues);
            boolean inError = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean unlocked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            boolean bl = inTravel = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
            this.filterPresenceStatus = this.latchXminus.isEmpty() && this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (!this.latchXminus.isEmpty() && !this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StatusDataPublishedByAutochangerTwoLatches getStatusData() {
        return FcsUtils.createStatusDataPublishedByTwoLatches(this);
    }

    @Override
    public void publishData() {
        this.publish("autochangerLatches", this.getStatusData());
    }
}

