/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerOnlineClampModule
extends MobileItemModule {
    EPOSController onlineClampController;
    Map<String, Integer> paramsForCurrentToLock;
    Map<String, Integer> paramsForCurrentToUnlock;
    int currentToLock;
    int currentToUnlock;
    int currentToClamp;
    int holdTime = 2000;
    int travelTime = 5000;
    FcsEnumerations.LockStatus lockStatus;

    public AutochangerOnlineClampModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    public AutochangerOnlineClampModule(String moduleName, int aTickMillis, int currentToLock, int currentToUnlock, int currentToClamp, Map<String, Integer> paramsForCurrentToLock, Map<String, Integer> paramsForCurrentToUnlock, int holdTime, int travelTime) {
        super(moduleName, aTickMillis);
        this.paramsForCurrentToLock = paramsForCurrentToLock;
        this.paramsForCurrentToUnlock = paramsForCurrentToUnlock;
        this.currentToLock = currentToLock;
        this.currentToUnlock = currentToUnlock;
        this.currentToClamp = currentToClamp;
        this.holdTime = holdTime;
        this.travelTime = travelTime;
    }

    public int getCurrentToLock() {
        return this.currentToLock;
    }

    @ConfigChanger
    public void setCurrentToLock(int currentToLock) {
        this.currentToLock = currentToLock;
    }

    public int getCurrentToUnlock() {
        return this.currentToUnlock;
    }

    @ConfigChanger
    public void setCurrentToUnlock(int currentToUnlock) {
        this.currentToUnlock = currentToUnlock;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    @ConfigChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    @ConfigChanger
    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public int getTravelTime() {
        return this.travelTime;
    }

    @ConfigChanger
    public void setTravelTime(int travelTime) {
        this.travelTime = travelTime;
    }

    public EPOSController getOnlineClampController() {
        return this.onlineClampController;
    }

    public void initModule() {
        super.initModule();
        this.onlineClampController = (EPOSController)this.getModule("onlineClampController");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((MainModule)this.getModule("main")).isHardwareReady();
    }

    public void initializeController() throws SDORequestException, HardwareException {
        try {
            this.onlineClampController.activateBrake();
            this.onlineClampController.shutdown();
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + ex.getMessage()), new String[0]);
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.onlineClampController.enable();
                this.onlineClampController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.onlineClampController.releaseBrake();
                this.onlineClampController.writeCurrent(this.currentToLock);
                break;
            }
            case UNLOCK_ONLINECLAMP: {
                this.onlineClampController.enable();
                this.onlineClampController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.onlineClampController.writeCurrent(this.currentToClamp);
                this.onlineClampController.releaseBrake();
                this.slowDownCurrent();
                this.onlineClampController.writeCurrent(this.currentToUnlock);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock online clamp for CPPM test bench.")
    public String testLock() throws SDORequestException, ShortResponseToSDORequestException, BadCommandException, ErrorInCommandExecutionException, InterruptedException, FcsHardwareException {
        this.onlineClampController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.onlineClampController.enable();
        this.onlineClampController.releaseBrake();
        fcslog.debug((Object)(String.valueOf(this.name) + ": controller brake released."), new String[0]);
        this.onlineClampController.writeCurrent(this.currentToLock);
        fcslog.debug((Object)(String.valueOf(this.name) + ": sent current to controller:" + this.currentToLock), new String[0]);
        fcslog.debug((Object)(String.valueOf(this.name) + ": sleeping for:" + this.travelTime), new String[0]);
        fcslog.debug((Object)(String.valueOf(this.name) + ":time=" + System.currentTimeMillis()), new String[0]);
        Thread.sleep(this.travelTime);
        fcslog.debug((Object)(String.valueOf(this.name) + ":time=" + System.currentTimeMillis()), new String[0]);
        this.onlineClampController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.onlineClampController.enable();
        this.onlineClampController.releaseBrake();
        this.onlineClampController.writeCurrent(this.currentToClamp);
        fcslog.debug((Object)(String.valueOf(this.name) + "==> current sent to controller=" + this.currentToClamp), new String[0]);
        fcslog.debug((Object)(String.valueOf(this.name) + ": sleeping for:" + this.holdTime), new String[0]);
        fcslog.debug((Object)(String.valueOf(this.name) + ":time=" + System.currentTimeMillis()), new String[0]);
        Thread.sleep(this.holdTime);
        fcslog.debug((Object)(String.valueOf(this.name) + ":time=" + System.currentTimeMillis()), new String[0]);
        this.onlineClampController.activateBrake();
        fcslog.debug((Object)(String.valueOf(this.name) + ": controller brake activated."), new String[0]);
        Thread.sleep(1000L);
        this.onlineClampController.writeCurrent(0);
        fcslog.debug((Object)(String.valueOf(this.name) + "==> current sent to controller=" + 0), new String[0]);
        return String.valueOf(this.name) + " LOCKED";
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock online clamp for CPPM test bench.")
    public String testUnlock() throws SDORequestException, BadCommandException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, InterruptedException, FcsHardwareException {
        this.onlineClampController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.onlineClampController.enable();
        this.onlineClampController.writeCurrent(this.currentToClamp);
        this.onlineClampController.releaseBrake();
        Thread.sleep(1000L);
        this.slowDownCurrent();
        this.onlineClampController.writeCurrent(this.currentToUnlock);
        Thread.sleep(this.travelTime + 3000);
        this.onlineClampController.writeCurrent(0);
        Thread.sleep(10000L);
        this.onlineClampController.activateBrake();
        return String.valueOf(this.name) + " UNLOCKED";
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case LOCK_ONLINECLAMP: {
                this.onlineClampController.writeCurrent(this.currentToClamp);
                try {
                    Thread.sleep(this.holdTime);
                }
                catch (InterruptedException interruptedException) {
                    throw new ErrorInCommandExecutionException(String.valueOf(this.name) + " was interrupted during action " + action.toString());
                }
                this.onlineClampController.activateBrake();
                this.onlineClampController.writeCurrent(0);
                break;
            }
        }
    }

    public void slowDownCurrent() throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        int step = this.currentToClamp / 5;
        int curr = this.currentToClamp - step;
        while (curr > 0) {
            fcslog.debug((Object)("current=" + curr), new String[0]);
            this.onlineClampController.writeCurrent(curr);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new BadCommandException(String.valueOf(this.name) + " was interrupted during action testLock." + ex.getMessage());
            }
            int actualCurrent = this.onlineClampController.readCurrent();
            if (actualCurrent != curr) {
                log.error((Object)(String.valueOf(this.name) + ": CURRENT ERROR in" + " slowDownCurrent actualCurrent=" + actualCurrent + ",curr=" + curr), new String[0]);
            }
            curr -= step;
        }
        fcslog.debug((Object)"current=0", new String[0]);
        this.onlineClampController.writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() throws SDORequestException {
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() throws SDORequestException {
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        this.onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");
    }

    @Override
    public void publishData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

