/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterLatch;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerLatchModule
extends MobileItemModule
implements FilterLatch {
    AutoChangerModule autochanger;
    EPOSController latchController;
    final NumericSensor filterPresenceSensor;
    final NumericSensor lockSensor;
    final NumericSensor unlockSensor;
    private volatile boolean filterEngaged;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private boolean inTravel;
    int minCurrent;
    int maxCurrent;
    int currentToOpen;
    int readCurrent;
    private FcsEnumerations.LockStatus lockStatus;
    private volatile boolean initialized;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    private final long timeoutForOpening;
    private final long timeoutForClosing;
    private boolean controllerInFault;

    public AutochangerLatchModule(String moduleName, int aTickMillis, EPOSController latchController, long timeoutForClosing, long timeoutForOpening, NumericSensor lockSensor, NumericSensor unlockSensor, NumericSensor filterPresenceSensor, int minCurrent, int maxCurrent, int currentToOpen) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.filterEngaged = false;
        this.latchController = latchController;
        this.timeoutForClosing = timeoutForClosing;
        this.timeoutForOpening = timeoutForOpening;
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
        this.filterPresenceSensor = filterPresenceSensor;
        this.minCurrent = minCurrent;
        this.maxCurrent = maxCurrent;
        this.currentToOpen = currentToOpen;
    }

    @Override
    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    @Override
    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    @Override
    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public String getControllerName() {
        return this.latchController.getName();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latchController is in Fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @ConfigChanger
    public void setMinCurrent(int minCurrent) {
        this.minCurrent = minCurrent;
    }

    @ConfigChanger
    public void setMaxCurrent(int maxCurrent) {
        this.maxCurrent = maxCurrent;
    }

    @ConfigChanger
    public void setCurrentToOpen(int currentToOpen) {
        this.currentToOpen = currentToOpen;
    }

    /*
     * Exception decompiling
     */
    @Override
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that unlockSensor and lockSensor return non consistant values.")
    public boolean isInError() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.ERROR);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty.")
    public boolean isEmpty() {
        return !this.filterEngaged;
    }

    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
        if (this.latchController == null) {
            fcslog.error((Object)(String.valueOf(this.name) + "==>>> latchController == null - Please fix groovy description file."), new String[0]);
            throw new IllegalArgumentException(String.valueOf(this.name) + "==>>> null latchController - fix groovy description file.");
        }
        this.listens(new Observable[]{(Observable)((Object)this.latchController)});
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.latchController.initializeHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            log.warning((Object)(String.valueOf(this.name) + ":" + ex.getMessage()), new String[0]);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update latch state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(hexaValues);
            this.lockSensor.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.filterEngaged = this.filterPresenceSensor.getDigitalValue() == 1;
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            this.inTravel = !this.locked && !this.unlocked;
            boolean bl = this.inError = this.locked && this.unlocked;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (this.locked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (this.unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (this.inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger hardware is connected and ready.")
    public boolean isHardwareReady() {
        return this.autochanger.isHardwareReady();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.autochanger.checkPreConditionsForClosingLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.autochanger.checkPreConditionsForOpeningLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
            }
            case CLOSE: {
                return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
            }
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case OPEN: {
                this.latchController.enable();
                this.latchController.writeCurrent(this.currentToOpen);
                break;
            }
            case CLOSE: {
                this.latchController.enable();
                this.latchController.writeCurrent(-this.currentToOpen);
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        fcslog.debug((Object)(String.valueOf(this.name) + " is ABORTING action " + action.toString() + " within delay " + delay), new String[0]);
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        fcslog.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        fcslog.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.latchController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.abortAction(action, delay);
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.latchController.off();
        fcslog.info((Object)(String.valueOf(this.name) + ":" + action.toString() + " completed - doing postAction."), new String[0]);
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        block10: {
            String msgFromController;
            CanOpenEPOS ctrl;
            block9: {
                String errCode;
                log.debug((Object)(String.valueOf(this.name) + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()), new String[0]);
                if (!(source instanceof CanOpenEPOS)) {
                    return;
                }
                if (!(v.getValue() instanceof EmergencyMessage)) break block9;
                EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
                log.debug((Object)(String.valueOf(this.name) + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()), new String[0]);
                if (!this.latchController.getName().equals(emcyMsg.getDeviceName())) break block10;
                switch (errCode = emcyMsg.getDeviceErrorCode()) {
                    case "00": {
                        log.debug((Object)(String.valueOf(this.name) + ":faultReset ?=" + emcyMsg.toString()), new String[0]);
                        this.controllerInFault = false;
                        break;
                    }
                    default: {
                        log.debug((Object)(String.valueOf(this.name) + ":EmergencyMessage received for " + "my controller from CanOpenProxy=" + emcyMsg.toString()), new String[0]);
                        this.controllerInFault = true;
                    }
                }
                this.publishData();
                break block10;
            }
            if (v.getValue() instanceof String && (ctrl = (CanOpenEPOS)((Object)source)).getName().equals(this.latchController.getName()) && (msgFromController = (String)v.getValue()).equals("faultReset")) {
                this.controllerInFault = false;
                this.publishData();
            }
        }
    }

    public StatusDataPublishedByAutochangerLatch getStatusData() {
        StatusDataPublishedByAutochangerLatch status = FcsUtils.createStatusDataPublishedByLatch(this);
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.getStatusData();
        this.publish("autochangerLatch", status);
    }
}

