/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutoChangerTrucksModule
extends MobileItemModule {
    protected NumericSensor handoffPositionSensor0;
    protected NumericSensor handoffPositionSensor1;
    protected NumericSensor onlinePositionSensor0;
    protected NumericSensor onlinePositionSensor1;
    protected NumericSensor standbyPositionSensor0;
    protected NumericSensor standbyPositionSensor1;
    int encoderRibbonMinValue;
    int encoderRibbonMaxValue;
    int minActualPositionValue;
    int maxActualPositionValue;
    int position;
    private final int standbyPosition;
    private final int handoffPosition;
    private final int onlinePosition;
    int current;
    int speed;
    private final int maxSpeed = 99999;
    private final int maxCurrent = 99999;
    int absoluteTargetPosition;
    int relativeTargetPosition;
    long timeoutForTrucksMotion;
    EPOSController linearRailMasterController;
    EPOSController linearRailSlaveController;
    private AutoChangerModule autochanger;
    final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean masterControllerInFault;
    private boolean slaveControllerInFault;
    private boolean atHandoff;
    private boolean atOnline;
    private boolean atStandby;
    private boolean standbySensorsInError;
    private boolean handoffSensorsInError;
    private boolean onlineSensorsInError;

    public AutoChangerTrucksModule(String moduleName, int aTickMillis, int encoderRibbonMinValue, int encoderRibbonMaxValue, int minActualValue, int maxActualValue, int standbyPosition, int handoffPosition, int onlinePosition, long timeoutForTrucksMotion, NumericSensor handoffPositionSensor0, NumericSensor handoffPositionSensor1, NumericSensor onlinePositionSensor0, NumericSensor onlinePositionSensor1, NumericSensor standbyPositionSensor0, NumericSensor standbyPositionSensor1) {
        super(moduleName, aTickMillis);
        this.encoderRibbonMinValue = encoderRibbonMinValue;
        this.encoderRibbonMaxValue = encoderRibbonMaxValue;
        this.minActualPositionValue = minActualValue;
        this.maxActualPositionValue = maxActualValue;
        this.standbyPosition = standbyPosition;
        this.handoffPosition = handoffPosition;
        this.onlinePosition = onlinePosition;
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
        this.standbyPositionSensor0 = standbyPositionSensor0;
        this.handoffPositionSensor0 = handoffPositionSensor0;
        this.onlinePositionSensor0 = onlinePositionSensor0;
        this.standbyPositionSensor1 = standbyPositionSensor1;
        this.handoffPositionSensor1 = handoffPositionSensor1;
        this.onlinePositionSensor1 = onlinePositionSensor1;
        this.absoluteTargetPosition = 0;
        this.relativeTargetPosition = 0;
        this.masterControllerInFault = false;
        this.slaveControllerInFault = false;
        this.standbySensorsInError = false;
        this.onlineSensorsInError = false;
        this.handoffSensorsInError = false;
        this.atHandoff = false;
        this.atOnline = false;
        this.atStandby = false;
        this.current = 0;
        this.speed = 0;
    }

    public int getPosition() {
        return this.position;
    }

    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    public int getEncoderRibbonMinValue() {
        return this.encoderRibbonMinValue;
    }

    public int getEncoderRibbonMaxValue() {
        return this.encoderRibbonMaxValue;
    }

    public boolean isMasterControllerInFault() {
        return this.masterControllerInFault;
    }

    public boolean isSlaveControllerInFault() {
        return this.slaveControllerInFault;
    }

    public EPOSController getLinearRailMasterController() {
        return this.linearRailMasterController;
    }

    public EPOSController getLinearRailSlaveController() {
        return this.linearRailSlaveController;
    }

    public NumericSensor getStandbyPositionSensor0() {
        return this.standbyPositionSensor0;
    }

    public NumericSensor getHandoffPositionSensor0() {
        return this.handoffPositionSensor0;
    }

    public NumericSensor getOnlinePositionSensor0() {
        return this.onlinePositionSensor0;
    }

    public NumericSensor getStandbyPositionSensor1() {
        return this.standbyPositionSensor1;
    }

    public NumericSensor getOnlinePositionSensor1() {
        return this.onlinePositionSensor1;
    }

    public NumericSensor getHandoffPositionSensor1() {
        return this.handoffPositionSensor1;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getMaxSpeed() {
        return 99999;
    }

    public int getMaxCurrent() {
        return 99999;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Standby are equal.")
    public boolean isStandbySensorsInError() {
        return this.standbySensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Handoff are equal.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Online are equal.")
    public boolean isOnlineSensorsInError() {
        return this.onlineSensorsInError;
    }

    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnlinePosition() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandbyPosition() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
        this.linearRailMasterController = (EPOSController)this.getModule("linearRailMasterController");
        this.linearRailSlaveController = (EPOSController)this.getModule("linearRailSlaveController");
        this.listens(new Observable[]{(Observable)((Object)this.linearRailMasterController)});
        this.listens(new Observable[]{(Observable)((Object)this.linearRailSlaveController)});
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        fcslog.debug((Object)(String.valueOf(this.name) + " checking hardware."), new String[0]);
        try {
            this.linearRailSlaveController.initializeHardware();
            this.linearRailMasterController.initializeHardware();
            this.configureControllers();
            this.homing();
            this.linearRailSlaveController.enable();
            this.linearRailMasterController.enable();
        }
        catch (SDORequestException ex) {
            fcslog.error((Object)(String.valueOf(this.name) + ":" + ex.getMessage()), new String[0]);
        }
        catch (BadCommandException | ErrorInCommandExecutionException ex) {
            throw new HardwareException(true, ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + ":" + (Object)((Object)ex)), new String[0]);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check controllers configuration.", alias="checkCtlConfig")
    @Deprecated
    public void checkControllersConfiguration() throws SDORequestException, HardwareException {
        try {
            this.linearRailSlaveController.readParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.linearRailSlaveController.readParameters(EPOSEnumerations.EposMode.HOMING);
            this.linearRailSlaveController.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.linearRailSlaveController.checkParameters(EPOSEnumerations.EposMode.HOMING);
            this.linearRailMasterController.readParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.linearRailMasterController.readParameters(EPOSEnumerations.EposMode.HOMING);
            this.linearRailMasterController.checkParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.linearRailMasterController.checkParameters(EPOSEnumerations.EposMode.HOMING);
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + ":" + ex.getMessage()), new String[0]);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, String.valueOf(this.name) + ":" + ex.getMessage());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() throws SDORequestException {
        this.linearRailMasterController.shutdown();
        this.linearRailSlaveController.shutdown();
        AutoChangerTrucksModule.configureDigitalInputOfLinearRails(this.linearRailMasterController);
        AutoChangerTrucksModule.configureDigitalInputOfLinearRails(this.linearRailSlaveController);
        AutoChangerTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailMasterController);
        AutoChangerTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailSlaveController);
    }

    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atHandoff) {
            throw new BadCommandException(String.valueOf(this.name) + " already at Handoff Position.");
        }
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atOnline) {
            throw new BadCommandException(String.valueOf(this.name) + " is already at Online Position.");
        }
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.atStandby) {
            throw new BadCommandException(String.valueOf(this.name) + " is already at  Standby Position.");
        }
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument.", alias="mobeABSPos")
    @Deprecated
    public void moveToAbsoluteTargetPositionTested(int aValue) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException {
        if (aValue < this.minActualPositionValue || aValue > this.maxActualPositionValue) {
            throw new IllegalArgumentException(String.valueOf(this.name) + "argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        if (!this.linearRailMasterController.isEnabled()) {
            this.linearRailMasterController.enable();
        }
        if (!this.linearRailSlaveController.isEnabled()) {
            this.linearRailSlaveController.enable();
        }
        this.linearRailMasterController.releaseBrake();
        this.linearRailSlaveController.releaseBrake();
        this.linearRailMasterController.writeTargetPosition(aValue);
        this.linearRailMasterController.writeControlWord("3F");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the relative position given as argument.", alias="moveRELPos")
    @Deprecated
    public void moveToRelativeTargetPositionTested(int aValue) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException {
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.updatePosition();
        if (this.position + aValue < this.minActualPositionValue || this.position + aValue > this.maxActualPositionValue) {
            throw new IllegalArgumentException(String.valueOf(this.name) + "actual position + argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        if (!this.linearRailMasterController.isEnabled()) {
            this.linearRailMasterController.enable();
        }
        if (!this.linearRailSlaveController.isEnabled()) {
            this.linearRailSlaveController.enable();
        }
        this.linearRailMasterController.releaseBrake();
        this.linearRailSlaveController.releaseBrake();
        this.linearRailMasterController.writeTargetPosition(aValue);
        this.linearRailMasterController.writeControlWord("7F");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument.", alias="mobeABSPos")
    public void moveToAbsoluteTargetPosition(int aValue) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        if (aValue < this.minActualPositionValue || aValue > this.maxActualPositionValue) {
            throw new IllegalArgumentException(String.valueOf(this.name) + "argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.absoluteTargetPosition = aValue;
        fcslog.info((Object)(String.valueOf(this.name) + " going to absolute position: " + this.absoluteTargetPosition), new String[0]);
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the relative position given as argument.", alias="moveRELPos")
    public void moveToRelativeTargetPosition(int aValue) throws BadCommandException, SDORequestException, ShortResponseToSDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.updatePosition();
        if (this.position + aValue < this.minActualPositionValue || this.position + aValue > this.maxActualPositionValue) {
            throw new IllegalArgumentException(String.valueOf(this.name) + "actual position + argument has to be between " + this.minActualPositionValue + " and " + this.maxActualPositionValue);
        }
        this.relativeTargetPosition = aValue;
        fcslog.info((Object)(String.valueOf(this.name) + " going to relative position: " + this.relativeTargetPosition), new String[0]);
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_RELATIVE_POSITION, this.timeoutForTrucksMotion);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                if (!this.linearRailMasterController.isEnabled()) {
                    this.linearRailMasterController.enable();
                }
                if (!this.linearRailSlaveController.isEnabled()) {
                    this.linearRailSlaveController.enable();
                }
                this.linearRailMasterController.releaseBrake();
                this.linearRailSlaveController.releaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord("3F");
                break;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                if (!this.linearRailMasterController.isEnabled()) {
                    this.linearRailMasterController.enable();
                }
                if (!this.linearRailSlaveController.isEnabled()) {
                    this.linearRailSlaveController.enable();
                }
                this.linearRailMasterController.releaseBrake();
                this.linearRailSlaveController.releaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.relativeTargetPosition);
                this.linearRailMasterController.writeControlWord("7F");
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        fcslog.debug((Object)("Command running:" + currentCmdContext.getCommandName()), new String[0]);
        fcslog.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()), new String[0]);
        this.linearRailMasterController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.linearRailMasterController.off();
        fcslog.info((Object)(String.valueOf(this.name) + ":" + action.toString() + " completed - doing postAction."), new String[0]);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Read actual position and do the homing of the master controllerwith this actual position.")
    public void homing() throws SDORequestException, ErrorInCommandExecutionException, ShortResponseToSDORequestException, BadCommandException {
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailSlaveController.enable();
        fcslog.debug((Object)(String.valueOf(this.name) + "==> BEGIN homing of the trucks"), new String[0]);
        int ssiPosition = this.linearRailMasterController.readSSIPosition();
        int offset = ssiPosition - this.encoderRibbonMinValue;
        fcslog.debug((Object)(String.valueOf(this.name) + "position=" + ssiPosition + ",offset=" + offset), new String[0]);
        this.linearRailMasterController.defineAbsolutePosition(offset);
        this.linearRailMasterController.off();
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        fcslog.debug((Object)(String.valueOf(this.name) + "==> END homing of the trucks"), new String[0]);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() throws BadCommandException, SDORequestException {
        try {
            this.position = this.linearRailMasterController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + "=> ERROR IN READING CONTROLLER:" + ex.getMessage()), new String[0]);
        }
        this.publishData();
    }

    @Override
    public boolean isHardwareReady() {
        return this.autochanger.isHardwareReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                return this.position == this.relativeTargetPosition;
            }
        }
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.position = this.linearRailMasterController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + "=> SDO ERROR IN READING CONTROLLER:" + ex.toString()), new String[0]);
        }
        try {
            this.updateStateWithSensors();
        }
        catch (SDORequestException | ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + "=> SDO ERROR IN READING CONTROLLER:" + ex.getMessage()), new String[0]);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update Trucks state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    protected void updateStateWithSensors(String[] readHexaValues) throws FcsHardwareException {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensor0.updateValue(readHexaValues);
            this.handoffPositionSensor1.updateValue(readHexaValues);
            this.onlinePositionSensor0.updateValue(readHexaValues);
            this.onlinePositionSensor1.updateValue(readHexaValues);
            this.standbyPositionSensor0.updateValue(readHexaValues);
            this.standbyPositionSensor1.updateValue(readHexaValues);
            this.atHandoff = this.handoffPositionSensor0.getDigitalValue() == 1 && this.handoffPositionSensor1.getDigitalValue() == 1;
            this.atOnline = this.onlinePositionSensor0.getDigitalValue() == 1 && this.onlinePositionSensor1.getDigitalValue() == 1;
            this.atStandby = this.standbyPositionSensor0.getDigitalValue() == 1 && this.standbyPositionSensor1.getDigitalValue() == 1;
            this.handoffSensorsInError = this.handoffPositionSensor0.getDigitalValue() != this.handoffPositionSensor1.getDigitalValue();
            this.onlineSensorsInError = this.onlinePositionSensor0.getDigitalValue() != this.onlinePositionSensor1.getDigitalValue();
            this.standbySensorsInError = this.standbyPositionSensor0.getDigitalValue() != this.standbyPositionSensor1.getDigitalValue();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalInputOfLinearRails(EPOSController ctl) throws SDORequestException {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, "0005");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "30");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalOutputOfLinearRails(EPOSController ctl) throws SDORequestException {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "000F");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, "0002");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8005");
    }

    public StatusDataPublishedByAutoChangerTrucks getStatusData() {
        return FcsUtils.createStatusDataPublishedByAutoChangerTrucks(this);
    }

    @Override
    public void publishData() {
        StatusDataPublishedByAutoChangerTrucks status = this.getStatusData();
        this.publish("autochangerTrucks", status);
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        block28: {
            block25: {
                String errCode;
                EmergencyMessage emcyMsg;
                block26: {
                    String errCode2;
                    fcslog.debug((Object)(String.valueOf(this.name) + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()), new String[0]);
                    if (!(source instanceof CanOpenEPOS)) {
                        return;
                    }
                    if (!(v.getValue() instanceof EmergencyMessage)) break block25;
                    emcyMsg = (EmergencyMessage)v.getValue();
                    fcslog.debug((Object)(String.valueOf(this.name) + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()), new String[0]);
                    if (!this.linearRailMasterController.getName().equals(emcyMsg.getDeviceName())) break block26;
                    switch (errCode2 = emcyMsg.getDeviceErrorCode()) {
                        case "00": {
                            fcslog.debug((Object)(String.valueOf(this.name) + ":faultReset ?=" + emcyMsg.toString()), new String[0]);
                            this.masterControllerInFault = false;
                            break;
                        }
                        default: {
                            fcslog.debug((Object)(String.valueOf(this.name) + ":EmergencyMessage received for " + "master controller from CanOpenProxy=" + emcyMsg.toString()), new String[0]);
                            this.masterControllerInFault = true;
                        }
                    }
                    this.publishData();
                    break block28;
                }
                if (!this.linearRailSlaveController.getName().equals(emcyMsg.getDeviceName())) break block28;
                switch (errCode = emcyMsg.getDeviceErrorCode()) {
                    case "00": {
                        fcslog.debug((Object)(String.valueOf(this.name) + ":faultReset ?=" + emcyMsg.toString()), new String[0]);
                        this.slaveControllerInFault = false;
                        break;
                    }
                    default: {
                        fcslog.debug((Object)(String.valueOf(this.name) + ":EmergencyMessage received for " + "slave controller from CanOpenProxy=" + emcyMsg.toString()), new String[0]);
                        this.slaveControllerInFault = true;
                    }
                }
                this.publishData();
                break block28;
            }
            if (v.getValue() instanceof String) {
                CanOpenEPOS ctrl = (CanOpenEPOS)((Object)source);
                if (ctrl.getName().equals(this.linearRailMasterController.getName())) {
                    String msgFromController = (String)v.getValue();
                    if (msgFromController.equals("faultReset")) {
                        this.masterControllerInFault = false;
                        this.publishData();
                    } else if (msgFromController.equals("checkFault")) {
                        this.masterControllerInFault = this.linearRailMasterController.isInError();
                    }
                } else if (ctrl.getName().equals(this.linearRailSlaveController.getName())) {
                    String msgFromController = (String)v.getValue();
                    if (msgFromController.equals("faultReset")) {
                        this.slaveControllerInFault = false;
                        this.publishData();
                    } else if (msgFromController.equals("checkFault")) {
                        this.slaveControllerInFault = this.linearRailSlaveController.isInError();
                    }
                }
            }
        }
    }
}

