/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class AutoChangerModule
extends Module
implements HardwareController {
    private static final Logger fcslog = FcsUtils.log;
    private BridgeToHardware bridge;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    private final NumericSensor loaderConnectedSensor0;
    private final NumericSensor loaderConnectedSensor1;
    AutoChangerTrucksModule trucks;
    AutochangerTwoLatches latches;
    CarouselModule carousel;
    LoaderModule loader;
    private boolean loaderConnected;
    private boolean loaderConnectedSensorsInError;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public AutoChangerModule(String name, int tickMillis, String plutoGatewayName, NumericSensor loaderConnectedSensor0, NumericSensor loaderConnectedSensor1, AutoChangerTrucksModule trucks, AutochangerTwoLatches latches) {
        super(name, tickMillis);
        this.plutoGatewayName = plutoGatewayName;
        this.loaderConnectedSensor0 = loaderConnectedSensor0;
        this.loaderConnectedSensor1 = loaderConnectedSensor1;
        this.trucks = trucks;
        this.latches = latches;
        this.loaderConnected = false;
        this.loaderConnectedSensorsInError = false;
    }

    public NumericSensor getLoaderConnectedSensor0() {
        return this.loaderConnectedSensor0;
    }

    public NumericSensor getLoaderConnectedSensor1() {
        return this.loaderConnectedSensor1;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant loader sensors are equal.")
    public boolean isLoaderConnectedSensorsInError() {
        return this.loaderConnectedSensorsInError;
    }

    public int getHandoffPosition() {
        return this.trucks.getHandoffPosition();
    }

    public int getOnlinePosition() {
        return this.trucks.getOnlinePosition();
    }

    public int getStandbyPosition() {
        return this.trucks.getStandbyPosition();
    }

    public AutochangerTwoLatches getLatches() {
        return this.latches;
    }

    public AutoChangerTrucksModule getTrucks() {
        return this.trucks;
    }

    public PlutoGatewayModule getPlutoGateway() {
        return this.plutoGateway;
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
        this.bridge = (BridgeToHardware)this.getModule("bridge");
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.loader = (LoaderModule)this.getModule("loader");
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized and bridge is hardwareReady.")
    public boolean isHardwareReady() {
        return this.bridge.isHardwareReady() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.trucks.isInitialized();
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        fcslog.debug((Object)(String.valueOf(this.name) + " checking hardware."), new String[0]);
        try {
            this.plutoGateway.initializeHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.trucks.checkHardware();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void checkStarted() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + " BEGIN checkStarted"), new String[0]);
        this.bridge.getTcpProxy().checkNewHardware();
        try {
            this.plutoGateway.initializeHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.trucks.checkHardware();
    }

    public void checkStopped() throws HardwareException {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public boolean checkPreConditionsForOpeningLatches() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for opening latches"), new String[0]);
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            String msg = String.valueOf(this.name) + ": no filter in autochanger - can't open latches.";
            log.error((Object)msg, new String[0]);
            throw new FcsHardwareException(msg);
        }
        if (!this.trucks.isAtStandbyPosition() && !this.trucks.isAtHandoffPosition()) {
            String msg = String.valueOf(this.name) + ": autochanger is loaded with a filter but is not " + "at handoff position neither at standby - can't open clamp.";
            log.error((Object)msg, new String[0]);
            throw new BadCommandException(msg);
        }
        if (this.trucks.isAtStandbyPosition() && !this.carousel.isHoldingFilterAtStandby()) {
            String msg = String.valueOf(this.name) + ": autochanger is loaded with a filter and is  " + "at STANDBY position but carousel doesn't hold the filter " + "- can't open latches.";
            log.error((Object)msg, new String[0]);
            throw new BadCommandException(msg);
        }
        if (this.trucks.isAtHandoffPosition() && !this.loaderIsHoldingFilterAtHandoff()) {
            String msg = String.valueOf(this.name) + ": autochanger is loaded with a filter and is  " + "at HANDOFF position but loader doesn't hold the filter " + "- can't open latches.";
            log.error((Object)msg, new String[0]);
            throw new BadCommandException(msg);
        }
        if (this.trucks.isAtStandbyPosition() && this.carousel.isHoldingFilterAtStandby()) {
            return true;
        }
        return this.trucks.isAtHandoffPosition() && this.loaderIsHoldingFilterAtHandoff();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be closed.")
    public boolean checkPreConditionsForClosingLatches() throws FcsHardwareException, BadCommandException {
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            String msg = String.valueOf(this.name) + ": no filter in autochanger - can't open latches.";
            log.error((Object)msg, new String[0]);
            throw new FcsHardwareException(msg);
        }
        if (!this.trucks.isAtStandbyPosition() && !this.trucks.isAtHandoffPosition()) {
            String msg = String.valueOf(this.name) + ": autochanger is not " + "at handoff position neither at standby - can't close latches.";
            log.error((Object)msg, new String[0]);
            throw new BadCommandException(msg);
        }
        return true;
    }

    boolean loaderIsHoldingFilterAtHandoff() throws BadCommandException, FcsHardwareException {
        if (this.loaderConnected) {
            return this.loader.isHoldingAFilter();
        }
        return false;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        if (!this.plutoGateway.isBooted()) {
            throw new FcsHardwareException(String.valueOf(this.name) + ": plutoGateway not booted - can't read sensors");
        }
        if (!this.plutoGateway.isInitialized()) {
            throw new FcsHardwareException(String.valueOf(this.name) + ": plutoGateway not initialized - can't read sensors");
        }
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            fcslog.finest((Object)("readHexaValues[0]=" + readHexaValues[0]), new String[0]);
            fcslog.finest((Object)("readHexaValues[1]=" + readHexaValues[1]), new String[0]);
            this.loaderConnectedSensor0.updateValue(readHexaValues);
            this.loaderConnectedSensor1.updateValue(readHexaValues);
            this.loaderConnected = this.loaderConnectedSensor0.getDigitalValue() == 1 && this.loaderConnectedSensor1.getDigitalValue() == 1;
            this.loaderConnectedSensorsInError = this.loaderConnectedSensor0.getDigitalValue() != this.loaderConnectedSensor1.getDigitalValue();
            this.trucks.updateStateWithSensors(readHexaValues);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
            this.trucks.publishData();
        }
    }

    boolean isAtHandoff() {
        return this.trucks.isAtHandoffPosition();
    }

    boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void goToHandOff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        this.trucks.goToHandOff();
    }

    void grabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void ungrabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void moveFilterToHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void grabFilterAtStandby(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void tick() {
        this.publishData();
    }

    public StatusDataPublishedByAutoChanger getStatusData() {
        StatusDataPublishedByAutoChanger status = FcsUtils.createStatusDataPublishedByAutoChanger(this);
        return status;
    }

    public void publishData() {
        StatusDataPublishedByAutoChanger status = this.getStatusData();
        this.publish("autochangerGeneral", status);
    }
}

