/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerTrucksConfig;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderHookConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ActuatorConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.FilterLatch;
import org.lsst.ccs.subsystems.fcs.testbench.CPPMTestBenchMainModule;
import org.lsst.ccs.subsystems.fcs.testbench.LoaderTestBenchMainModule;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author turri
 */
public class FcsUtils {
    
    /* A Logger for all the subsystem FCS.*/
    public static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
         /**
         ******************************************************************************
         **  Methods to create Config Objects to be used by the GUI.
         ******************************************************************************
         */ 
    
    /**
     * For the single-filter-test
     */
    
    /**
     * For the single-filter-test
     * @param main
     * @return 
     */
    public static SingleFilterTestConfig createSingleFilterTestConfig(SftMainModule main) {
        CarouselModule carouselModule = main.getCarouselModule();
        boolean controlRealHardware = main.controlRealHardware();
        BasicAutoChangerModule autochanger = (BasicAutoChangerModule)main.getAutoChangerModule();
        return new SingleFilterTestConfig(controlRealHardware,
                createClampConfig(carouselModule.getClampXminus()), 
                createClampConfig(carouselModule.getClampXplus()), 
                createActuatorConfig((Actuator)(carouselModule.getClampActuatorXminus())),
                createActuatorConfig((Actuator)(carouselModule.getClampActuatorXplus())),
                createActuatorConfig((LatchActuatorModule)(((FilterLatchModule)autochanger.getLatchXminus()).getLatchActuator())),
                createActuatorConfig((LatchActuatorModule)(((FilterLatchModule)autochanger.getLatchXplus()).getLatchActuator()))
                );
    }
    

    
    /**
     * For the Carousel configonfiglamp 
     * @param filterModule
     * @return 
     */
    public static ClampConfig createClampConfig(FilterClampModule filterModule) {
        return new ClampConfig(filterModule.getName(), filterModule.getFilterPositionValueA(), filterModule.getFilterPositionValueB(),
                filterModule.getFilterPositionValueC(), filterModule.getLockSensorValueA(), filterModule.getLockSensorValueB(), filterModule.getLockSensorValueC(),
                filterModule.getFilterPositionMinValue(),filterModule.getFilterPositionMaxValue(),
                filterModule.getLockSensorMinValue(), filterModule.getLockSensorMaxValue());
    }
    
    public static ActuatorConfig createActuatorConfig(Actuator actuator) {
        return new ActuatorConfig(
                actuator.getSentCurrentMinValue(),
                actuator.getSentCurrentMaxValue()
                );
    }
    
    public static ActuatorConfig createActuatorConfig(LatchActuatorModule actuatorModule) {
        return new ActuatorConfig(
                actuatorModule.getSpeedVoltageMinValue(),
                actuatorModule.getSpeedVoltageMaxValue()
                );
    }
    
     /***************************
     * Config for the autochanger
     ****************************
     */
    /**
     * For the Autochanger Main Module when autochanger is at standalone.
     * @param main
     * @return 
     */
    public static AutochangerConfig createAutochangerConfig(AutochangerMainModule main) {
        AutochangerConfig config = new AutochangerConfig(main.controlRealHardware(),
                createCanOpenProxyConfig(main.getTcpProxy()));
        config.setLinearRailMasterControllerConfig(createEPOSControllerConfig(main.getLinearRailMasterController()));
        config.setLinearRailSlaveControllerConfig(createEPOSControllerConfig(main.getLinearRailSlaveController()));
        config.setLatchXminusControllerConfig(createEPOSControllerConfig(main.getLatchXminusController()));
        config.setLatchXplusControllerConfig(createEPOSControllerConfig(main.getLatchXplusController()));
        //config.setOnlineClampControllerConfig(createEPOSControllerConfig(main.getOnlineClampController()));
        config.setTrucksConfig(createAutochangerTrucksConfig(main.getAutochangerTrucks()));
        config.setGwConfig(createPlutoGatewayConfig(main.getPlutoGateway()));
        return config;
    }
    
    /**
     * For the CPPM Test Bench Main Module.
     * @param main
     * @return 
     */
    public static AutochangerConfig createAutochangerConfig(CPPMTestBenchMainModule main) {
        AutochangerConfig config = new AutochangerConfig(main.controlRealHardware(),
                createCanOpenProxyConfig(main.getTcpProxy()));
        log.debug("AutochangerConfig created.");
        config.setLinearRailMasterControllerConfig(createEPOSControllerConfig(main.getLinearRailMasterController()));
        config.setLinearRailSlaveControllerConfig(createEPOSControllerConfig(main.getLinearRailSlaveController()));
        config.setOnlineClampControllerConfig(createEPOSControllerConfig(main.getOnlineClampController()));
        config.setTrucksConfig(createAutochangerTrucksConfig(main.getAutochangerTrucks()));
        config.setGwConfig(createPlutoGatewayConfig(main.getPlutoGateway()));
        return config;
    }
    
    public static AutochangerTrucksConfig createAutochangerTrucksConfig(AutoChangerTrucksModule acTrucks) {
        AutochangerTrucksConfig config = new AutochangerTrucksConfig(acTrucks.getName());
        config.setHandoffPosition(acTrucks.getHandoffPosition());
        config.setOnlinePosition(acTrucks.getOnlinePosition());
        config.setStandbyPosition(acTrucks.getStandbyPosition());
        config.setTimeoutForTrucksMotion(acTrucks.getTimeoutForTrucksMotion());
        return config;
    }
    
    public static PlutoGatewayConfig createPlutoGatewayConfig(PlutoGatewayModule gw) {
        PlutoGatewayConfig config = new PlutoGatewayConfig(gw.getName());
        return config;
    }

    
    /***************************
     * Config for the loader
     ***************************
     */
    
    /**
     * 
     * @param main
     * @return loader Config 
     */
    public static LoaderConfig createLoaderConfig(LoaderTestBenchMainModule main) {
        LoaderConfig config = new LoaderConfig(main.controlRealHardware(), 
                createLoaderClampConfig(main.getLoader().getClamp()), 
                createLoaderCarrierConfig(main.getLoader().getCarrier()),
                createCanOpenProxyConfig(main.getTcpProxy()));
//        log.debug("FcsUtils hooksController==>" + main.getLoader().getHooksController().toString());
//        log.debug("FcsUtils carrierController==>" + main.getLoader().getCarrierController().toString());
        EPOSControllerConfig clampControllerConfig = createEPOSControllerConfig(main.getLoader().getHooksController());
        EPOSControllerConfig carrierControllerConfig = createEPOSControllerConfig(main.getLoader().getCarrierController());
//        log.debug("FcsUtils hooksControllerConfig==>" + clampControllerConfig.toString());
//        log.debug("FcsUtils carrierControllerConfig==>" + carrierControllerConfig.toString());
        config.setLoaderCarrierControllerConfig(createEPOSControllerConfig(main.getLoader().getCarrierController()));
        config.setLoaderClampControllerConfig(clampControllerConfig);
        config.setLoaderCarrierControllerConfig(carrierControllerConfig);
        return config;
    }
    
    public static LoaderClampConfig createLoaderClampConfig(LoaderClampModule clamp) {
        return new LoaderClampConfig(clamp.getMinPosition(),
                clamp.getMaxPosition(),
                clamp.getMinCurrent(),
                clamp.getMaxCurrent(),
                clamp.getTargetPositionToOpen(),
                clamp.getTargetPositionToClose(),
                clamp.getTargetPositionToClamp(),
                clamp.getTimeoutForOpeningHooks(),
                clamp.getTimeoutForClosingHooks(),
                clamp.getTimeoutForClampingHooks(),
                clamp.getTimeoutForGoingToHomePosition(),
                createLoaderHookConfig(clamp.getHook1()), 
                createLoaderHookConfig(clamp.getHook2()), 
                createLoaderHookConfig(clamp.getHook3()), 
                createLoaderHookConfig(clamp.getHook4()));      
    }
    
    public static LoaderHookConfig createLoaderHookConfig(LoaderHookModule hook) {        
        LoaderHookConfig loaderHookConfig = new LoaderHookConfig(hook.getName(), 
                hook.getLockSensor().getDigitalValue(),
                hook.getUnlockSensor().getDigitalValue(),
                hook.isInError());
        return loaderHookConfig;
        
    }
    
    public static LoaderCarrierConfig createLoaderCarrierConfig(LoaderCarrierModule carrier) {
        return new LoaderCarrierConfig(carrier.getName(),
                carrier.getHandoffPosition(),carrier.getStoragePosition(), 
                carrier.getMaxCurrent(),carrier.getMaxSpeed(),
                carrier.getTimeoutForGoingToHandOff(),
                carrier.getTimeoutForGoingToStorage()
            );
    }
    
     /*************************************
     * Config for all the FCS subsystems
     **************************************
     */
    
    /**
     * 
     * @param tcpProxy
     * @return 
     */
    public static CanOpenProxyConfig createCanOpenProxyConfig(CanOpenProxy tcpProxy) {
        if (tcpProxy == null) 
            throw new IllegalArgumentException("FcsUtils : tcpProxy is null - can't create CanOpenProxyConfig");
        CANopenHardwareConfig[] hardwareConfigList = 
                new CANopenHardwareConfig[tcpProxy.getHardwareList().length];
        for (int i=0; i<tcpProxy.getHardwareList().length; i++) {
            PieceOfHardware hard = tcpProxy.getHardwareList()[i];
            hardwareConfigList[i] = new CANopenHardwareConfig(hard.getName(),
                    hard.getNodeID(),hard.getSerialNB(),
                    hard.isBooted(),hard.isInitialized());
        }
        return new CanOpenProxyConfig(tcpProxy.getMyClientName(),
                tcpProxy.getPortNumber(), 
                tcpProxy.getExpectedNodesNB(),
                tcpProxy.getHardwareBootTimeout(),
                hardwareConfigList);
    }
    
        /**
     * Create an objeconfigonfigt EPOSControllerConfig
     * @param ctl
     * @return 
     */
    public static EPOSControllerConfig createEPOSControllerConfig(EPOSController ctl) {
        EPOSControllerConfig config = new EPOSControllerConfig(ctl.getName());
        config.setParamsForCurrent(ctl.getParamsForCurrent());
        config.setParamsForProfilePosition(ctl.getParamsForProfilePosition());
        config.setParamsForHoming(ctl.getParamsForHoming());
        return config;
    }
         /**
         ******************************************************************************
         **  end of Methods to create Config Objects to be used by the GUI.
         ******************************************************************************
         */    
         /**
         ******************************************************************************
         **  Methods to create Objects to publish data.
         *   To be stored in the trending database and update the GUI.
         ******************************************************************************
         */
    /**
     * 
     * @param basicAutoChanger
     * @return 
     */
    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty()); 
        //status.setTrucksLocation(basicAutoChanger.getLastTrucksLocation());        
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }
    
    public static StatusDataPublishedByAutoChanger  createStatusDataPublishedByAutoChanger(AutoChangerModule ac) {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
//        status.setTrucksEmpty(autochanger.isTrucksEmpty());
//        status.setTrucksLocation(autochanger.getTrucksLocation());
//        status.setIsLockedOnlineClamp(autochanger.getOnlineClamp().isLocked());
        status.setName(ac.getName());
        status.setLoaderConnectedSensorValue0(ac.getLoaderConnectedSensor0().getDigitalValue());
        status.setLoaderConnectedSensorValue1(ac.getLoaderConnectedSensor1().getDigitalValue());
        status.setLoaderConnectedSensorsInError(ac.isLoaderConnectedSensorsInError());
        return status;
    }
    
    public static StatusDataPublishedByAutoChangerTrucks  createStatusDataPublishedByAutoChangerTrucks(AutoChangerTrucksModule acTrucks) {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setName(acTrucks.getName());
        s.setPosition(acTrucks.getPosition());
        s.setMasterControllerInFault(acTrucks.isMasterControllerInFault());
        s.setSlaveControllerInFault(acTrucks.isSlaveControllerInFault());
        s.setCurrent(acTrucks.getCurrent());
        s.setSpeed(acTrucks.getSpeed());
        s.setHandoffInError(acTrucks.isHandoffSensorsInError());
        s.setOnlineInError(acTrucks.isOnlineSensorsInError());
        s.setStandbyInError(acTrucks.isStandbySensorsInError());
        s.setHandoffSensorValue0(acTrucks.getHandoffPositionSensor0().getDigitalValue());
        s.setHandoffSensorValue1(acTrucks.getHandoffPositionSensor1().getDigitalValue());
        s.setOnlineSensorValue0(acTrucks.getOnlinePositionSensor0().getDigitalValue());
        s.setOnlineSensorValue1(acTrucks.getOnlinePositionSensor1().getDigitalValue());
        s.setStandbySensorValue0(acTrucks.getStandbyPositionSensor0().getDigitalValue()); 
        s.setStandbySensorValue1(acTrucks.getStandbyPositionSensor1().getDigitalValue());        
        return s;
    }
    
    
    public static StatusDataPublishedByCarousel createStatusDataPublishedByCarousel(CarouselModule carousel) {
        int nbSockets = carousel.getNbSockets();
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel(nbSockets); 
        status.setRotationInDegrees(carousel.getPosition());
        status.setIsLocked(carousel.isLocked());
        
        
        for (int i = 0; i < nbSockets; i++) {
            status.setFilterName(i, carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName());
            
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            //status.setClampsInfo(i, sb.toString());
            
        }
        status.setFilterInStandbyName(carousel.getFilterInStandbyName());

        status.setActuatorXminusState(carousel.getClampActuatorXminus().toString());
        status.setActuatorXplusState(carousel.getClampActuatorXplus().toString());
        return status;
    }
    

    public static StatusDataPublishedByClamp createStatusDataPublishedByClamp(FilterClampModule clamp) {
        StatusDataPublishedByClamp status = new StatusDataPublishedByClamp();
        status.setName(clamp.getName());
        status.setClampState(clamp.getClampState().toString());
        status.setFilterPositionInClamp(clamp.getFilterPresenceStatus().toString());
        status.setFilterPositionSensorValue(clamp.getFilterPresenceSensor().getValue());
        status.setLockSensorValue(clamp.getLockSensor().getValue());
        status.setLockStatus(clamp.getLockStatus().toString());      
        status.setTemperature(clamp.getTemperature());
        return status;
    }
    
    public static StatusDataPublishedByClampActuator createStatusDataPublishedByClampActuator(Actuator actuator) {
        StatusDataPublishedByClampActuator status = new StatusDataPublishedByClampActuator();
        status.setName(actuator.getName());
        status.setReadValue(actuator.getReadActualCurrent());
        status.setSentValue(actuator.getSentCurrentValue());
        status.setOn(actuator.isOn());
        return status;
    }
        
    public static StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch(FilterLatch latch) {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPresenceSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus().toString());
        status.setControllerInFault(latch.isControllerInFault());
        return status;
    }
    
    public static StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches(AutochangerTwoLatches latches) {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setLockStatus(latches.getLockStatus());
        status.setFilterPresenceStatus(latches.getFilterPresenceStatus());
        return status;
    }   
    
    public static StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp(LoaderClampModule clamp) {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(clamp.getName());
        status.setPosition(clamp.getPosition());
        status.setCurrent(clamp.getReadCurrent());
        status.setClampState(clamp.getLockStatus().toString());
        status.setStatusPublishedByHook1(createStatusDataPublishedByLoaderHook(clamp.getHook1()));
        status.setStatusPublishedByHook2(createStatusDataPublishedByLoaderHook(clamp.getHook2()));
        status.setStatusPublishedByHook3(createStatusDataPublishedByLoaderHook(clamp.getHook3()));
        status.setStatusPublishedByHook4(createStatusDataPublishedByLoaderHook(clamp.getHook4()));
        return status;
    }

    private static StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook(LoaderHookModule hook) {
        StatusDataPublishedByLoaderHook status = new StatusDataPublishedByLoaderHook(hook.getName(),
                hook.getLockSensor().getDigitalValue(),
                hook.getUnlockSensor().getDigitalValue(),
                hook.isInError(),
                hook.getLockStatus().toString()
            );     
        return status;
    }
    
    public static StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier(LoaderCarrierModule carrier) {
        StatusDataPublishedByLoaderCarrier status = 
                new StatusDataPublishedByLoaderCarrier(carrier.getName(),
                    carrier.getPosition(),carrier.getSsiPosition(),
                    carrier.getSpeed(), carrier.getCurrent(),
                    carrier.getStoragePositionSensor0().getDigitalValue(),
                    carrier.getStoragePositionSensor1().getDigitalValue(),
                    carrier.getHandoffPositionSensor0().getDigitalValue(),
                    carrier.getHandoffPositionSensor1().getDigitalValue(),
                    carrier.isStorageSensorsInError(),
                    carrier.isHandoffSensorsInError(),
                    carrier.isControllerInFault());
        status.setLimitSwitchDownInError(carrier.isLimitSwitchDownInError());
        status.setLimitSwitchUpInError(carrier.isLimitSwitchUpInError());
        return status;
    }
    
    public static StatusDataPublishedByLoader createStatusDataPublishedByLoader(LoaderModule loader) {
        StatusDataPublishedByLoader status = new StatusDataPublishedByLoader();
        status.setName(loader.getName());
        status.setAutochangerHoldingFilterSensorValue(loader.getAutochangerHoldingFilterSensor().getDigitalValue());
        status.setFilterPresenceSensorValue0(loader.getFilterPresenceSensor0().getDigitalValue());
        status.setFilterPresenceSensorValue1(loader.getFilterPresenceSensor1().getDigitalValue());
        status.setFilterPresenceSensorsInError(loader.isFilterPresenceSensorsInError());
        status.setLoaderOnCameraSensorValue0(loader.getLoaderOnCameraSensor0().getDigitalValue());
        status.setLoaderOnCameraSensorValue1(loader.getLoaderOnCameraSensor1().getDigitalValue());
        status.setLoaderOnCameraSensorsInError(loader.isLoaderOnCameraSensorsInError());
        status.setLoaderSubsystemState(loader.getSubsystemState());
        return status;
    }
    
    public static StatusDataPublishedByHardware createStatusDataPublishedByHardware(PieceOfHardware device) {       
        StatusDataPublishedByHardware status = new StatusDataPublishedByHardware(device.getName(),
            device.isBooted(),device.isInitialized()); 
        return status;
    }
    
    public static StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController(EPOSController ctlr) {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController();
        status.setName(ctlr.getName());
        status.setBooted(ctlr.isBooted());
        status.setInitialized(ctlr.isInitialized());
        status.setEnabled(ctlr.isEnabledToPublish());
        status.setInError(ctlr.isInError());
        status.setErrorRegister(ctlr.getErrorRegister());
        status.setErrorHistory(ctlr.getErrorHistory());
        status.setMode(ctlr.getModeInString());
        return status;
    }
         /*******************************************************************************
         **  end of Methods to create Objects to publish data.
         ******************************************************************************
         */
    

    /**
     *
     * @param bin
     * @return
     */
    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    /**
     * The String argument represents an integer in hexa.
     * This methods returns a string representation of this integer argument as 
     * an unsigned integer in base 2.
     * @param Hex
     * @return the binary form of this integer with 8 digits
     * examples :
     * HexToBinary(4)  returns 00000100
     * HexToBinary(AA) returns 10101010
     * HexToBinary(FF) returns 11111111
     */
    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }
    
        /**
     * The String argument represents an integer in hexa.
     * This methods returns a string representation of this integer argument as 
     * an unsigned integer in base 2.
     * @param twoBytesInHexa
     * @return the binary form of this integer with 16 digits
     * examples :
     * twoBytesInHexaToBinary("4")  returns 0000000000000100
     * twoBytesInHexaToBinary("AA") returns 0000000010101010
     * twoBytesInHexaToBinary("FFFF") returns 1111111111111111
     */
    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }
    
    /**
     * Takes an integer represented by 2 bytes in hexa as argument,  
 transforms is its binary representation,
 replaconfigonfiges the bit at position bitPosition by digit given as argument. 
     * and returns the new hexa value.
     * @param twoBytesInHexa
     * @param bitPosition
     * @param digit
     * @return 
     */
    public static String replaceDigit(String twoBytesInHexa, int bitPosition, String digit ) {
            if (bitPosition < 0 || bitPosition > 15) 
                throw new IllegalArgumentException("replaceDigit:  bitPosition must be: 0< bitPosition <15");
            if (!(digit.equals("0")||digit.equals("1")))
                throw new IllegalArgumentException("replaceDigit:  digit must 0 or 1");
            StringBuilder bin = new StringBuilder(FcsUtils.twoBytesInHexaToBinary(twoBytesInHexa));
            bin.replace(15 - bitPosition, 15 - bitPosition + 1, digit);
            return Integer.toHexString(Integer.parseInt(bin.toString(), 2));
    }
    
    /**
     * Transforms a numericonfigonfig value given in hexa to binary and replaconfigonfige the 
 digit in position pos given as argument by 0.
     * @param hexaVal
     * @param pos
     * @return 
     */
    public static String force2zero(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) 
                throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        int intVal = Integer.parseInt(hexaVal,16);
        StringBuilder sb = new StringBuilder();
        for (int i=0; i<16; i++) {
            sb.append('1');
        }
        sb.setCharAt(16-(pos+1), '0');
        int mask = Integer.parseInt(sb.toString(),2);

        int myNewVal = intVal & mask;
        return Integer.toHexString(myNewVal);
    }
    
    
     /**
     * Transforms a numericonfigonfig value given in hexa to binary and replaconfigonfige the 
 digit in position pos given as argument by 1.
     * @param hexaVal
     * @param pos
     * @return 
     */    
    public static String force2one(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) 
                throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        int intVal = Integer.parseInt(hexaVal,16);
        
        StringBuilder sb = new StringBuilder();
        for (int i=0; i<16; i++) {
            sb.append('0');
        }
        sb.setCharAt(16-(pos+1), '1');
        int mask = Integer.parseInt(sb.toString(),2);

        int myNewVal = intVal | mask;
        return Integer.toHexString(myNewVal);
    }
    
    /**
     * Transform an integer given in its deconfigonfigimal format to its binary format, 
 reverse it and returns the reversed binary at an array of int.
     * format.
     * @param decimal
     * @return an array of int
     */
    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];

        for (int i=0; i<16; i++) {
            int bit = (decimal >> i) & 0x1;
            tab[i]= bit;
        }
        return tab;
    }
    





    



    

    
}
