/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;


/**
 * Main Module for the test bench in LPC in Clermont-Ferrand.
 * @author virieux
 */
public class Scale1ProtoTestBenchMainModule extends MainModule {
    
    
    private final HygrometrySensor hygrometrySensor;
    private final PressureSensor pressureSensor;
    private final Thermometer thermometer;
    private final Scale1ProtoPivotingFrame pivotingFrame;
    private final LPCInclinometerModule inclinometer;
    
    
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final Thermometer fakeSensor;
    
    public double temperature;
    public double pressure;
    public double hygrometry;



    public Scale1ProtoTestBenchMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge, 
            HygrometrySensor hygrometrySensor, 
            PressureSensor pressureSensor, 
            Thermometer thermometer, 
            CanOpenLED led, 
            CanOpenLED fakeLed, 
            Thermometer fakeSensor,
            Scale1ProtoPivotingFrame pivotingFrame,
            LPCInclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.hygrometrySensor = hygrometrySensor;
        this.pressureSensor = pressureSensor;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.pivotingFrame = pivotingFrame;
        this.inclinometer = inclinometer;
    }
    
    /**
     * Read hygrometry on the gauge and returns its values in decimal format.
     * @return hygrometry
     * @throws FcsHardwareException 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, 
            description="Read hygrometry on the gauge and returns its values "
                    + "in decimal format.")
    public double readHygrometry() throws FcsHardwareException {
        this.hygrometry = this.hygrometrySensor.readHygrometry();
        return this.hygrometry;
    }
    
      /**
     * Read pressure on the gauge and returns its values in decimal format.
     * @return pressure 
     * @throws FcsHardwareException 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, 
            description="Read pressure on the gauge and returns its values "
                    + "in decimal format.")
    public double readPressure() throws FcsHardwareException {
        this.pressure = this.pressureSensor.readPressure();
        return this.pressure;
    }
    
      /**
     * Read temperature on the gauge and returns its values in decimal format.
     * @return temperature
     * @throws FcsHardwareException 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, 
            description="Read temperature on the gauge and returns its values "
                    + "in decimal format.")
    public double readTemperature() throws FcsHardwareException {
        this.temperature = this.thermometer.readTemperature();
        return this.temperature;
    }
    
    /**
     * Turn On the led.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Turn On the led.")
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnON();
    }
    
        /**
     * Turn Off the led.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Turn Off the led.")
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        return led.turnOFF();       
    }
    
    public String turnOnFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnON();       
    }
    
    public String turnOffFakeLED() throws SDORequestException, HardwareNotDetectedException {
        return fakeLed.turnOFF();       
    }
    
    public double readFakeSensor() throws FcsHardwareException, BadCommandException {
//        CanOpenProxy.PDOStorage pdoStore = this.bridge.readPDOs();
//        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
        return this.fakeSensor.readTemperature();
    }
    
    /**
     * Rotate camera around axe Z within angle value given as argument.
     * This rotation is around axe Z.
     * @param angle 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Rotate camera around axe Z with angle value given as argument.")
    public void rotateCamera(long angle) {
        this.pivotingFrame.rotateCamera(angle);
    }
    
     /**
     * Rotate camera around axe X within angle value given as argument.
     * This rotation is around axe X.
     * @param angle 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Rotate camera around axe X with angle value given as argument.")
    public void rotateX(long angle) {
        this.pivotingFrame.rotateX(angle);
    }
    
    @Override
    public void tick() {
        try {
            readTemperature();
            readPressure();
            readHygrometry();            
            this.publish("temperature", this.temperature);
            this.publish("hygrometry", this.hygrometry);
            this.publish("pressure", this.pressure);
            
        } catch (FcsHardwareException ex) {
            fcslog.debug(getName() + "couldn't read sensors");
        }
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        //TODO put here the code to read the testbench sensors.
    }
    
    
    
}
