/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.LoaderDisconnectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Thois soft is to test the FCS with 2 CAN BUS :
 * - one for the carousel and the autochanger
 * - one for the loader
 * @author virieux
 */
public class APCTestBench2CanBusMain extends MainModule {
    
    
     /**
     * this bridge is to communicate with the canbus1 on the PC104
     */
    protected BridgeToHardware bridgeToLoader;
    
        /*** The thermometer mesures the temperature inside the clamp.
    */
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;
    
    public double temperature;
    
    boolean ledOn;
    
    

    public APCTestBench2CanBusMain(String aName, int aTickMillis, BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public APCTestBench2CanBusMain(String aName, int aTickMillis, 
            BridgeToHardware bridge, 
            BridgeToHardware bridgeToLoader, 
            Thermometer thermometer, 
            CanOpenLED led, 
            CanOpenLED fakeLed, 
            Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.ledOn = false;
    }
       
    public boolean isChangerConnected() {
        return this.bridge.isCWrapperConnected();
    }
    
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isCWrapperConnected();
    }
    
    public boolean isChangerReady() {
        return this.bridge.isHardwareReady();
    }
    
    public boolean isLoaderReady() {
        return this.bridgeToLoader.isHardwareReady();
    }
    
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.getTcpProxy().disconnectHardware();
    }
    
    public void connectLoader() throws BadCommandException, HardwareException {
        this.bridgeToLoader.getTcpProxy().connectHardware();
    }
    
    
    public double readTemperature() throws FcsHardwareException, LoaderDisconnectedException  {      
        try {
            return this.thermometer.readTemperature();
        } catch (FcsHardwareException ex) {
            if (ex instanceof HardwareNotDetectedException) {
                throw new LoaderDisconnectedException(ex.getMessage());
            }
        }
        return 0;
    }
    
    @Override
    public void tick() {
        try {
            if (ledOn) turnOffLED(); 
            else turnOnLED();
        } catch (SDORequestException ex) {
            log.error(name + ex);
        } catch (HardwareNotDetectedException ex) {
            log.error(name + ex);
            this.getSubsystem().raiseAlarm(ex.toString());
        }
    }
    
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException {
        led.turnON();
        ledOn = true;
        return "LED is turned ON";
    }
    

    
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException {
        led.turnOFF();
        ledOn = false;
        return "LED is turned OFF";        
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
//        try {
//            this.temperature = readTemperature();
//        } catch (LoaderDisconnectedException ex) {
//            throw ex;
//        }
    }
    
    
    
}
