/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Sensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This represents a device we use in FCS to connect our numeric sensors(CAN-CBX-DIO8).
 * It has 8 channels. Each channel can be configured to be inputs or output channel.
 * So we can plug up to 8 sensors on one CampactIOModule.
 * We read all the inputs channels in the same commands.
 * This class should be extended for the real hardware and for the simulated hardware.
 * 
 * @author virieux
 */
public abstract class CompactIOModule extends Module implements Sensor {
    
    protected static final Logger fcslog = FcsUtils.log;
    
    public String hexaValue;
    
   //updatingValue is true while we are reading the value sent by the Sensor
   //this could take some time
   volatile boolean updatingValue = false;
   final Lock lock = new ReentrantLock();
   final Condition valueUpdated = lock.newCondition();
        
    @Override
   public void initModule() {
       this.hexaValue = "00";
   }
    
    /**
     * 
     * @return a String which is the value in hexa sent by the device.
     */
    abstract public String readNewHexaValue ();
    
    /**
     * @return the hexa value converted in decimal.
     */
    public String getHexaValue() {
       lock.lock();
       try {
           while (updatingValue) {
                try {
                    //TODO put a timeout
                    valueUpdated.await();
                } catch (InterruptedException ex) {
                    fcslog.error(getName() + ex.getMessage());
      
                }
           }
           return this.hexaValue;
       } finally {
           lock.unlock();
       }
    }
   
    
    
    /**
     * @return the hexa value converted in decimal.
     */
    @Override
    public int getValue() {
        fcslog.debug(getName() + Integer.parseInt(getHexaValue(), 16));
        return Integer.parseInt(getHexaValue(), 16);
    }

    
    @Override
    public void updateValue() {
       lock.lock();       
       
       
       try {
            updatingValue = true;
            this.hexaValue = readNewHexaValue();
            fcslog.debug(getName() + " HEXA VALUE READ=" + this.hexaValue);

       } finally {
           

           updatingValue = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }
    
    
    
}
