/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This class simulates the Can Open PLuto Gateway we use to communicate with the
 * sensors in the whole size prototype.
 * @author virieux
 */
public class SimuPlutoGateway extends PlutoGatewayModule implements PieceOfHardware {
    CanOpenDevice deviceDelegate;
    

    public SimuPlutoGateway(String name, int tickMillis,
            String nodeID, String serialNB) {
        super(name, tickMillis);
        this.deviceDelegate = new CanOpenDevice(name,tickMillis,nodeID,serialNB);
    }

   
    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";        
    }
    
    @Override
    public int readNewAnalogValue() throws FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    /* 
     * @return simulated values in hexa 
     */   
    @Override
    public String[] readNewHexaValues() {
            return hexaValues;
    }
    
    /**
     * Set the digital value for a sensor. 
     * @param sensor
     * @param digitalValue 
     */
    public void replaceDigitalValues(SimuPlutoGWSensor sensor, String digitalValue) {
        
       lock.lock();       
            
       try {
            updatingValues = true;
            //this.hexaValues = readNewHexaValues();
            //int byteNo = sensor.getByteNumero() - 1;
            int byteNo = sensor.getByteNumero();
            fcslog.finest(name + "=> old hexa value = " + this.hexaValues[byteNo]);
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            //bin.replace(8 - sensor.getInputNumero(), 8 - sensor.getInputNumero() + 1, digitalValue);
            bin.replace(7 - sensor.getInputNumero(), 7 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            fcslog.finest(name + "=> new hexa value ="  + newDIOHexaValue);
            this.hexaValues[byteNo] = newDIOHexaValue;
            fcslog.finest(name + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0]
                + " hexaValues[1]=" + this.hexaValues[1]);
            

       } finally {
           
           updatingValues = false;
           valueUpdated.signal();
           lock.unlock();
           
       }
    }


    @Override
    public String getSerialNB() {
        return this.deviceDelegate.getSerialNB();
    }

    @Override
    public String getNodeID() {
        return this.deviceDelegate.getNodeID();
    }

    @Override
    public boolean isBooted() {
        return this.deviceDelegate.isBooted();
    }

    @Override
    public void setBooted(boolean aBoolean) {
        this.deviceDelegate.setBooted(aBoolean);
    }

    @Override
    public boolean isInitialized() {
        return this.deviceDelegate.isInitialized();
    }

    @Override
    public String initializeHardware() throws FcsHardwareException {
        return this.deviceDelegate.initializeHardware();               
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, 
            description="For tests purpose - raise an alarm.")
    public void simulateAlarm(String alarmMsg) {
        log.debug(name + "An Alarm was raised:" + alarmMsg);
        this.getSubsystem().raiseAlarm(alarmMsg);
    }




    




}
