/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.LoaderModule;

/**
 *
 * @author virieux
 */
public class SimuLoaderPlutoGateway extends SimuPlutoGateway {
    private LoaderModule loader;
    SimuLoaderCarrierController carrierController;
    SimuPlutoGWSensor lockSensor1;
    SimuPlutoGWSensor unlockSensor1;
    SimuPlutoGWSensor lockSensor2;
    SimuPlutoGWSensor unlockSensor2;
    SimuPlutoGWSensor lockSensor3;
    SimuPlutoGWSensor unlockSensor3;
    SimuPlutoGWSensor lockSensor4;
    SimuPlutoGWSensor unlockSensor4;
    SimuPlutoGWSensor loaderOnCameraSensor0;
    SimuPlutoGWSensor loaderOnCameraSensor1;
    SimuPlutoGWSensor filterPresenceSensor0;
    SimuPlutoGWSensor filterPresenceSensor1;
    SimuPlutoGWSensor autochangerHoldingFilterSensor;
    SimuPlutoGWSensor storagePositionSensor0;
    SimuPlutoGWSensor handoffPositionSensor0;
    SimuPlutoGWSensor storagePositionSensor1;
    SimuPlutoGWSensor handoffPositionSensor1;

    public SimuLoaderPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.lockSensor1 = (SimuPlutoGWSensor) getModule("lockSensor1");
        this.lockSensor2 = (SimuPlutoGWSensor) getModule("lockSensor2");
        this.lockSensor3 = (SimuPlutoGWSensor) getModule("lockSensor3");
        this.lockSensor4 = (SimuPlutoGWSensor) getModule("lockSensor4");
        this.unlockSensor1 = (SimuPlutoGWSensor) getModule("unlockSensor1");
        this.unlockSensor2 = (SimuPlutoGWSensor) getModule("unlockSensor2");
        this.unlockSensor3 = (SimuPlutoGWSensor) getModule("unlockSensor3");
        this.unlockSensor4 = (SimuPlutoGWSensor) getModule("unlockSensor4");
        this.loaderOnCameraSensor0 = (SimuPlutoGWSensor) getModule("loaderOnCameraSensor0");
        this.loaderOnCameraSensor1 = (SimuPlutoGWSensor) getModule("loaderOnCameraSensor1");
        this.filterPresenceSensor0 = (SimuPlutoGWSensor) getModule("filterPresenceSensor0");
        this.filterPresenceSensor1 = (SimuPlutoGWSensor) getModule("filterPresenceSensor1");
        this.autochangerHoldingFilterSensor = (SimuPlutoGWSensor) getModule("autochangerHoldingFilterSensor");
        this.storagePositionSensor0 = (SimuPlutoGWSensor) getModule("storagePositionSensor0");
        this.storagePositionSensor1 = (SimuPlutoGWSensor) getModule("storagePositionSensor1");
        this.handoffPositionSensor0 = (SimuPlutoGWSensor) getModule("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor) getModule("handoffPositionSensor1");
        this.carrierController = (SimuLoaderCarrierController) this.getModule("carrierController");
        this.loader = (LoaderModule) this.getModule("loader");
        //Filter is locked and carrier is at storage position
        simulateLoaderClampIsLocked();
        simulateLoaderIsConnectedOnCamera();
        simulateAutochangerIsNotHoldingFilter();
        simulateFilterIsOnLoader();
        simulateLoaderCarrierIsAtStorage();     
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsLocked() {
        simulateHookIsLocked(lockSensor1, unlockSensor1);
        simulateHookIsLocked(lockSensor2, unlockSensor2);
        simulateHookIsLocked(lockSensor3, unlockSensor3);
        simulateHookIsLocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsUnLocked() {
        simulateHookIsUnlocked(lockSensor1, unlockSensor1);
        simulateHookIsUnlocked(lockSensor2, unlockSensor2);
        simulateHookIsUnlocked(lockSensor3, unlockSensor3);
        simulateHookIsUnlocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsInTravel() {
        simulateHookIsInTravel(lockSensor1, unlockSensor1);
        simulateHookIsInTravel(lockSensor2, unlockSensor2);
        simulateHookIsInTravel(lockSensor3, unlockSensor3);
        simulateHookIsInTravel(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "1");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsInTravel(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "1");
        replaceDigitalValues(loaderOnCameraSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "0");
        replaceDigitalValues(loaderOnCameraSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "1");
        replaceDigitalValues(filterPresenceSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsNotOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "0");
        replaceDigitalValues(filterPresenceSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtStorage() {
        replaceDigitalValues(storagePositionSensor0, "1");
        replaceDigitalValues(storagePositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        carrierController.setPosition(loader.getCarrier().getStoragePosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtHandoff() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        carrierController.setPosition(loader.getCarrier().getHandoffPosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsInTravel() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
    }
    
}
