/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * This class is to simulate an EPOS Controller which controls the loader hooks.
 * @author virieux
 */
public class SimuLoaderClampController extends SimuEPOSControllerModule {
    
    LoaderClampModule clamp;
    SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderClampController(String aName, int aTickMillis, 
            String nodeID, String serialNB,
            Map<String, Integer> paramsForCurrent,            
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming  
            ) {
        super(aName, aTickMillis, nodeID, serialNB,paramsForCurrent,paramsForProfilePosition,paramsForHoming);
    }
    
    
    @Override
    public void initModule() {
        super.initModule();
        clamp = (LoaderClampModule)this.getModule("clamp");
        plutoGateway = (SimuLoaderPlutoGateway)this.getModule("plutoGateway");
    }
   
    
    @Override
    public void writeCurrent(int aValue) throws BadCommandException, 
            SDORequestException {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        fcslog.debug("=>initial current="+actualCurrent);
        int stepsNB = 10;
        int step = (targetCurrent - this.actualCurrent)/stepsNB;
        
        for (int i=1; i<stepsNB; i++) {           

            this.actualCurrent = currentInitial + (i*step);
            clamp.updateCurrent();
            if (actualCurrent == clamp.getCurrentToClamp()) {
                log.debug("plutoGateway="+ plutoGateway.toString());
                this.position = clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsLocked();
                
            } else if (actualCurrent == clamp.getCurrentToGoHome() ) {
                this.position = clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            }
            clamp.publishData();
            fcslog.debug("i="+i+",actualCurrent="+actualCurrent);
            try {
                Thread.sleep(500);
                if (clamp.getHaltRequired().get()) {
                    log.debug(name + " STOP simulated clamp motion.");
                    return;
                }
            } catch (InterruptedException ex) {
                throw new BadCommandException(name+" sleep was interrupted.");
            }

        }       
        this.actualCurrent = aValue;
        if (actualCurrent == clamp.getCurrentToClamp()) {
                log.debug("plutoGateway="+ plutoGateway.toString());
                this.position = clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsLocked();
                
            } else if (actualCurrent == clamp.getCurrentToGoHome() ) {
                this.position = clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            } 
            clamp.publishData();
    }
    
    @Override
    public void writeTargetPosition(int positionToReached) 
            throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug("=>position intitiale="+position);
        int stepsNB = 10;
        int step = (targetPosition - this.position)/stepsNB;
        
        for (int i=1; i<stepsNB; i++) {           

            this.position = positionInitiale + (i*step);
            clamp.updatePosition();
            if (position == clamp.getTargetPositionToOpen()) {
                log.debug("plutoGateway="+ plutoGateway.toString());
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            } else if (position == clamp.getTargetPositionToClose() ) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else if (position == clamp.getTargetPositionToClamp() ) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else {
                this.plutoGateway.simulateLoaderClampIsInTravel();                
            }
            clamp.publishData();
            fcslog.debug("i="+i+",position="+position);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                throw new BadCommandException(name+" sleep was interrupted.");
            }

        }
        this.position = targetPosition;
        if (position == clamp.getTargetPositionToOpen()) {
            log.debug("plutoGateway="+ plutoGateway.toString());
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        } else if (position == clamp.getTargetPositionToClose() ) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (position == clamp.getTargetPositionToClamp() ) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();                
        }
        clamp.publishData();
    }






    
}
