/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import java.util.Random;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class SimuClampActuatorModule extends Module implements EPOSController {
    
    protected static final Logger fcslog = FcsUtils.log;
    
    public boolean on;
    boolean enabled;
    public int readCurrentValue;
    public int sentCurrentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;
    EposMode mode;
    int current;

    Random r = new Random();
    
    CarouselModule carousel;


    
    @Override
    public boolean isOn() {
        return on;
    }

    @Override
    public boolean isOff() {
        return !on;
    }

    @Override
    public int getReadActualCurrent() {
        return readCurrentValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return sentCurrentMinValue;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return sentCurrentMaxValue;
    }
    
    

    @Override
    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule) this.getModule("carousel");
        mode = EposMode.CURRENT;
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        on = true;
        
        fcslog.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        
        //we have to publish on status bus the sentValue (for the GUI)
        this.sentCurrentValue = 500;
        //this.sendToStatus(this.getStatusData());
        //this.publishActuatorData();
        this.publishData();
        
        return getName() + " is turned ON.";
    }
    
    @Override
    public void writeCurrent(int currentValue) throws BadCommandException, SDORequestException {
         on = true;
        
        fcslog.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (name.contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (name.contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else {
            throw new BadCommandException(name + ":couldn't find the clamp to unlock");
        }
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        
        //we have to publish on status bus the sentValue (for the GUI)
        //not done in CanOPenEPOS
        this.sentCurrentValue = currentValue;
        this.publishData();
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        on = false;
        fcslog.debug(getName() + "==========> ACTUATOR OFF");
        //the clamp is now LOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsLOCKED(clamp);

        this.sentCurrentValue = 0;
        //this.sendToStatus(this.getStatusData());
        //this.publishActuatorData();
        this.publishData();
        return getName() + " is turned OFF.";
    }

    public int getSentCurrentValue() {
//        if (isOn()) {
            if (this.sentCurrentMinValue >= 0) {
                
                if (this.sentCurrentMaxValue > 0) {
                    return r.nextInt(this.sentCurrentMaxValue);
                } else {
                    String msg = getName() + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
                    throw new IllegalArgumentException(msg);
                }
            }
            return (int) (r.nextGaussian()) * this.sentCurrentMaxValue / 2;
//        }
//        return 0;
    }

    @Override
    public void tick() {
        //this.publishActuatorData();
    }

    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return getName() + "Maintaining Current";
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        if (isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }
    
    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }
    
        /**
     * Publish Data on status bus for trending data base and GUIs.
     * If a key is changed here, it has to be changed also in the GUIs (FilterExchangeMainPanel)
     */
    @Deprecated // because GUIs implement DataStatusPersister
    public void publishActuatorData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", "carouselClampActuator");
        kvlist.add(getName() + "/sentValue", this.sentCurrentValue);
        publish(timestamp,kvlist);
        
    }
    
     /**
     * Publish Data on status bus for trending data base and GUIs.
     * 
     */
     public void publishData() {
        StatusDataPublishedByClampActuator status = this.getStatusData(); 
        this.publish("actuator", status);
     }

    @Override
    public void setOn(boolean on) {
        this.on = on;
    }

    @Override
    public String changeMode(EposMode newMode) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException, SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void writeParameters(EposMode mode) throws SDORequestException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void writeTargetPosition(int aValue) throws BadCommandException, SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isTargetPositionReached(int position) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int readPosition() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    @Override
    public int readSSIPosition() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String enable() throws SDORequestException {
        this.enabled = true;
        return name +" is ENABLED";
    }

    @Override
    public EposMode readMode() throws SDORequestException {
        return mode;
    }


    @Override
    public int getMinCurrent() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxCurrent() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxSpeed() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxPosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMinPosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void quickStop() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void checkFault() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int readProfileVelocity() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String readParameters(EposMode mode) throws SDORequestException, ShortResponseToSDORequestException {
        return null;
    }

    @Override
    public void checkParameters(String modeInString) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void checkParameters(EposMode aMode) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
        
    }

    @Override
    public void writeControlWord(String f) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String shutdown() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isEnabled() throws SDORequestException {
        return enabled;
    }

    @Override
    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void switchOnEnableOperation() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isBooted() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setBooted(boolean aBoolean) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isInitialized() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String initializeHardware() throws FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isEnabledToPublish() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isInError() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getErrorRegister() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String[] getErrorHistory() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getModeInString() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }







}
