/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;

/**
 *
 * @author virieux
 */
public class SimuAutochangerPlutoGateway extends SimuPlutoGateway {
    
    //private AutoChangerModule autochanger;
    private AutoChangerTrucksModule trucks;
    SimuAutochangerLinearRailController trucksController;
    
    
    SimuPlutoGWSensor handoffPositionSensor0;    
    SimuPlutoGWSensor handoffPositionSensor1;
    SimuPlutoGWSensor onlinePositionSensor0;    
    SimuPlutoGWSensor onlinePositionSensor1;
    SimuPlutoGWSensor standbyPositionSensor0;
    SimuPlutoGWSensor standbyPositionSensor1;
    SimuPlutoGWSensor loaderConnectedSensor0;
    SimuPlutoGWSensor loaderConnectedSensor1;

    public SimuAutochangerPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.handoffPositionSensor0 = (SimuPlutoGWSensor) getModule("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor) getModule("handoffPositionSensor1");  
        this.onlinePositionSensor0 = (SimuPlutoGWSensor) getModule("onlinePositionSensor0");
        this.onlinePositionSensor1 = (SimuPlutoGWSensor) getModule("onlinePositionSensor1"); 
        this.standbyPositionSensor0 = (SimuPlutoGWSensor) getModule("standbyPositionSensor0");
        this.standbyPositionSensor1 = (SimuPlutoGWSensor) getModule("standbyPositionSensor1");
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor) getModule("loaderConnectedSensor0");
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor) getModule("loaderConnectedSensor1");
        this.trucksController = (SimuAutochangerLinearRailController) this.getModule("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule) this.getModule("trucks");   
        simulateAutochangerTrucksIsOnline();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getHandoffPosition());
    } 
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsOnline() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "1");
        replaceDigitalValues(onlinePositionSensor1, "1");
        trucksController.setPosition(trucks.getOnlinePosition());
        trucksController.setSsiPosition(trucks.getEncoderRibbonMinValue() +
                trucks.getOnlinePosition());
    }  
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtStandby() {
        replaceDigitalValues(standbyPositionSensor0, "1");
        replaceDigitalValues(standbyPositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getStandbyPosition());
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsInTravel() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnected() {
        replaceDigitalValues(loaderConnectedSensor0, "1");
        replaceDigitalValues(loaderConnectedSensor1, "1");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsDisconnected() {
        replaceDigitalValues(loaderConnectedSensor0, "0");
        replaceDigitalValues(loaderConnectedSensor1, "0");
    }


    
}
