/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import static java.lang.Math.abs;
import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 *
 * @author virieux
 */
public class SimuAutochangerLinearRailController extends SimuEPOSControllerModule {

    AutoChangerTrucksModule trucks;
    SimuAutochangerPlutoGateway plutoGateway;
    
    public SimuAutochangerLinearRailController(String aName, int aTickMillis, 
            String nodeID, String serialNB, 
            Map<String, Integer> paramsForCurrent, 
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, 
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }
    
    
    @Override
    public void initModule() {
        this.trucks = (AutoChangerTrucksModule) this.getModule("autochangerTrucks");
        this.plutoGateway = (SimuAutochangerPlutoGateway) this.getModule("plutoGateway");
    }
    
    @Override
    public void writeTargetPosition(int positionToReached) 
            throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug("loader trucks is moving.");
        fcslog.debug(name + "=>position intitiale="+position);
        int stepsNB;
        if (abs(targetPosition - this.position) > 10000) {
            stepsNB = 20;
        } else {
            stepsNB = 5;
        }
        
        int step = (targetPosition - this.position)/stepsNB;
        
        for (int i=1; i<stepsNB; i++) {           
            try {           
                
                this.position = positionInitiale + (i*step);
                trucks.updatePosition();
                if (position == trucks.getHandoffPosition() ) {
                    log.debug("plutoGateway="+ plutoGateway.toString());
                    this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
                } else if (position == trucks.getStandbyPosition() ) {
                    this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
                } else if (position == trucks.getOnlinePosition() ) {
                    this.plutoGateway.simulateAutochangerTrucksIsOnline();
                } else {
                    this.plutoGateway.simulateAutochangerTrucksIsInTravel();
                }
                trucks.updateStateWithSensors();
                trucks.publishData();
                fcslog.debug(name +"i="+i+",position="+position);
                try {
                    Thread.sleep(500);
                    if (trucks.getHaltRequired().get()) {
                        log.debug(name + " STOP simulated trucks motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new BadCommandException(name+" sleep was interrupted.");
                }
                
            } catch (FcsHardwareException ex) {
                throw new BadCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == trucks.getHandoffPosition() ) {
            log.debug("plutoGateway="+ plutoGateway.toString());
            this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        } else if (position == trucks.getStandbyPosition() ) {
            this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
        } else if (position == trucks.getOnlinePosition() ) {
            this.plutoGateway.simulateAutochangerTrucksIsOnline();
        } else {
            this.plutoGateway.simulateAutochangerTrucksIsInTravel();
        }
        
    }

    
}
