/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 *
 * @author virieux
 */
public class CanOpenPlutoGateway extends PlutoGatewayModule implements PieceOfHardware {
    


    CanOpenProxy tcpProxy;
    CanOpenDevice deviceDelegate;
  
    //identifie pluto address on gateway
    String station_addr; 


    //TODO mettre un @ConstructorProperty
    public CanOpenPlutoGateway(String string, int i, 
            String nodeID, String serialNB,
            String station_addr) {
        super(string, i);
        this.station_addr = station_addr;
        this.deviceDelegate = new CanOpenDevice(name,tickMillis,nodeID,serialNB);
    }


    public String getStation_addr() {
        return station_addr;
    }
    
        @Override
    public String getSerialNB() {
        return this.deviceDelegate.getSerialNB();
    }

    @Override
    public String getNodeID() {
        return this.deviceDelegate.getNodeID();
    }

    @Override
    public boolean isBooted() {
        return this.deviceDelegate.isBooted();
    }

    @Override
    public void setBooted(boolean aBoolean) {
        this.deviceDelegate.setBooted(aBoolean);
    }

    @Override
    public boolean isInitialized() {
        return this.deviceDelegate.isInitialized();
    }

    @Override
    public String initializeHardware() throws FcsHardwareException {
        if (!isBooted()) throw new FcsHardwareException(name + " is not booted - can't be initialized.");
        try {
            log.info(name + " BEGIN initializeHardware");
            this.configurePlutoForThreeBlocs();
            this.deviceDelegate.initialized = true;   
            log.info(name + " is INITIALIZED.");
            //publishData for the LoaderHardwareGUI
            this.tcpProxy.publishHardwareData(this);
            return name + " is INITIALIZED.";
            
        } catch (SDORequestException | ErrorInCommandExecutionException ex) {
            throw new FcsHardwareException(name + ex.getMessage());
        }
    }
    
    
    @Override
    public void initModule() {
        super.initModule();
        //tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
        //NEW
        Map.Entry<String,Object> entry = this.getParent();
        BridgeToHardware bridge = (BridgeToHardware) entry.getValue();
        tcpProxy = (CanOpenProxy) bridge.getTcpProxy();
    }
    
    
    /**
     * Assuming Pluto has 3 fonctions Gateway_to_User_C
     * First one => Fonction_ID=01
     * Second one => Fonction_ID=02
     * Third one => Fonction_ID=03
     * @return
     * @throws SDORequestException
     * @throws ErrorInCommandExecutionException 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
    description="Configure this gateway to receive 3 data blocs from Pluto.")
    public String configurePlutoForThreeBlocs() throws SDORequestException, 
            ErrorInCommandExecutionException {
        
        //Disable additional Data
        this.tcpProxy.writeSDO(getNodeID(),"2010", "01", "01", "01"); 
        
        //Set Additionnal data TPDO1 => set Area_0 Function_ID = 01
        this.tcpProxy.writeSDO(getNodeID(),"2011", "01", "02", station_addr + "01"); //define AREA0 (doc p:96)
        
        //Set Additionnal data TPDO1 => set Area_1 Function_ID = 02
        this.tcpProxy.writeSDO(getNodeID(),"2011", "02", "02", station_addr + "02"); //define AREA1 (doc p:96)
        
        //Set Additionnal data TPDO2 => set Aera_2 Function_ID = 03
        this.tcpProxy.writeSDO(getNodeID(),"2012", "01", "02", station_addr + "03"); //define AREA2 (doc p:96)
        
        //Activate additional data for Area_0, Area_1 and Area_2
        this.tcpProxy.writeSDO(getNodeID(),"2002", "01", "01", "07"); 
       
        return (name + " is configured.");
    }
    

    
    public String writeTransmissionType(String transmissionType) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        if (transmissionType == null) throw new BadCommandException(getName() + ": Can't write transmission type to device because transmaission type is null.");
        String ack = this.tcpProxy.writeSDO(getNodeID(), "2005", "1", "1", transmissionType);
        String goodAck = "OK";
        if (!ack.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 1801");
                
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);   
    }
    
     /* 
     * @return values in hexa read on the device
     */   
    @Override
    public String[] readNewHexaValues() throws FcsHardwareException {

        if (!isBooted()) throw new FcsHardwareException(name
                + " is not booted - can't read new values.");
        try {
            hexaValues[0] = tcpProxy.readSDO(getNodeID(), "6000", "03");
            fcslog.finest(String.format("%s : first byte read in hexaValue= %s",name,hexaValues[0]));
            hexaValues[1] = tcpProxy.readSDO(getNodeID(), "6000", "04");
            fcslog.finest(String.format("%s : second byte read in hexaValue= %s",name,hexaValues[1]));
            hexaValues[2] = tcpProxy.readSDO(getNodeID(), "6001", "03");
            fcslog.finest(String.format("%s : third byte read in hexaValue= %s",name,hexaValues[2]));
            hexaValues[3] = tcpProxy.readSDO(getNodeID(), "6001", "04");
            fcslog.finest(String.format("%s : 4th byte read in hexaValue= %s",name,hexaValues[3]));            
            hexaValues[4] = tcpProxy.readSDO(getNodeID(), "6002", "03");
            fcslog.finest(String.format("%s : 5th byte read in hexaValue= %s",name,hexaValues[4]));        
        } catch (ShortResponseToSDORequestException ex) {
            fcslog.warning(name + "=> ERROR IN READING SENSOR:" + ex.getMessage());
            
        } catch (SDORequestException ex) {
            String message = name + "=> ERROR IN READING SENSOR:";
            fcslog.error(message + ex.toString());
            //this.getSubsystem().raiseAlarm(ex.toString());
                    
        }
        return hexaValues;
    }
    
    @Override
    public int readNewAnalogValue() throws FcsHardwareException {
        //read the registers
        String hexaL = tcpProxy.readSDO(getNodeID(), "6001", "01");
        fcslog.finest(name + ": new analog value in hexa=" + hexaL);
        String hexaM = tcpProxy.readSDO(getNodeID(), "6001", "02");
        String valueInHexa = hexaM + hexaL;
        fcslog.finest(name + ": new analog value in hexa=" + valueInHexa);
        int newAnalogValue = Integer.parseInt(valueInHexa, 16);
        fcslog.finest(name + ": new analog value =" + newAnalogValue);
        return newAnalogValue;
    } 
    
    @Override
    public String toString() {
        return deviceDelegate.toString();
    }
    
}
