/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 * This is a model for online clamp which holds a filter
 * when it is at ONLINE position.
 * The online clamps are part of the autochanger subsystem.
 * There is 3 online clamps.
 * @author virieux
 */
public class AutochangerOnlineClampModule extends MobileItemModule {
    
    EPOSController onlineClampController;
    Map<String,Integer> paramsForCurrentToLock;
    Map<String,Integer> paramsForCurrentToUnlock;
    int currentToLock;
    int currentToUnlock;
    int currentToClamp;
    int holdTime = 2000;
    int travelTime = 5000;
    
    FcsEnumerations.LockStatus lockStatus;

    public AutochangerOnlineClampModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
    }

    public AutochangerOnlineClampModule(String moduleName, int aTickMillis,            
            int currentToLock, 
            int currentToUnlock,
            int currentToClamp,
            Map<String, Integer> paramsForCurrentToLock, 
            Map<String, Integer> paramsForCurrentToUnlock,
            int holdTime, 
            int travelTime) {
        super(moduleName, aTickMillis);
        this.paramsForCurrentToLock = paramsForCurrentToLock;
        this.paramsForCurrentToUnlock = paramsForCurrentToUnlock;
        this.currentToLock = currentToLock;
        this.currentToUnlock = currentToUnlock;
        this.currentToClamp = currentToClamp;
        this.holdTime = holdTime;
        this.travelTime = travelTime;
    }

    public int getCurrentToLock() {
        return currentToLock;
    }

    @ConfigChanger
    public void setCurrentToLock(int currentToLock) {
        this.currentToLock = currentToLock;
    }

    public int getCurrentToUnlock() {
        return currentToUnlock;
    }

    @ConfigChanger
    public void setCurrentToUnlock(int currentToUnlock) {
        this.currentToUnlock = currentToUnlock;
    }

    public int getCurrentToClamp() {
        return currentToClamp;
    }

    @ConfigChanger
    public void setCurrentToClamp(int currentToClamp) {
        this.currentToClamp = currentToClamp;
    }

    public int getHoldTime() {
        return holdTime;
    }

    @ConfigChanger
    public void setHoldTime(int holdTime) {
        this.holdTime = holdTime;
    }

    public int getTravelTime() {
        return travelTime;
    }

    @ConfigChanger
    public void setTravelTime(int travelTime) {
        this.travelTime = travelTime;
    }

    public EPOSController getOnlineClampController() {
        return onlineClampController;
    }
    
    
    
    
    @Override
    public void initModule() {
        super.initModule();
        onlineClampController = (EPOSController) this.getModule("onlineClampController");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, description="Returns true if hardware is connected and ready.")
    @Override
    public boolean isHardwareReady() {
        return ((MainModule) this.getModule("main")).isHardwareReady();
    }
    
    public void initializeController() throws SDORequestException, HardwareException {
        try {
            onlineClampController.activateBrake();
            onlineClampController.shutdown();
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
        } catch (ShortResponseToSDORequestException ex) {
            log.warning(name+ex.getMessage());
        }
    }
    

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        switch(action) {  
            case LOCK_ONLINECLAMP :
                onlineClampController.enable();
                onlineClampController.changeMode(EposMode.CURRENT);
                //TODO checks these parameters during initialization phase.
                //onlineClampController.writeParameters(paramsForCurrentToLock);
                onlineClampController.releaseBrake();
                onlineClampController.writeCurrent(this.currentToLock);
                break;
                
           case UNLOCK_ONLINECLAMP :
                onlineClampController.enable();
                onlineClampController.changeMode(EposMode.CURRENT);
                //TODO checks these parameters during initialization phase.
                //onlineClampController.writeParameters(paramsForCurrentToUnlock);
                //first apply a force on the clamp, and then releaseBrake
                //don't do it in the reverse order !!!!
                onlineClampController.writeCurrent(this.currentToClamp);
                onlineClampController.releaseBrake();
                slowDownCurrent();
                
                onlineClampController.writeCurrent(this.currentToUnlock);
                break;
                }
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Lock online clamp for CPPM test bench.")
    public String testLock() throws SDORequestException, ShortResponseToSDORequestException, 
            BadCommandException, ErrorInCommandExecutionException, InterruptedException,
            FcsHardwareException {
        
        //commented in march 2015 because we want to enable the controller in all the cases.
//                if (!onlineClampController.isEnabled()) 
//                    throw new BadCommandException(name + "controller has to be ENABLED first.");
                onlineClampController.changeMode(EposMode.CURRENT);
                //TODO checks these parameters during initialization phase.
                //onlineClampController.writeParameters(paramsForCurrentToLock);
                onlineClampController.enable();
                onlineClampController.releaseBrake();
                fcslog.debug(name+": controller brake released.");
                
                onlineClampController.writeCurrent(this.currentToLock);
                fcslog.debug(name+": sent current to controller:" + currentToLock);
                //il y aura des capteurs mais en attendant, on attend. 
                fcslog.debug(name+": sleeping for:" + travelTime);
                fcslog.debug(name+":time="+System.currentTimeMillis());
                Thread.sleep(travelTime);
                fcslog.debug(name+":time="+System.currentTimeMillis());
                
                //added in mars 2015 to be consistant with applyCurrent in pyPlutoMaxon.py
                //to be tested on CPPM test bench
                onlineClampController.changeMode(EposMode.CURRENT);
                onlineClampController.enable();
                onlineClampController.releaseBrake();
                //end of added in mars 2015 to be tested on CPPM test bench
                
                onlineClampController.writeCurrent(this.currentToClamp);
                fcslog.debug(name+"==> current sent to controller=" + currentToClamp);
                fcslog.debug(name+": sleeping for:" + holdTime);
                fcslog.debug(name+":time="+System.currentTimeMillis());
                Thread.sleep(holdTime);
                fcslog.debug(name+":time="+System.currentTimeMillis());
                
                //the good order is activateBrake, then writeCurrent in this case.
                //because we want to put the pression, active brake and then set current to 0.             
                onlineClampController.activateBrake();
                fcslog.debug(name+": controller brake activated.");
                Thread.sleep(1000);

                onlineClampController.writeCurrent(0);
                fcslog.debug(name+"==> current sent to controller=" + 0);
                return name+" LOCKED";
    }   
    
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
        description="Unlock online clamp for CPPM test bench.")
    public String testUnlock() throws SDORequestException, BadCommandException, 
            ShortResponseToSDORequestException, ErrorInCommandExecutionException, 
            InterruptedException, FcsHardwareException {

        //commented in march 2015 because we want to enable the controller in all the cases.
//                if (!onlineClampController.isEnabled()) 
//                    throw new BadCommandException(name + "controller has to be ENABLED first.");
                onlineClampController.changeMode(EposMode.CURRENT);
                onlineClampController.enable();
                //TODO checks these parameters during initialization phase.
                //onlineClampController.writeParameters(paramsForCurrentToUnlock);
                //first apply a force on the clamp, and then releaseBrake
                //don't do it in the reverse order !!!!
                onlineClampController.writeCurrent(this.currentToClamp);
                onlineClampController.releaseBrake();
                Thread.sleep(1000);
                slowDownCurrent();
                
                //commented in March 2015 : it's already done in slowDownCurrent
//                onlineClampController.writeCurrent(0);
                
                onlineClampController.writeCurrent(this.currentToUnlock);
                Thread.sleep(travelTime+3000);
                
                onlineClampController.writeCurrent(0);
                Thread.sleep(10000);
                
                onlineClampController.activateBrake();
                return name+" UNLOCKED";
                
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) 
            throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
                switch(action) {  
            case LOCK_ONLINECLAMP :               
                onlineClampController.writeCurrent(this.currentToClamp);
                try {
                    Thread.sleep(holdTime);
                } catch (InterruptedException ex) {
                    throw new ErrorInCommandExecutionException(name 
                            + " was interrupted during action " + action.toString());
                }
                onlineClampController.activateBrake();
                onlineClampController.writeCurrent(0);
                break;
                
           case UNLOCK_ONLINECLAMP :
 
                
                break;
                }
    }
    
    public void slowDownCurrent() throws BadCommandException, SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException {
        int step = currentToClamp/5;
        for (int curr=currentToClamp-step; curr>0; curr=curr-step) {
            fcslog.debug("current="+curr);
            onlineClampController.writeCurrent(curr);
            //this is for CPPM test bench only - for the scale 1 prototype,
            //we will do it for the 3 controllers
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                throw new BadCommandException(name 
                        + " was interrupted during action testLock." + ex.getMessage());
            }
            //read actualCurrent to check if it actualCurrent = curr.
            int actualCurrent = onlineClampController.readCurrent();
            if (!(actualCurrent == curr)) log.error(name + ": CURRENT ERROR in"
                    + " slowDownCurrent actualCurrent=" +actualCurrent+",curr="+curr);
        
        }
        fcslog.debug("current="+0);
        onlineClampController.writeCurrent(0);
    }
    
     /**
     * This method is used to configure the controllers of the autochanger online clamps.
     *          * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                * Digital Inputs activated for OnlineClamps controllers are:
                * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                * QuickStop     Input=01        Mask=Enabled    Polarity=HighActive     HE_Sensor
                * General_A     Input=02        Mask=Enabled    Polarity=HighActive     HE_Sensor\
                * General_B     Input=03        Mask=Enabled    Polarity=HighActive     Check Brake Status      
                *********************************************
                * 1 - Configure the Digital Input Functionnality index 0x2070 sindex input_ID
                * Functionnality tab
                * Value = 15    General Purpose A
                * Value = 14    General Purpose B
                * Value = 13    General Purpose C
                * Value = 12    General Purpose D
                * Value = 11    General Purpose E
                * Value = 10    General Purpose F
                * Value = 9     General Purpose G
                * Value = 8     General Purpose H
                * Value = 7     General Purpose I
                * Value = 6     General Purpose J
                * Value = 5     QuickStop
                * Value = 4     Drive enable
                * Value = 3     Position marker
                * Value = 2     Home switch
                * Value = 1     Positive Limit switch
                * Value = 0     Negative Limit switch
                msg = 'Set DigIn_1 Quick Stop,wsdo,%s,2070,01,02,0005\n'  % (str(cobID))                        
                self.com_hal.executeOperation(client,msg)
                msg = 'Set DigIn_2 General_A,wsdo,%s,2070,02,02,8000\n'  % (str(cobID))                 
                self.com_hal.executeOperation(client,msg)
                msg = 'Set DigIn_3 Genral_B,wsdo,%s,2070,02,02,4000\n'  % (str(cobID))                  
                self.com_hal.executeOperation(client,msg)
                ****************************************************************
                * 2 - Configure the Digital Input Polarity 
                * index 0x2071 subindex 0x03
                * Value = 0     High Active
                * Value = 1     Low Active
                *****************************************************************
                * 3 - Configure the Digital Input Mask 
                * index 0x2071 subindex 0x02
                * Value = 0     Functionnality state will not be displayed
                * Value = 1     Functionnality state will be displayed
                *                 * Digital Input Functionnality tab              value
                * Bit_15        General Purpose A               1       
                * Bit_14        General Purpose B               1
                * Bit_13        General Purpose C               0
                * Bit_12        General Purpose D               0
                * Bit_11        General Purpose E               0
                * Bit_10        General Purpose F               0
                * Bit_9         General Purpose G               0
                * Bit_8         General Purpose H               0
                * Bit_7         General Purpose I               0
                * Bit_6         General Purpose J               0
                * Bit_5         QuickStop                       1
                * Bit_4         Drive enable                    0
                * Bit_3         Position marker                 0
                * Bit_2         Home switch                     0
                * Bit_1         Positive Limit switch           0
                * Bit_0         Negative Limit switch           0
                **********************************************************************
                * 4 - Configure the Digital Input Execution Mask 
                * index 0x2071 subindex 0x04
                * Digital Input Excecution Mask                         Value
                * Bit_15 to Bit_6       reserved                        0       
                * Bit_5                 QuickStop                       1
                * Bit_4                 Drive enable                    1               
                * Bit_3                 Position marker                 0
                * Bit_2                 Home switch                     0
                * Bit_1                 Positive Limit switch           0
                * Bit_0                 Negative Limit switch           0
                * **********************************************************************
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() throws SDORequestException {
        //1-Configure Digital Input Fonctionnality
        //QuickStop
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        //General_A
        //writeParameterInHexa(CanOpenEPOS.Parameter.ConfigurationOfDigitalInput2, "8000");
        //General_B
        //writeParameterInHexa(CanOpenEPOS.Parameter.ConfigurationOfDigitalInput3, "4000");
        
        //2-Configure the Digital Input Polarity
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        
        //3-Configure the Digital Input Mask
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        
        //4 - Configure the Digital Input Execution Mask
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
        
    }
    
    /**
     * This methods is used to configure the autochanger onlineClamps EPOS controllers.
     *          * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                * Digital Outputs activated for OnlineClamps controller are:
                * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                * Ready/Fault   Output=01       Mask=Enabled    Polarity=HighActive     
                * General_A     Output=04       Mask=Enabled    Polarity=HighActive     
                *********************************************
                * 1 - Configure the Digital Output Functionnality 
                * index 0x2079 subindex input_ID
                * Functionnality tab
                * Value = 15            General Purpose Out_A
                * Value = 14            General Purpose Out_B
                * Value = 13            General Purpose Out_C
                * Value = 12            General Purpose Out_D
                * Value = 11            General Purpose Out_E
                * Value = 10..8         not used
                * Value = 7..3          reserved
                * Value = 2             Holding Brake
                * Value = 1             Position compare
                * Value = 0             Ready/Fault
                *********************************************************************************
                * 2 - Configure the Digital Output Functionnality Mask 
                * index 0x2078 subindex 0x02
                * Value = 0     functionnality not activatd
                * Value = 1     functionnality activated
                *********************************************************************************
                * Digital Output Functionnality Mask            Value
                * Bit_15        General Purpose Out_A           1
                * Bit_14        General Purpose Out_B           0
                * Bit_13        General Purpose Out_C           0
                * Bit_12        General Purpose Out_D           0
                * Bit_11        General Purpose Out_E           0
                * Bit_10        General Purpose Out_F           0
                * Bit_9         General Purpose Out_G           0
                * Bit_8         General Purpose Out_H           0
                * Bit_7         reserved                        0
                * Bit_6         reserved                        0
                * Bit_5         reserved                        0
                * Bit_4         reserved                        0
                * Bit_3         reserved                        0
                * Bit_2         Holding Brake                   0
                *********************************************************************************
                * 3 - Configure the Digital Output Functionnality Polarity 
                * index 0x2078 subindex 0x03
                * Value = 0     associated output not change    => HighActive
                * Value = 1     associated output inverted      => LowActive
                *********************************************************************************
     * @throws SDORequestException 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() throws SDORequestException {
        //1 - Configure the Digital Output Functionnality
        //Ready/Fault
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        //General_A
        //gives an error : CAN OPEN DEVICE ERROR CODE=6090031 index=2079 subindex=04 error name=Value too high Error
        //writeParameterInHexa(Parameter.ConfigurationOfDigitalOutput4, "8000"); //pas bon
        
        //2 - Configure the Digital Output Functionnality Mask
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        
        //3 - Configure the Digital Output Functionnality Polarity
        onlineClampController.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");        
    }

    @Override
    public void publishData() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
   
    
}
