/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is the Main Module when autochanger is in standalone mode.
 * @author virieux
 */
public class AutochangerMainModule extends MainModule {
    
    AutoChangerModule autochanger;

    public AutochangerMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
        description="Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() 
            throws FcsHardwareException, ErrorInCommandExecutionException, 
            BadCommandException {
        super.updateStateWithSensors();
        autochanger.updateStateWithSensors();
    }
    
    //for the GUI
    public EPOSController getLinearRailMasterController() {
        return autochanger.getTrucks().getLinearRailMasterController();
    }
    
    //for the GUI
    public EPOSController getLinearRailSlaveController() {
        return autochanger.getTrucks().getLinearRailSlaveController();
    }

//    //for the GUI
//    public EPOSController getOnlineClampController() {
//        return onlineClamp.getOnlineClampController();
//    }
//    
    //for the GUI
    public EPOSController getLatchXminusController() {
        return autochanger.getLatches().getLatchXminusController();
    }

    public EPOSController getLatchXplusController() {
        return autochanger.getLatches().getLatchXplusController();
    }

    //For the GUI
    public PlutoGatewayModule getPlutoGateway() {
        return autochanger.getPlutoGateway();
    }
    
    public AutoChangerTrucksModule getAutochangerTrucks() {
        return autochanger.getTrucks();
    }


}
