package sft

import org.lsst.ccs.subsystems.fcs.common.Actuator
import org.lsst.ccs.subsystems.fcs.testbench.LPNHETestBenchMainModule
import org.lsst.ccs.testers.components.CCSBuilder
import org.lsst.ccs.subsystems.fcs.drivers.*

import static org.lsst.gruth.jutils.MapArgs.*

CCSBuilder builder = ["LPNHE test bench"]

builder.
        "Main Module" ( LPNHETestBenchMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 1000),
                        ref("tcpProxy"),
                        ref("actuatorA"),
                        ref("actuatorXminus"),
                        ref("actuatorXplus"),
                        ref("ai814"),
                        ref("ao412"),
                        ref("dio8n1"),
                        ref("dio8n2")))
                 


            //begin description of Main submodules
            {       

                // tcp Proxy
                tcpProxyA (CanOpenProxy,
                        argMap(aString("name", "tcpProxy"),
                            anInt("tickMillis", 1000),
                            aString("myClientName","TestBench"),
                            anInt("expectedNodesNB", 7),
                            anInt("portNumber", 5000)))


                // clamp actuatorA description 
                actuatorA (anImpl(Actuator, CanOpenClampActuatorModule),
                        argMap( a("name", "clampActuatorXminus"),
                                anInt("tickMillis",1000),
                                aString("nodeID","b"),                                
                                aString("serialNB","79003900"),
                                aRef("motor","motor1"),
                                aString("mode","CURRENT"))) 
                        {
                        motor1 (Motor,
                                        argMap( aString("name", "Motor1"),
                                                anInt("motorType",11),                                
                                                anInt("positionSensorType",3),
                                                anInt("continuousCurrentLimit",2360),
                                                anInt("maxSpeedInCurrentMode",100),
                                                anInt("thermalTimeConstantWinding",160),
                                                anInt("outputCurrentLimit",4720),
                                                anInt("polePairNumber",8),
                                                anInt("currentValue",500)))
                                       
                                 
                         } //end of clampActuatorA description
                        


                //clamp actuatorXminus description
                actuatorXminus (anImpl(Actuator, CanOpenClampActuatorModule),
                        argMap( a("name", "clampActuatorXminus"),
                                anInt("tickMillis",1000),
                                aString("nodeID","1a"),                                
                                aString("serialNB","79003317"),
                                aRef("motor","motorXminus"),
                                aString("mode","CURRENT")))
                        {
                        motorXminus (Motor,
                                        argMap( aString("name", "motorXminus"),
                                                anInt("motorType",11),                                
                                                anInt("positionSensorType",3),
                                                anInt("continuousCurrentLimit",2360),
                                                anInt("maxSpeedInCurrentMode",25),
                                                anInt("thermalTimeConstantWinding",160),
                                                anInt("outputCurrentLimit",4720),
                                                anInt("polePairNumber",8),
                                                anInt("currentValue",1500)))
                                       
                                 
                         } //end of clampActuatorXminus description


                 actuatorXplus (anImpl(Actuator, CanOpenClampActuatorModule),
                        argMap( a("name", "clampActuatorXminus"),
                                anInt("tickMillis",1000),
                                aString("nodeID","1b"),                                
                                aString("serialNB","79003313"),
                                aRef("motor","motorXplus"),
                                aString("mode","CURRENT")))
                        {
                        motorXplus (Motor,
                                        argMap( aString("name", "motorXplus"),
                                                anInt("motorType",11),                                
                                                anInt("positionSensorType",3),
                                                anInt("continuousCurrentLimit",2360),
                                                anInt("maxSpeedInCurrentMode",25),
                                                anInt("thermalTimeConstantWinding",160),
                                                anInt("outputCurrentLimit",4720),
                                                anInt("polePairNumber",8),
                                                anInt("currentValue",200)))
                        }//end of clampActuatorXplus description
                         

                
                // can open devices
                ai814 (CanOpenADC, 
                        argMap(aString("name", "ai814"),
                            anInt("tickMillis", 1000),
                            aString("nodeID","21"),
                            aString("serialNB","c7c80479")))

                ao412 (CanOpenDAC, 
                        argMap(aString("name", "ao412"),
                            anInt("tickMillis", 1000),
                            aString("nodeID","22"),
                            aString("serialNB","c7c60307")))

                dio8n1 (CanOpenADC, 
                        argMap(aString("name", "dio8n1"),
                            anInt("tickMillis", 1000),
                            aString("nodeID","23"),
                            aString("serialNB","c7ca0914")))
                
                dio8n2 (CanOpenADC, 
                        argMap(aString("name", "dio8n2"),
                            anInt("tickMillis", 1000),
                            aString("nodeID","24"),
                            aString("serialNB","c7ca0913")))
            }//end description of Main submodules

                


