package LatchTest

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

def plutoGatewayName = "plutoGateway" // to monitor the CPPM testbench sensors

CCSBuilder builder = ["latch test subsystem"]

builder.
        "Main Module" ( org.lsst.ccs.subsystems.fcs.testbench.TestLatchMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("latchXminus"),
                        ))

 //**************************************************************************//
                // Bridge
 //**************************************************************************//
                bridge (anImpl(BridgeToHardware, BridgeForTestLatch),
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("plutoGateway"),
                            ref("latchXminusController"),
                            ))
                //************************************//
                {//begin description of bridge's children
                //************************************//

                        // tcp Proxy
                        tcpProxy (SimuCanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),                                  
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:100..10000])
                        ))
                        // can open devices
                        plutoGateway (SimuAutochangerPlutoGateway, 
                                argMap(aString("name", plutoGatewayName),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","30"),
                                    aString("serialNB","2071"),
                                    //aString("station_addr","01"),
                        ))

                        latchXminusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
                                argMap(aString("name", "latchXminusController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","4"),
                                    aString("serialNB","84004711"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:2,
                                        ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                                        ThermalTimeConstantWinding:40,
                                        MaxSpeedInCurrentMode:100]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                        ))

                //************************************//
                }//end description of bridge's children
                //************************************//


                            latchXminus (AutochangerLatchModule,
                                argMap(aString("name", "latchXminus"),
                                    anInt("tickMillis", 1000),
                                    aString("controllerName", "latchXminusController"),
                                    anInt("timeoutForClosing",3000,
                                      [description:"timeout in milliseconds."]),
                                    anInt("timeoutForOpening",3000,
                                      [description:"timeout in milliseconds."]),
                                    aRef("lockSensor","lockSensorLatchXminus"),
                                    aRef("unlockSensor","unlockSensorLatchXminus"),
                                    aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                    anInt("minCurrent",300,[description:"min position value used by the GUI"]),
                                    anInt("maxCurrent",-300,[description:"max current value used by the GUI"]),
                                    anInt("currenToOpen",200,[description:"in mA current to be sent to the controller to open the latch."]), 
                                    ))
                            {//begin description of autochanger latchXminus children
                            "lockSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorLatchXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                                    
                            "unlockSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "unlockSensorLatchXminus"),
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "filterPresenceSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            }//end description of autochanger latchXminus children
                            //**********************************************//
                            // end of autochanger latchXminus description   //
