package autochanger

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*

def plutoGatewayName = "plutoGateway" // to monitor the autochanger sensors

CCSBuilder builder = ["Simulated Autochanger"]

builder.
        "Main Module" ( org.lsst.ccs.subsystems.fcs.AutochangerMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),                       
                        ref("autochanger"),
                        ref("inclinometer"),
//
                        ))
                 



            
            //begin description of Main submodules
            {  
                
 //**************************************************************************//
                // Bridge
 //**************************************************************************//
                bridge (anImpl(BridgeToHardware, SimuBridgeForAutochanger),
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000),
                            ref("tcpProxy"),
                            ref("plutoGateway"),
                            ref("linearRailMasterController"),
                            ref("linearRailSlaveController"),                            
                            ref("latchXminusController"),
                            ref("latchXplusController"),
                            ref("onlineClampXminusController"),
                            ref("onlineClampXplusController"),
                            ref("onlineClampZController"),
                            ))
                //************************************//
                {//begin description of bridge's children
                //************************************//

                        // tcp Proxy
                        tcpProxy (SimuCanOpenProxy,
                                argMap(aString("name", "tcpProxy"),
                                    anInt("tickMillis", 1000),
                                    anInt("portNumber", 50000,[static:true, constraints:1024..99000]),
                                    aString("myClientName","TestBench",[static:true]),                                  
                                    anInt("hardwareBootTimeout",1000, [description:"A timeout for the harwdare booting process",constraints:100..10000])))

                        // can open devices
                        plutoGateway (SimuAutochangerPlutoGateway, 
                                argMap(aString("name", plutoGatewayName),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","30"),
                                    aString("serialNB","2071"),
                                    //aString("station_addr","01"),
                        ))

                        // can open devices
                        linearRailMasterController (SimuAutochangerLinearRailController, 
                                argMap(aString("name", "linearRailMasterController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","2a"),
                                    aString("serialNB","80001881"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:260,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:1207,
                                        ProfileDeceleration:1207,
                                        MaxProfileVelocity:322,
                                        QuickStopDeceleration:1207,
                                        MaxFollowingError:200000,//on verra plus tard
                                        ProfileVelocity:281,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailMasterController's children
                            }//end description of linearRailMasterController's children

                        // can open devices
                        linearRailSlaveController (SimuAutochangerLinearRailController, 
                                argMap(aString("name", "linearRailSlaveController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","2b"),
                                    aString("serialNB","80001932"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:1,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:30000,
                                        MaxFollowingError:7000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailSlaveController's children
                            }//end description of linearRailSlaveController's children



                        latchXminusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
                                argMap(aString("name", "latchXminusController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","4"),
                                    aString("serialNB","84004711"),
                                    aString("latchName","latchXminus"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:2,
                                        ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                                        ThermalTimeConstantWinding:40,
                                        MaxSpeedInCurrentMode:100]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of latchXminusController's children
                            }//end description of latchXminusController's children

                        // can open devices
                        latchXplusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
                                argMap(aString("name", "latchXplusController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","5"),
                                    aString("serialNB","999XXXX"),
                                    aString("latchName","latchXplus"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:2,
                                        ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                                        ThermalTimeConstantWinding:40,
                                        MaxSpeedInCurrentMode:100]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of latchXplusController's children
                            }//end description of latchXplusController's children

                        // can open devices
                        onlineClampXminusController (SimuOnlineClampController, 
                                argMap(aString("name", "onlineClampXminusController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","3a"),
                                    aString("serialNB","79011616"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                                        ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:6930]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:10000,
                                        MaxFollowingError:2000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",
                                        [HomeOffset:0, MaxProfileVelocity:6930,
                                        SpeedForSwitchSearch:100,
                                        SpeedForZeroSearch:10,
                                        HomingAcceleration:1000,
                                        CurrentThresholdHomingMode:500,
                                        HomePosition:0
                                        ]),
                                    ))
                                    
                            {//begin description of onlineClampXminuxController's children
                            }//end description of onlineClampXminusController's children

                        // can open devices
                        onlineClampXplusController (SimuOnlineClampController, 
                                argMap(aString("name", "onlineClampXplusController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","3b"),
                                    aString("serialNB","xxxx99999"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                                        ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:6930]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:10000,
                                        MaxFollowingError:2000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",
                                        [HomeOffset:0, MaxProfileVelocity:6930,
                                        SpeedForSwitchSearch:100,
                                        SpeedForZeroSearch:10,
                                        HomingAcceleration:1000,
                                        CurrentThresholdHomingMode:500,
                                        HomePosition:0
                                        ]),
                                    ))
                                    
                            {//begin description of onlineClampXpluxController's children
                            }//end description of onlineClampXplusController's children

                        // can open devices
                        onlineClampZController (SimuOnlineClampController, 
                                argMap(aString("name", "onlineClampZController"),
                                    anInt("tickMillis", 1000),
                                    aString("nodeID","3c"),
                                    aString("serialNB","xxxx99999"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                                        ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:6930]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:10000,
                                        MaxFollowingError:2000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",
                                        [HomeOffset:0, MaxProfileVelocity:6930,
                                        SpeedForSwitchSearch:100,
                                        SpeedForZeroSearch:10,
                                        HomingAcceleration:1000,
                                        CurrentThresholdHomingMode:500,
                                        HomePosition:0
                                        ]),
                                    ))
                                    
                            {//begin description of onlineClampZController's children
                            }//end description of onlineClampZController's children



                //************************************//            
                }//end description of bridge's children
                //************************************//
 //**************************************************************************//
                // end of Bridge
 //**************************************************************************//
     
               inclinometer (InclinometerModule, 
                                argMap(aString("name", "inclinometer"),
                                    anInt("tickMillis", 1000),
                                    aString("plutoGatewayName",plutoGatewayName,
                                        [static:true,description:"The name of the pluto gateway where this inclinometer is plugged."]),
               ))



//**************************************************************************//
//**************************************************************************//
                // autochanger
//**************************************************************************//
//**************************************************************************//
                 autochanger(AutoChangerModule,
                    argMap(aString("name", "autochanger"),
                        anInt("tickMillis", 1000),
                        aString("plutoGatewayName",plutoGatewayName),
                        ref("loaderConnectedSensor0"),
                        ref("loaderConnectedSensor1"),
                        ref("trucks"),   
                        ref("latches"),
                        ref("onlineClamps"),
                 ))
                 {//begin description of autochanger children
                        "loaderConnectedSensor0" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "loaderConnectedSensor0") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "loaderConnectedSensor1" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "loaderConnectedSensor1") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 0, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))  
//**************************************************************************//
                        // autochanger trucks description
//**************************************************************************//
                        trucks (AutoChangerTrucksModule, 
                            argMap(aString("name", "trucks"),
                                anInt("tickMillis", 1000),
                                anInt("encoderRibbonMinValue", 7469165),
                                anInt("encoderRibbonMaxValue", 8410000),
                                anInt("minActualPositionValue", 0),
                                anInt("maxActualPositionValue", 960000),
                                anInt("standbyPosition",0,[description:"Standby position in micron"]),                       
                                anInt("handoffPosition",958000,[description:"Handoff position in micron"]),
                                anInt("onlinePosition",960000,[description:"Online position in micron"]),
                                anInt("timeoutForTrucksMotion",120000,
                                      [description:"timeout in milliseconds."]),
                                ref("handoffPositionSensor0"),
                                ref("handoffPositionSensor1"),
                                ref("onlinePositionSensor0"),
                                ref("onlinePositionSensor1"),
                                ref("standbyPositionSensor0"),
                                ref("standbyPositionSensor1"),
                            ))
               
                {//begin description of autochanger trucks children

                        "handoffPositionSensor0" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "handoffPositionSensor0") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "handoffPositionSensor1" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "handoffPositionSensor1") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "onlinePositionSensor0" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "onlinePositionSensor0") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "onlinePositionSensor1" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "onlinePositionSensor1") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "standbyPositionSensor0" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "standbyPositionSensor0") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "standbyPositionSensor1" ( anImpl( NumericSensor,SimuPlutoGWSensor) ,
                            argMap(a ("name", "standbyPositionSensor1") ,
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))                                       
                    }//end description of autochanger trucks children
//**************************************************************************//
                            // end of autochanger trucks description
//**************************************************************************//

//**************************************************************************//
                            // autochanger latches description
//**************************************************************************//
/** **/
                            latches (AutochangerTwoLatches, 
                                argMap(aString("name", "latches"),
                                    anInt("tickMillis", 1000),
                                    ref("latchXminus"),
                                    ref("latchXplus"),
                                    ))

                    {//begin description of autochanger latches children
/** **/
                            //*************************************//
                            // autochanger latchXminus description
                            //*************************************//
                            latchXminus (AutochangerLatchModule,
                                argMap(aString("name", "latchXminus"),
                                    anInt("tickMillis", 1000),
                                    aRef("latchController","latchXminusController"),
                                    anInt("timeoutForClosing",3000,
                                      [description:"timeout in milliseconds."]),
                                    anInt("timeoutForOpening",3000,
                                      [description:"timeout in milliseconds."]),
                                    aRef("lockSensor","lockSensorLatchXminus"),
                                    aRef("unlockSensor","unlockSensorLatchXminus"),
                                    aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                    anInt("minCurrent",-300,[description:"min position value used by the GUI"]),
                                    anInt("maxCurrent",300,[description:"max current value used by the GUI"]),
                                    anInt("currentToOpen",200,[description:"in mA current to be sent to the controller to open the latch."]), 
                                    ))
                            {//begin description of autochanger latchXminus children
                            "lockSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorLatchXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                                    
                            "unlockSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "unlockSensorLatchXminus"),
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "filterPresenceSensorLatchXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            }//end description of autochanger latchXminus children
                            //**********************************************//
                            // end of autochanger latchXminus description   //
                            //**********************************************//
/** **/
                            //*************************************//
                            // autochanger latchXplus description
                            //*************************************//
                            latchXplus (AutochangerLatchModule,
                                argMap(aString("name", "latchXplus"),
                                    anInt("tickMillis", 1000),
                                    aRef("latchController","latchXplusController"),
                                    anInt("timeoutForClosing",3000,
                                      [description:"timeout in milliseconds."]),
                                    anInt("timeoutForOpening",3000,
                                      [description:"timeout in milliseconds."]),
                                    aRef("lockSensor","lockSensorLatchXplus"),
                                    aRef("unlockSensor","unlockSensorLatchXplus"),
                                    aRef("filterPresenceSensor","filterPresenceSensorLatchXplus"),
                                    anInt("minCurrent",-300,[description:"min position value used by the GUI"]),
                                    anInt("maxCurrent",300,[description:"max current value used by the GUI"]),
                                    anInt("currenToOpen",200,[description:"in mA current to be sent to the controller to open the latch."]), 
                                    ))
                            {//begin description of autochanger latchXplus children
                            "lockSensorLatchXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorLatchXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                                    
                            "unlockSensorLatchXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "unlockSensorLatchXplus"),
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "filterPresenceSensorLatchXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap( a("name", "filterPresenceSensorLatchXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            }//end description of autochanger latchXplus children
                            //**********************************************//
                            // end of autochanger latchXplus description   //
                            //**********************************************//
                    }//end description of autochanger latches children
/** **/
//*****************************************************************************//
                            // end of autochanger latches description
//*****************************************************************************//

//**************************************************************************//
//**************************************************************************//
                            // autochanger onlineClamps description
//**************************************************************************//
//**************************************************************************//
                    onlineClamps (AutochangerThreeOnlineClamps, 
                                argMap(aString("name", "onlineClamps"),
                                    anInt("tickMillis", 1000),
                                    ref("onlineClampXminus"),
                                    ref("onlineClampXplus"),
                                    ref("onlineClampZ"),
                                    anInt("timeoutForLockingClamps",15000,[description:"timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR."]),
                                    anInt("timeoutForUnlockingClamps",15000,[description:"timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR."]),
                                    ))
                    {//begin description of autochanger onlineClamps children
                        //***************//
                     onlineClampXminus(AutochangerOnlineClampModule ,
                        argMap(a ("name", "onlineClampXminus") ,
                            anInt("tickMillis", 3000), 
                            aRef("controller","onlineClampXminusController"),
                            aRef("lockSensor","lockSensorClampXminus"),
                            aRef("lockSensorC","lockSensorCClampXminus"),
                            aRef("unlockSensor","unlockSensorClampXminus"),
                            aRef("unlockSensorC","unlockSensorCClampXminus"),
                            anInt("currentToLock",300,[description:"current to lock the clamp in mA"]),
                            anInt("currentToUnlock",-300,[description:"current to unlock, in mA"]),
                            anInt("currentToClamp",3000,[description:"current to clamp, in mA"]),                                                           
                            aMap("paramsForCurrentToLock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to clamp the clamp."]),
                            aMap("paramsForCurrentToUnlock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                            anInt("holdTime",5000,[description:"time to hold clamp, in millis"]),
                            anInt("travelTime",5000,[description:"time for clamp to lock, in millis"]),
                    ))
                    {//begin description of autochanger onlineClampXminus children

                            "lockSensorClampXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorClampXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "lockSensorCClampXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorCClampXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            "unlockSensorClampXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorClampXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "unlockSensorCClampXminus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorCClampXminus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                    }//end of  description of autochanger onlineClampXminus children

                    //***************//
                    onlineClampXplus(AutochangerOnlineClampModule ,
                        argMap(a ("name", "onlineClampXplus") ,
                            anInt("tickMillis", 3000), 
                            aRef("controller","onlineClampXplusController"),
                            aRef("lockSensor","lockSensorClampXplus"),
                            aRef("lockSensorC","lockSensorCClampXplus"),
                            aRef("unlockSensor","unlockSensorClampXplus"),
                            aRef("unlockSensorC","unlockSensorCClampXplus"),
                            anInt("currentToLock",300,[description:"current to lock the clamp in mA"]),
                            anInt("currentToUnlock",-300,[description:"current to unlock, in mA"]),
                            anInt("currentToClamp",3000,[description:"current to clamp, in mA"]),                                                           
                            aMap("paramsForCurrentToLock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to clamp the clamp."]),
                            aMap("paramsForCurrentToUnlock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                            anInt("holdTime",5000,[description:"time to hold clamp, in millis"]),
                            anInt("travelTime",5000,[description:"time for clamp to lock, in millis"]),
                    ))
                    {//begin description of autochanger onlineClampXplus children

                            "lockSensorClampXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorClampXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "lockSensorCClampXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorCClampXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            "unlockSensorClampXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorClampXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "unlockSensorCClampXplus" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorCClampXplus") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                    }//end of  description of autochanger onlineClampXplus children

                    //***************//
                    onlineClampZ(AutochangerOnlineClampModule ,
                        argMap(a ("name", "onlineClampZ") ,
                            anInt("tickMillis", 3000), 
                            aRef("controller","onlineClampZController"),
                            aRef("lockSensor","lockSensorClampZ"),
                            aRef("lockSensorC","lockSensorCClampZ"),
                            aRef("unlockSensor","unlockSensorClampZ"),
                            aRef("unlockSensorC","unlockSensorCClampZ"),
                            anInt("currentToLock",300,[description:"current to lock the clamp in mA"]),
                            anInt("currentToUnlock",-300,[description:"current to unlock, in mA"]),
                            anInt("currentToClamp",3000,[description:"current to clamp, in mA"]),                                                           
                            aMap("paramsForCurrentToLock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to clamp the clamp."]),
                            aMap("paramsForCurrentToUnlock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                            anInt("holdTime",5000,[description:"time to hold clamp, in millis"]),
                            anInt("travelTime",5000,[description:"time for clamp to lock, in millis"]),
                    ))
                    {//begin description of autochanger onlineClampZ children

                            "lockSensorClampZ" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorClampZ") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 4, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "lockSensorCClampZ" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "lockSensorCClampZ") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 4, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            "unlockSensorClampZ" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorClampZ") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 4, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "unlockSensorCClampZ" ( anImpl( NumericSensor,SimuPlutoGWSensor),
                                argMap(a ("name", "unlockSensorCClampZ") ,
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 4, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                    }//end of  description of autochanger onlineClampZ children
                 }//end of  description of autochanger onlineClamps children
//**************************************************************************//
                            // end of autochanger onlineClamps description
//**************************************************************************//

                 }//end description of autochanger children
 //*****************************************************************************//
 //*****************************************************************************//
                // end of autochanger description
 //*****************************************************************************//
 //*****************************************************************************//


            }//end description of Main submodules

                


