/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerLatchConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerTrucksConfig;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterLatch;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderHookConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ActuatorConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.testbench.CPPMTestBenchMainModule;
import org.lsst.ccs.subsystems.fcs.testbench.LoaderTestBenchMainModule;
import org.lsst.ccs.utilities.logging.Logger;

public class FcsUtils {
    public static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");

    public static SingleFilterTestConfig createSingleFilterTestConfig(SftMainModule main) {
        SftCarouselModule carouselModule = main.getCarouselModule();
        boolean controlRealHardware = main.controlRealHardware();
        SftAutoChangerModule autochanger = main.getAutoChangerModule();
        return new SingleFilterTestConfig(controlRealHardware, FcsUtils.createClampConfig(carouselModule.getClampXminus()), FcsUtils.createClampConfig(carouselModule.getClampXplus()), FcsUtils.createActuatorConfig(carouselModule.getClampActuatorXminus()), FcsUtils.createActuatorConfig(carouselModule.getClampActuatorXplus()), FcsUtils.createActuatorConfig(autochanger.getLatchXminus().getLatchActuator()), FcsUtils.createActuatorConfig(autochanger.getLatchXplus().getLatchActuator()));
    }

    public static ClampConfig createClampConfig(CarouselClampModule filterModule) {
        return new ClampConfig(filterModule.getName(), filterModule.getFilterPositionValueA(), filterModule.getFilterPositionValueB(), filterModule.getFilterPositionValueC(), filterModule.getLockSensorValueA(), filterModule.getLockSensorValueB(), filterModule.getLockSensorValueC(), filterModule.getFilterPositionMinValue(), filterModule.getFilterPositionMaxValue(), filterModule.getLockSensorMinValue(), filterModule.getLockSensorMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(Actuator actuator) {
        return new ActuatorConfig(actuator.getSentCurrentMinValue(), actuator.getSentCurrentMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(LatchActuatorModule actuatorModule) {
        return new ActuatorConfig(actuatorModule.getSpeedVoltageMinValue(), actuatorModule.getSpeedVoltageMaxValue());
    }

    public static AutochangerConfig createAutochangerConfig(AutochangerMainModule main) {
        AutochangerConfig config = new AutochangerConfig(main.controlRealHardware(), FcsUtils.createCanOpenProxyConfig(main.getTcpProxy()));
        config.setLinearRailMasterControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLinearRailMasterController()));
        config.setLinearRailSlaveControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLinearRailSlaveController()));
        config.setLatchXminusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLatchXminusController()));
        config.setLatchXplusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLatchXplusController()));
        config.setOnlineClampXminusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getOnlineClampXminusController()));
        config.setOnlineClampXplusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getOnlineClampXplusController()));
        config.setOnlineClampZControllerConfig(FcsUtils.createEPOSControllerConfig(main.getOnlineClampZController()));
        config.setLatchXminusConfig(FcsUtils.createAutochangerLatchConfig(main.getAutochanger().getLatches().getLatchXminus()));
        config.setLatchXplusConfig(FcsUtils.createAutochangerLatchConfig(main.getAutochanger().getLatches().getLatchXplus()));
        config.setTrucksConfig(FcsUtils.createAutochangerTrucksConfig(main.getAutochangerTrucks()));
        config.setGwConfig(FcsUtils.createPlutoGatewayConfig(main.getPlutoGateway()));
        return config;
    }

    public static AutochangerConfig createAutochangerConfig(CPPMTestBenchMainModule main) {
        log.debug((Object)("is RealHardware=" + main.controlRealHardware()));
        log.debug((Object)("tcpProxy=" + main.getTcpProxy().toString()));
        AutochangerConfig config = new AutochangerConfig(main.controlRealHardware(), FcsUtils.createCanOpenProxyConfig(main.getTcpProxy()));
        log.debug((Object)"AutochangerConfig created.");
        config.setLinearRailMasterControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLinearRailMasterController()));
        config.setLinearRailSlaveControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLinearRailSlaveController()));
        log.debug((Object)"AutochangerConfig set for trucks controller.");
        config.setOnlineClampXminusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getOnlineClampXminusController()));
        log.debug((Object)"AutochangerConfig set for online clamp controller.");
        config.setLatchXminusControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLatchXminusController()));
        log.debug((Object)"AutochangerConfig set for latch controller.");
        config.setTrucksConfig(FcsUtils.createAutochangerTrucksConfig(main.getAutochangerTrucks()));
        config.setGwConfig(FcsUtils.createPlutoGatewayConfig(main.getPlutoGateway()));
        config.setLatchXminusConfig(FcsUtils.createAutochangerLatchConfig(main.getLatchXminus()));
        log.debug((Object)"AutochangerConfig set for latch.");
        return config;
    }

    public static AutochangerTrucksConfig createAutochangerTrucksConfig(AutoChangerTrucksModule acTrucks) {
        AutochangerTrucksConfig config = new AutochangerTrucksConfig(acTrucks.getName());
        config.setHandoffPosition(acTrucks.getHandoffPosition());
        config.setOnlinePosition(acTrucks.getOnlinePosition());
        config.setStandbyPosition(acTrucks.getStandbyPosition());
        config.setTimeoutForTrucksMotion(acTrucks.getTimeoutForTrucksMotion());
        return config;
    }

    public static PlutoGatewayConfig createPlutoGatewayConfig(PlutoGatewayModule gw) {
        PlutoGatewayConfig config = new PlutoGatewayConfig(gw.getName());
        return config;
    }

    public static AutochangerLatchConfig createAutochangerLatchConfig(AutochangerLatchModule latch) {
        AutochangerLatchConfig config = new AutochangerLatchConfig();
        config.setLatchName(latch.getName());
        config.setCurrentToOpen(latch.getCurrentToOpen());
        config.setMaxCurrent(latch.getMaxCurrent());
        config.setMinCurrent(latch.getMinCurrent());
        config.setTimeoutForClosing(latch.getTimeoutForClosing());
        config.setTimeoutForOpening(latch.getTimeoutForOpening());
        return config;
    }

    public static LoaderConfig createLoaderConfig(LoaderTestBenchMainModule main) {
        LoaderConfig config = new LoaderConfig(main.controlRealHardware(), FcsUtils.createLoaderClampConfig(main.getLoader().getClamp()), FcsUtils.createLoaderCarrierConfig(main.getLoader().getCarrier()), FcsUtils.createCanOpenProxyConfig(main.getTcpProxy()));
        EPOSControllerConfig clampControllerConfig = FcsUtils.createEPOSControllerConfig(main.getLoader().getHooksController());
        EPOSControllerConfig carrierControllerConfig = FcsUtils.createEPOSControllerConfig(main.getLoader().getCarrierController());
        config.setLoaderCarrierControllerConfig(FcsUtils.createEPOSControllerConfig(main.getLoader().getCarrierController()));
        config.setLoaderClampControllerConfig(clampControllerConfig);
        config.setLoaderCarrierControllerConfig(carrierControllerConfig);
        return config;
    }

    public static LoaderClampConfig createLoaderClampConfig(LoaderClampModule clamp) {
        return new LoaderClampConfig(clamp.getMinPosition(), clamp.getMaxPosition(), clamp.getMinCurrent(), clamp.getMaxCurrent(), clamp.getTargetPositionToOpen(), clamp.getTargetPositionToClose(), clamp.getTargetPositionToClamp(), clamp.getTimeoutForOpeningHooks(), clamp.getTimeoutForClosingHooks(), clamp.getTimeoutForClampingHooks(), clamp.getTimeoutForGoingToHomePosition(), FcsUtils.createLoaderHookConfig(clamp.getHook1()), FcsUtils.createLoaderHookConfig(clamp.getHook2()), FcsUtils.createLoaderHookConfig(clamp.getHook3()), FcsUtils.createLoaderHookConfig(clamp.getHook4()));
    }

    public static LoaderHookConfig createLoaderHookConfig(LoaderHookModule hook) {
        LoaderHookConfig loaderHookConfig = new LoaderHookConfig(hook.getName(), hook.getLockSensor().getDigitalValue(), hook.getUnlockSensor().getDigitalValue(), hook.isInError());
        return loaderHookConfig;
    }

    public static LoaderCarrierConfig createLoaderCarrierConfig(LoaderCarrierModule carrier) {
        return new LoaderCarrierConfig(carrier.getName(), carrier.getHandoffPosition(), carrier.getStoragePosition(), carrier.getMaxCurrent(), carrier.getMaxSpeed(), carrier.getTimeoutForGoingToHandOff(), carrier.getTimeoutForGoingToStorage());
    }

    public static CanOpenProxyConfig createCanOpenProxyConfig(CanOpenProxy tcpProxy) {
        if (tcpProxy == null) {
            throw new IllegalArgumentException("FcsUtils : tcpProxy is null - can't create CanOpenProxyConfig");
        }
        CANopenHardwareConfig[] hardwareConfigList = new CANopenHardwareConfig[tcpProxy.getHardwareList().length];
        int i = 0;
        while (i < tcpProxy.getHardwareList().length) {
            PieceOfHardware hard = tcpProxy.getHardwareList()[i];
            hardwareConfigList[i] = new CANopenHardwareConfig(hard.getName(), hard.getNodeID(), hard.getSerialNB(), Boolean.valueOf(hard.isBooted()), Boolean.valueOf(hard.isInitialized()));
            ++i;
        }
        return new CanOpenProxyConfig(tcpProxy.getMyClientName(), tcpProxy.getPortNumber(), tcpProxy.getExpectedNodesNB(), tcpProxy.getHardwareBootTimeout(), hardwareConfigList);
    }

    public static EPOSControllerConfig createEPOSControllerConfig(EPOSController ctl) {
        log.debug((Object)("createEPOSControllerConfig:" + ctl.toString()));
        EPOSControllerConfig config = new EPOSControllerConfig(ctl.getName());
        config.setParamsForCurrent(ctl.getParamsForCurrent());
        config.setParamsForProfilePosition(ctl.getParamsForProfilePosition());
        config.setParamsForHoming(ctl.getParamsForHoming());
        return config;
    }

    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty());
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }

    public static StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger(AutoChangerModule ac) {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(ac.getName());
        status.setLoaderConnectedSensorValue0(ac.getLoaderConnectedSensor0().getDigitalValue());
        status.setLoaderConnectedSensorValue1(ac.getLoaderConnectedSensor1().getDigitalValue());
        status.setLoaderConnectedSensorsInError(ac.isLoaderConnectedSensorsInError());
        return status;
    }

    public static StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks(AutoChangerTrucksModule acTrucks) {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setName(acTrucks.getName());
        s.setPosition(acTrucks.getPosition());
        s.setMasterControllerInFault(acTrucks.isMasterControllerInFault());
        s.setSlaveControllerInFault(acTrucks.isSlaveControllerInFault());
        s.setCurrent(acTrucks.getCurrent());
        s.setSpeed(acTrucks.getSpeed());
        s.setHandoffInError(acTrucks.isHandoffSensorsInError());
        s.setOnlineInError(acTrucks.isOnlineSensorsInError());
        s.setStandbyInError(acTrucks.isStandbySensorsInError());
        s.setHandoffSensorValue0(acTrucks.getHandoffPositionSensor0().getDigitalValue());
        s.setHandoffSensorValue1(acTrucks.getHandoffPositionSensor1().getDigitalValue());
        s.setOnlineSensorValue0(acTrucks.getOnlinePositionSensor0().getDigitalValue());
        s.setOnlineSensorValue1(acTrucks.getOnlinePositionSensor1().getDigitalValue());
        s.setStandbySensorValue0(acTrucks.getStandbyPositionSensor0().getDigitalValue());
        s.setStandbySensorValue1(acTrucks.getStandbyPositionSensor1().getDigitalValue());
        return s;
    }

    public static StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch(FilterLatch latch) {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPresenceSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus());
        status.setControllerInFault(latch.isControllerInFault());
        return status;
    }

    public static StatusDataPublishedByAutochangerTwoLatches createStatusDataPublishedByTwoLatches(AutochangerTwoLatches latches) {
        StatusDataPublishedByAutochangerTwoLatches status = new StatusDataPublishedByAutochangerTwoLatches();
        status.setName(latches.getName());
        status.setLockStatus(latches.getLockStatus());
        status.setFilterPresenceStatus(latches.getFilterPresenceStatus());
        return status;
    }

    public static StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps(AutochangerThreeOnlineClamps clamps) {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(clamps.getName());
        status.setLockStatus(clamps.getLockStatus());
        return status;
    }

    public static StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp(AutochangerOnlineClampModule clamp) {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(clamp.getName());
        status.setLockSensorValue(clamp.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(clamp.getUnlockSensor().getDigitalValue());
        status.setLockStatus(clamp.getLockStatus());
        status.setLockSensorInError(clamp.isLockSensorInError());
        status.setUnlockSensorInError(clamp.isUnlockSensorInError());
        status.setInError(clamp.isInError());
        status.setControllerInFault(clamp.isControllerInFault());
        return status;
    }

    public static StatusDataPublishedByCarousel createStatusDataPublishedByCarousel(CarouselModule carousel) {
        int nbSockets = carousel.getNbSockets();
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel(nbSockets);
        status.setRotationInDegrees(carousel.getPosition());
        status.setIsLocked(carousel.isLocked());
        int i = 0;
        while (i < nbSockets) {
            status.setFilterName(i, carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName());
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            ++i;
        }
        status.setFilterInStandbyName(carousel.getFilterInStandbyName());
        status.setActuatorXminusState(carousel.getClampActuatorXminus().toString());
        status.setActuatorXplusState(carousel.getClampActuatorXplus().toString());
        return status;
    }

    public static StatusDataPublishedByClamp createStatusDataPublishedByClamp(CarouselClampModule clamp) {
        StatusDataPublishedByClamp status = new StatusDataPublishedByClamp();
        status.setName(clamp.getName());
        status.setClampState(clamp.getClampState().toString());
        status.setFilterPositionInClamp(clamp.getFilterPresenceStatus().toString());
        status.setFilterPositionSensorValue(clamp.getFilterPresenceSensor().getValue());
        status.setLockSensorValue(clamp.getLockSensor().getValue());
        status.setLockStatus(clamp.getLockStatus().toString());
        status.setTemperature(clamp.getTemperature());
        return status;
    }

    public static StatusDataPublishedByClampActuator createStatusDataPublishedByClampActuator(Actuator actuator) {
        StatusDataPublishedByClampActuator status = new StatusDataPublishedByClampActuator();
        status.setName(actuator.getName());
        status.setReadValue(actuator.getReadActualCurrent());
        status.setSentValue(actuator.getSentCurrentValue());
        status.setOn(actuator.isOn());
        return status;
    }

    public static StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp(LoaderClampModule clamp) {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(clamp.getName());
        status.setPosition(clamp.getPosition());
        status.setCurrent(clamp.getReadCurrent());
        status.setClampState(clamp.getLockStatus());
        status.setStatusPublishedByHook1(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook1()));
        status.setStatusPublishedByHook2(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook2()));
        status.setStatusPublishedByHook3(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook3()));
        status.setStatusPublishedByHook4(FcsUtils.createStatusDataPublishedByLoaderHook(clamp.getHook4()));
        return status;
    }

    private static StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook(LoaderHookModule hook) {
        StatusDataPublishedByLoaderHook status = new StatusDataPublishedByLoaderHook(hook.getName(), hook.getLockSensor().getDigitalValue(), hook.getUnlockSensor().getDigitalValue(), hook.isInError(), hook.getLockStatus().toString());
        return status;
    }

    public static StatusDataPublishedByLoaderCarrier createStatusDataPublishedByLoaderCarrier(LoaderCarrierModule carrier) {
        StatusDataPublishedByLoaderCarrier status = new StatusDataPublishedByLoaderCarrier(carrier.getName(), carrier.getPosition(), carrier.getSsiPosition(), carrier.getSpeed(), carrier.getCurrent(), carrier.getStoragePositionSensor0().getDigitalValue(), carrier.getStoragePositionSensor1().getDigitalValue(), carrier.getHandoffPositionSensor0().getDigitalValue(), carrier.getHandoffPositionSensor1().getDigitalValue(), carrier.isStorageSensorsInError(), carrier.isHandoffSensorsInError(), carrier.isControllerInFault());
        status.setLimitSwitchDownInError(carrier.isLimitSwitchDownInError());
        status.setLimitSwitchUpInError(carrier.isLimitSwitchUpInError());
        return status;
    }

    public static StatusDataPublishedByLoader createStatusDataPublishedByLoader(LoaderModule loader) {
        StatusDataPublishedByLoader status = new StatusDataPublishedByLoader();
        status.setName(loader.getName());
        status.setAutochangerHoldingFilterSensorValue(loader.getAutochangerHoldingFilterSensor().getDigitalValue());
        status.setFilterPresenceSensorValue0(loader.getFilterPresenceSensor0().getDigitalValue());
        status.setFilterPresenceSensorValue1(loader.getFilterPresenceSensor1().getDigitalValue());
        status.setFilterPresenceSensorsInError(loader.isFilterPresenceSensorsInError());
        status.setLoaderOnCameraSensorValue0(loader.getLoaderOnCameraSensor0().getDigitalValue());
        status.setLoaderOnCameraSensorValue1(loader.getLoaderOnCameraSensor1().getDigitalValue());
        status.setLoaderOnCameraSensorsInError(loader.isLoaderOnCameraSensorsInError());
        return status;
    }

    public static StatusDataPublishedByHardware createStatusDataPublishedByHardware(PieceOfHardware device) {
        StatusDataPublishedByHardware status = new StatusDataPublishedByHardware(device.getName(), device.isBooted(), device.isInitialized());
        return status;
    }

    public static StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController(EPOSController ctlr) {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController();
        status.setName(ctlr.getName());
        status.setBooted(ctlr.isBooted());
        status.setInitialized(ctlr.isInitialized());
        status.setEnabled(ctlr.isEnabledToPublish());
        status.setInError(ctlr.isInError());
        status.setErrorRegister(ctlr.getErrorRegister());
        status.setErrorHistory(ctlr.getErrorHistory());
        status.setMode(ctlr.getModeInString());
        return status;
    }

    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }

    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }

    public static String replaceDigit(String twoBytesInHexa, int bitPosition, String digit) {
        if (bitPosition < 0 || bitPosition > 15) {
            throw new IllegalArgumentException("replaceDigit:  bitPosition must be: 0< bitPosition <15");
        }
        if (!digit.equals("0") && !digit.equals("1")) {
            throw new IllegalArgumentException("replaceDigit:  digit must 0 or 1");
        }
        StringBuilder bin = new StringBuilder(FcsUtils.twoBytesInHexaToBinary(twoBytesInHexa));
        bin.replace(15 - bitPosition, 15 - bitPosition + 1, digit);
        return Integer.toHexString(Integer.parseInt(bin.toString(), 2));
    }

    public static String force2zero(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 16) {
            sb.append('1');
            ++i;
        }
        sb.setCharAt(16 - (pos + 1), '0');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal & mask;
        return Integer.toHexString(myNewVal);
    }

    public static String force2one(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 16) {
            sb.append('0');
            ++i;
        }
        sb.setCharAt(16 - (pos + 1), '1');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal | mask;
        return Integer.toHexString(myNewVal);
    }

    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];
        int i = 0;
        while (i < 16) {
            int bit;
            tab[i] = bit = decimal >> i & 1;
            ++i;
        }
        return tab;
    }
}

