/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LPNHETestBenchMainModule
extends Module {
    protected static final Logger fcslog = FcsUtils.log;
    private BridgeToHardware bridge;
    private CarouselClampModule clampXminus;
    private AtomicBoolean haltRequired;

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public CarouselClampModule getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    public double readTemperature() throws FcsHardwareException {
        return this.clampXminus.updateTemperature();
    }

    public boolean isHardwareConnected() {
        return this.bridge.isCWrapperConnected();
    }

    public boolean isHardwareReady() {
        return this.bridge.isHardwareReady();
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                fcslog.debug((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case INTERRUPT1: {
                break;
            }
            case INTERRUPT2: {
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }
}

