/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenDigitaxVariator
extends CanOpenDevice {
    protected DigitaxMode mode;
    Map<String, Integer> paramsForVelocity;
    Map<String, Integer> paramsForTorque_Profile;
    final Lock lock = new ReentrantLock();
    final Condition enablingCompleted = this.lock.newCondition();
    protected volatile boolean enabling = false;

    public CanOpenDigitaxVariator(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForVelocity, Map<String, Integer> paramsForTorque_Profile) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.paramsForVelocity = paramsForVelocity;
        this.paramsForTorque_Profile = paramsForTorque_Profile;
    }

    @Override
    public void initModule() {
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Change Digitax variator mode .")
    public String changeMode(String modeInString) throws SDORequestException {
        DigitaxMode newMode = DigitaxMode.valueOf(modeInString.trim().toUpperCase());
        return this.changeMode(newMode);
    }

    public String changeMode(DigitaxMode newMode) throws SDORequestException {
        this.writeSDO("6060", "0", "1", newMode.modeInHexa);
        this.mode = newMode;
        return String.valueOf(this.name) + " mode has been changed to: " + newMode.toString() + ". Please check parameters associated with this mode.";
    }

    public String readMode() throws SDORequestException, ShortResponseToSDORequestException {
        DigitaxMode readMode;
        String modeInHexa = this.readSDO("6061", "0").trim().toUpperCase();
        this.mode = readMode = DigitaxMode.getMode(modeInHexa);
        return readMode.toString();
    }

    public static String displayListParameters(String modeInString) {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        Parameter[] parameterArray = params = DigitaxMode.valueOf(modeInString).parameters;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            sb.append(param.display());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        Parameter[] parameterArray = params = Parameter.values();
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            sb.append(param.display());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public int readTorque_actual_value() throws SDORequestException, ShortResponseToSDORequestException {
        return this.readParameter("torque_actual_value");
    }

    public String writeTorque(int value) throws SDORequestException {
        return this.writeParameter(Parameter.target_torque, value);
    }

    public String readParameters(String modeInString) throws SDORequestException, ShortResponseToSDORequestException {
        Parameter[] params;
        StringBuilder sb = new StringBuilder("Value set for the parameters for the mode : ");
        sb.append(modeInString);
        sb.append("\n");
        Parameter[] parameterArray = params = DigitaxMode.valueOf(modeInString).parameters;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            String valueInHexa = this.readSDO(param.index, param.subindex);
            int valueInt = Integer.parseInt(valueInHexa, 16);
            sb.append(param.toString());
            sb.append("=");
            sb.append(valueInt);
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public String readParameters() throws SDORequestException, ShortResponseToSDORequestException {
        String modeInString = this.readMode();
        return this.readParameters(modeInString);
    }

    public int readParameter(String parameterName) throws SDORequestException, ShortResponseToSDORequestException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.readParameter(param);
    }

    public int readParameter(Parameter param) throws SDORequestException, ShortResponseToSDORequestException {
        String valueInHexa = this.readSDO(param.index, param.subindex);
        return new BigInteger(valueInHexa, 16).intValue();
    }

    public String printParameters(String modeInString) {
        DigitaxMode aMode = DigitaxMode.valueOf(modeInString.trim().toUpperCase());
        Map<String, Integer> paramsMap = null;
        switch (aMode) {
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case TORQUE_PROFILE: {
                paramsMap = this.paramsForTorque_Profile;
            }
        }
        return this.printParameters(paramsMap);
    }

    public String printParameters(Map<String, Integer> paramMap) {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("Parameters in configuration file:\n");
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            sb.append("key=");
            sb.append(paramName);
            sb.append("/value=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void writeParameters(String modeInString) throws SDORequestException, ErrorInCommandExecutionException {
        DigitaxMode aMode = DigitaxMode.valueOf(modeInString);
        this.writeParameters(aMode);
    }

    public void writeParameters(DigitaxMode mode) throws SDORequestException, ErrorInCommandExecutionException {
        String modeInString = mode.toString();
        Map<String, Integer> paramsMap = null;
        switch (mode) {
            case VELOCITY: {
                paramsMap = this.paramsForVelocity;
                break;
            }
            case TORQUE_PROFILE: {
                paramsMap = this.paramsForTorque_Profile;
            }
        }
        if (paramsMap == null) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "parameters for mode :" + modeInString + "are NULL");
        }
        if (paramsMap.isEmpty()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "parameters for mode :" + modeInString + "are not defined.");
        }
        this.writeParameters(paramsMap);
    }

    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(paramName, value);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Set Digitax Variator parameter with the value given as argument.")
    public String writeParameter(String parameterName, int value) throws SDORequestException {
        Parameter param = Parameter.valueOf(parameterName);
        return this.writeParameter(param, value);
    }

    public String writeParameter(Parameter param, int value) throws SDORequestException {
        this.writeSDO(param.index, param.subindex, param.size, Integer.toHexString(value));
        return String.format("%s has been written to the Digitax Variator CPU, value=%d", param.toString(), value);
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    /*
     * Exception decompiling
     */
    public boolean isEnable() throws SDORequestException, ShortResponseToSDORequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void faultReset() throws SDORequestException {
        this.writeControlWord("80");
    }

    public String enable() throws SDORequestException {
        this.lock.lock();
        try {
            this.enabling = true;
            this.shutdown();
            this.switchOnEnableOperation();
            String string = String.valueOf(this.name) + " ENABLE";
            return string;
        }
        finally {
            this.enabling = false;
            this.enablingCompleted.signal();
            this.lock.unlock();
        }
    }

    public String shutdown() throws SDORequestException {
        this.writeControlWord("6");
        return String.valueOf(this.name) + " DISABLE";
    }

    public void switchOnEnableOperation() throws SDORequestException {
        this.writeControlWord("F");
    }

    @Override
    public Object saveParameters() throws SDORequestException {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    public Object restoreParameters() throws SDORequestException {
        return this.writeSDO("1011", "1", "4", "64616F6C");
    }

    public void writeControlWord(String value) throws SDORequestException {
        this.writeSDO("6040", "0", "2", value);
    }

    public String readControlWord() throws SDORequestException, ShortResponseToSDORequestException {
        return this.readSDO("6040", "0");
    }

    public String readStatusWord() throws SDORequestException, ShortResponseToSDORequestException {
        return this.readSDO("6041", "0");
    }

    public void quickStop() throws SDORequestException {
        switch (this.mode) {
            case VELOCITY: {
                this.writeControlWord("B");
                break;
            }
            case TORQUE_PROFILE: {
                this.writeControlWord("B");
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(CanOpenDigitaxVariator.displayListParameters("VELOCITY"));
        System.out.println(CanOpenDigitaxVariator.displayListParameters("TORQUE_PROFILE"));
        System.out.println(CanOpenDigitaxVariator.displayListParameters());
    }

    public static enum DigitaxMode {
        VELOCITY("2", Parameter.vl_target_velocity, Parameter.vl_velocity_demand, Parameter.vl_control_effort, Parameter.vl_velocity_min_max_amount, Parameter.vl_velocity_acceleration, Parameter.vl_velocity_deceleration, Parameter.vl_dimension_factor, Parameter.vl_pole_number),
        TORQUE_PROFILE("4", Parameter.target_torque, Parameter.torque_actual_value, Parameter.motor_rated_current, Parameter.torque_slope, Parameter.torque_profile_type);

        private final String modeInHexa;
        private final Parameter[] parameters;

        private DigitaxMode(String modeToHexa, Parameter ... params) {
            this.modeInHexa = modeToHexa;
            this.parameters = params;
        }

        String getModeInHexa() {
            return this.modeInHexa;
        }

        public static DigitaxMode getMode(String hexa) {
            DigitaxMode[] modes = DigitaxMode.values();
            boolean modeFound = false;
            DigitaxMode[] digitaxModeArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                DigitaxMode mode = digitaxModeArray[n2];
                if (mode.getModeInHexa().equals(hexa.toUpperCase())) {
                    return mode;
                }
                ++n2;
            }
            if (!modeFound) {
                throw new IllegalArgumentException(String.valueOf(hexa) + ": this mode doesn't exist in DigitaxVariator.DigitaxMode ENUM");
            }
            return null;
        }
    }

    public static enum Parameter {
        target_torque("6071", "00", "2", true),
        torque_actual_value("6077", "00", "2", true),
        motor_rated_current("6075", "00", "4", false),
        torque_slope("6087", "00", "4", true),
        torque_profile_type("6088", "00", "1", true),
        vl_target_velocity("6042", "00", "2", true),
        vl_velocity_demand("6043", "00", "2", true),
        vl_control_effort("6044", "00", "2", true),
        vl_velocity_min_max_amount("6046", "00", "4", false),
        vl_velocity_acceleration("6048", "01", "4", true),
        vl_velocity_deceleration("6049", "02", "4", true),
        vl_dimension_factor("604C", "00", "4", true),
        vl_pole_number("604D", "00", "1", false);

        String index;
        String subindex;
        String size;
        boolean signed;

        private Parameter(String index, String subindex, String size, boolean signed) {
            this.index = index;
            this.subindex = subindex;
            this.size = size;
            this.signed = signed;
        }

        public String display() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("/index=").append(this.index);
            sb.append("/subindex=").append(this.subindex);
            sb.append("/size=").append(this.size).append(" bytes");
            if (this.signed) {
                sb.append("/SIGNED");
            } else {
                sb.append("/UNSIGNED");
            }
            return sb.toString();
        }
    }
}

