/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class TruckModule
extends Module {
    protected static final Logger fcslog = FcsUtils.log;
    private FcsEnumerations.AutoChangerTrucksLocation truckLocation;
    protected NumericSensor railSensorStandback;
    protected NumericSensor railSensorStandby;
    private volatile boolean updatingTruckLocation = false;
    final Lock lock = new ReentrantLock();
    final Condition truckLocationUpdated = this.lock.newCondition();

    public TruckModule(String aName, int aTickMillis, NumericSensor railSensorStandback, NumericSensor railSensorStandby) {
        super(aName, aTickMillis);
        this.railSensorStandback = railSensorStandback;
        this.railSensorStandby = railSensorStandby;
    }

    public NumericSensor getRailSensorStandback() {
        return this.railSensorStandback;
    }

    public void setRailSensorStandback(NumericSensor railSensorStandback) {
        this.railSensorStandback = railSensorStandback;
    }

    public NumericSensor getRailSensorStandby() {
        return this.railSensorStandby;
    }

    public void setRailSensorStandby(NumericSensor railSensorStandby) {
        this.railSensorStandby = railSensorStandby;
    }

    public void initModule() {
        this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.AutoChangerTrucksLocation getTruckLocation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateLocation(String hexaValueOfInputs) throws ErrorInCommandExecutionException {
        this.lock.lock();
        try {
            this.updatingTruckLocation = true;
            fcslog.debug((Object)(String.valueOf(this.getName()) + " is updating its location in parsing the values sent by rail sensors:" + hexaValueOfInputs));
            this.railSensorStandback.updateValue(hexaValueOfInputs);
            this.railSensorStandby.updateValue(hexaValueOfInputs);
            int standbackValue = this.railSensorStandback.getDigitalValue();
            int standbyValue = this.railSensorStandby.getDigitalValue();
            if (standbyValue == 1 && standbackValue == 0) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
            } else if (standbyValue == 0 && standbackValue == 1) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
            } else if (standbyValue == 0 && standbackValue == 0) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
            } else if (standbyValue == 1 && standbackValue == 1) {
                this.truckLocation = FcsEnumerations.AutoChangerTrucksLocation.ERROR;
                throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " ERROR IN READING RAIL SENSORS : a truck can't be at standby AND at standback ");
            }
            fcslog.debug((Object)("truckLocation=" + this.truckLocation.toString()));
        }
        finally {
            this.updatingTruckLocation = false;
            this.truckLocationUpdated.signal();
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/rail sensor at STANDBACK=");
        if (this.railSensorStandback == null) {
            sb.append("NULL");
        } else {
            sb.append(this.railSensorStandback.getName());
        }
        sb.append("/rail sensor at STANDBY=");
        if (this.railSensorStandby == null) {
            sb.append("NULL");
        } else {
            sb.append(this.railSensorStandby.getName());
        }
        return sb.toString();
    }
}

