/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.Observable;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SftMainModule
extends MainModule {
    private final Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private boolean filterLocated;

    public SftMainModule(String aName, int aTickMillis, BridgeToHardware bridge, Filter dummyFilter) {
        super(aName, aTickMillis, bridge);
        this.dummyFilter = dummyFilter;
    }

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (SftCarouselModule)this.getModule("carousel");
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.hardwareReady = false;
        this.filterLocated = false;
    }

    public void tick() {
        if (this.isHardwareReady() && !this.filterLocated) {
            try {
                this.locateFilter();
                this.filterLocated = true;
                fcslog.info((Object)"Filter has been located. Hardware is ready to receive commands.");
                fcslog.debug((Object)"DEBUGGING");
            }
            catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
                this.filterLocated = false;
                fcslog.error((Object)ex);
                this.getSubsystem().raiseAlarm(ex.toString());
            }
        }
    }

    @Command(level=0, description="Read the sensors and update the location of the filter and the state of the carousel and the autochanger.", type=Command.CommandType.QUERY)
    public void locateFilter() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        fcslog.debug((Object)"MODE DEBUG");
        this.carousel.updateClampsStateWithSensors();
        if (this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER) || this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.carousel.getSockets()[0].putFilterOnSocket(this.dummyFilter);
        }
        this.autochanger.updateLatchesStateWithSensors();
        if (!this.autochanger.isTrucksEmpty()) {
            this.autochanger.setFilterOnTrucks(this.dummyFilter);
        }
        this.autochanger.updateTrucksLocationWithSensors();
    }

    @Command(level=1, description="Check if the carousel is ready to unlock the clamps in a safe way for the filter.", type=Command.CommandType.QUERY, alias="checkUnlock")
    public void checkPreConditionsForUnlockClamps() throws FcsHardwareException, BadCommandException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (this.carousel.isHoldingFilterAtStandby() && !this.autochanger.isHoldingFilterAtStandby()) {
            throw new ErrorInCommandExecutionException("Can't unlock clamps if filter is not held by autochanger.");
        }
    }

    @Command(level=1, description="To display at a console the status of the hardware.", type=Command.CommandType.QUERY)
    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getSubsystem().getName()).append("\n  ");
        fcslog.info((Object)("Carousel status=" + this.carousel.toString()));
        sb.append(this.carousel.toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().toString());
        sb.append("\n  ");
        fcslog.info((Object)("autochanger status=" + this.autochanger.toString()));
        sb.append(this.autochanger.toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    @Command(level=1, description="Move the hardware to the initial state : ", type=Command.CommandType.ACTION)
    public String goToInitialState() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.updateStateWithSensors();
        String ack = "Hardware is at initial state and ready for a sequence1";
        if (this.carousel.isHoldingFilterAtStandby()) {
            if (this.autochanger.isAtStandback()) {
                return ack;
            }
            if (this.autochanger.isAtStandby()) {
                fcslog.info((Object)"=======> Autochanger moving back empty to online position.");
                this.autochanger.ungrabFilterAtStandby();
                return ack;
            }
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        if (this.autochanger.isHoldingFilterAtStandback()) {
            if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
                this.carousel.releaseClamps();
            }
            fcslog.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            fcslog.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            fcslog.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (this.autochanger.isHoldingFilterAtStandby()) {
            fcslog.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
            this.autochanger.moveFilterToStandback(this.dummyFilter);
            fcslog.info((Object)"=======> Carousel about to release Clamps.");
            this.carousel.releaseClamps();
            fcslog.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
            this.autochanger.moveFilterToStandby(this.dummyFilter);
            fcslog.info((Object)"=======> Carousel is grabbing filter at standby position.");
            this.carousel.grabFilterAtStandby(this.getDummyFilter());
            fcslog.info((Object)"=======> Autochanger moving back empty to online position.");
            this.autochanger.ungrabFilterAtStandby();
            return ack;
        }
        if (!this.autochanger.isAtStandback() && !this.autochanger.isAtStandby()) {
            return "Autochanger trucks are in the midle, I don't know what to do.";
        }
        return "Nobody holds the filter : I don't know how to go to initial state.";
    }

    @Command(level=0, description="The world famous sequence 1", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        fcslog.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        if (this.haltRequired.get()) {
            return String.valueOf(this.getName()) + " Execution of Sequence1 HALTED at step 1";
        }
        fcslog.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(this.dummyFilter);
        if (this.haltRequired.get()) {
            return String.valueOf(this.getName()) + " Execution of Sequence1 HALTED at step 2";
        }
        fcslog.info((Object)"=======> Autochanger trucks about to move loaded with the filter to standback position.");
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        fcslog.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        if (this.haltRequired.get()) {
            return String.valueOf(this.getName()) + " Execution of Sequence1 HALTED at step 3";
        }
        fcslog.info((Object)"=======> Autochanger trucks moving back the filter to standby position.");
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        fcslog.info((Object)"=======> Carousel is grabbing filter at standby position.");
        this.carousel.grabFilterAtStandby(this.getDummyFilter());
        if (this.haltRequired.get()) {
            return String.valueOf(this.getName()) + " Execution of Sequence1 HALTED at step 4";
        }
        fcslog.info((Object)"=======> Autochanger moving back empty to online position.");
        this.autochanger.ungrabFilterAtStandby();
        fcslog.info((Object)"=======> Execution of Sequence1 completed.");
        return String.valueOf(this.getName()) + " Execution of Sequence1 completed";
    }

    @Command(level=0, description="The world famous sequence 1 (with number of repetitions)", type=Command.CommandType.ACTION, alias="es1")
    public String executeSequence1(@Argument(name="nExecutions", description="Number of executions") int nb) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        int i = 1;
        while (i < nb + 1) {
            fcslog.info((Object)("===========================BEGIN execution Sequence1 nb=" + i + " ================"));
            this.executeSequence1();
            fcslog.info((Object)("===========================END execution Sequence1 nb=" + i + " ================"));
            ++i;
        }
        return String.valueOf(this.getName()) + ":" + nb + " executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
    }

    public String printFilters() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + " printFilters \n ");
        sb.append(this.dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(this.dummyFilter));
        sb.append(" socket number: ").append(this.carousel.getSocketNumber(this.dummyFilter));
        sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.dummyFilter));
        fcslog.info((Object)sb.toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    @Override
    @Command(level=1, description="Read the sensors and update the state of the carousel and the autochanger.", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                fcslog.info((Object)"HALT required");
                this.haltRequired.set(true);
                break;
            }
            case INTERRUPT1: {
                break;
            }
            case INTERRUPT2: {
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                break;
            }
            case STOP: {
                fcslog.info((Object)"STOP required");
                this.haltRequired.set(true);
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public SftCarouselModule getCarouselModule() {
        return this.carousel;
    }

    public SftAutoChangerModule getAutoChangerModule() {
        return this.autochanger;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="The GUIs need that for the initialization.")
    public SingleFilterTestConfig getFullState() {
        return FcsUtils.createSingleFilterTestConfig(this);
    }
}

