/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderClampController
extends SimuEPOSControllerModule {
    LoaderClampModule clamp;
    SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderClampController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.clamp = (LoaderClampModule)this.getModule("clamp");
        this.plutoGateway = (SimuLoaderPlutoGateway)this.getModule("plutoGateway");
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        fcslog.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        int i = 1;
        while (i < stepsNB) {
            this.actualCurrent = currentInitial + i * step;
            this.clamp.updateCurrent();
            if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
                log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.position = this.clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else if (this.actualCurrent == this.clamp.getCurrentToGoHome()) {
                this.position = this.clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            }
            this.clamp.publishData();
            fcslog.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(500L);
                if (this.clamp.getHaltRequired().get()) {
                    log.debug((Object)(String.valueOf(this.name) + " STOP simulated clamp motion."));
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new BadCommandException(String.valueOf(this.name) + " sleep was interrupted.");
            }
            ++i;
        }
        this.actualCurrent = aValue;
        if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
            log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.position = this.clamp.getTargetPositionToClamp();
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (this.actualCurrent == this.clamp.getCurrentToGoHome()) {
            this.position = this.clamp.getTargetPositionToOpen();
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        }
        this.clamp.publishData();
    }

    @Override
    public void writeTargetPosition(int positionToReached) throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug((Object)("=>position intitiale=" + this.position));
        int stepsNB = 10;
        int step = (this.targetPosition - this.position) / stepsNB;
        int i = 1;
        while (i < stepsNB) {
            this.position = positionInitiale + i * step;
            this.clamp.updatePosition();
            if (this.position == this.clamp.getTargetPositionToOpen()) {
                log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            } else if (this.position == this.clamp.getTargetPositionToClose()) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else if (this.position == this.clamp.getTargetPositionToClamp()) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else {
                this.plutoGateway.simulateLoaderClampIsInTravel();
            }
            this.clamp.publishData();
            fcslog.debug((Object)("i=" + i + ",position=" + this.position));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                throw new BadCommandException(String.valueOf(this.name) + " sleep was interrupted.");
            }
            ++i;
        }
        this.position = this.targetPosition;
        if (this.position == this.clamp.getTargetPositionToOpen()) {
            log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        } else if (this.position == this.clamp.getTargetPositionToClose()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (this.position == this.clamp.getTargetPositionToClamp()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();
        }
        this.clamp.publishData();
    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

