/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderCarrierController
extends SimuEPOSControllerModule {
    LoaderCarrierModule carrier;
    SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderCarrierController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carrier = (LoaderCarrierModule)this.getModule("carrier");
        this.plutoGateway = (SimuLoaderPlutoGateway)this.getModule("plutoGateway");
    }

    @Override
    public void writeTargetPosition(int positionToReached) throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug((Object)"loader carrier is moving.");
        fcslog.debug((Object)(String.valueOf(this.name) + "=>position intitiale=" + this.position));
        int stepsNB = 20;
        int step = (this.targetPosition - this.position) / stepsNB;
        int i = 1;
        while (i < stepsNB) {
            try {
                this.position = positionInitiale + i * step;
                this.carrier.updatePosition();
                if (this.position == this.carrier.getHandoffPosition()) {
                    log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (this.position == this.carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                this.carrier.updateStateWithSensors();
                this.carrier.publishData();
                fcslog.debug((Object)(String.valueOf(this.name) + "i=" + i + ",position=" + this.position));
                try {
                    Thread.sleep(500L);
                    if (this.carrier.getHaltRequired().get()) {
                        log.debug((Object)(String.valueOf(this.name) + " STOP simulated carrrier motion."));
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new BadCommandException(String.valueOf(this.name) + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                throw new BadCommandException(ex.getMessage());
            }
            ++i;
        }
        this.position = this.targetPosition;
        if (this.position == this.carrier.getHandoffPosition()) {
            log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (this.position == this.carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

