/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLatchController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerOnlineClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGWSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway {
    private AutoChangerTrucksModule trucks;
    SimuAutochangerLinearRailController trucksController;
    SimuAutochangerLatchController latchXminusController;
    SimuAutochangerLatchController latchXplusController;
    SimuAutochangerOnlineClampController onlineClampXminusController;
    SimuAutochangerOnlineClampController onlineClampXplusController;
    SimuAutochangerOnlineClampController onlineClampZController;
    SimuPlutoGWSensor handoffPositionSensor0;
    SimuPlutoGWSensor handoffPositionSensor1;
    SimuPlutoGWSensor onlinePositionSensor0;
    SimuPlutoGWSensor onlinePositionSensor1;
    SimuPlutoGWSensor standbyPositionSensor0;
    SimuPlutoGWSensor standbyPositionSensor1;
    SimuPlutoGWSensor loaderConnectedSensor0;
    SimuPlutoGWSensor loaderConnectedSensor1;
    SimuPlutoGWSensor lockSensorLatchXminus;
    SimuPlutoGWSensor unlockSensorLatchXminus;
    SimuPlutoGWSensor filterPresenceSensorLatchXminus;
    SimuPlutoGWSensor lockSensorLatchXplus;
    SimuPlutoGWSensor unlockSensorLatchXplus;
    SimuPlutoGWSensor filterPresenceSensorLatchXplus;
    SimuPlutoGWSensor lockSensorClampXminus;
    SimuPlutoGWSensor lockSensorCClampXminus;
    SimuPlutoGWSensor unlockSensorClampXminus;
    SimuPlutoGWSensor unlockSensorCClampXminus;
    SimuPlutoGWSensor lockSensorClampXplus;
    SimuPlutoGWSensor lockSensorCClampXplus;
    SimuPlutoGWSensor unlockSensorClampXplus;
    SimuPlutoGWSensor unlockSensorCClampXplus;
    SimuPlutoGWSensor lockSensorClampZ;
    SimuPlutoGWSensor lockSensorCClampZ;
    SimuPlutoGWSensor unlockSensorClampZ;
    SimuPlutoGWSensor unlockSensorCClampZ;

    public SimuAutochangerPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.handoffPositionSensor0 = (SimuPlutoGWSensor)this.getModule("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor)this.getModule("handoffPositionSensor1");
        this.onlinePositionSensor0 = (SimuPlutoGWSensor)this.getModule("onlinePositionSensor0");
        this.onlinePositionSensor1 = (SimuPlutoGWSensor)this.getModule("onlinePositionSensor1");
        this.standbyPositionSensor0 = (SimuPlutoGWSensor)this.getModule("standbyPositionSensor0");
        this.standbyPositionSensor1 = (SimuPlutoGWSensor)this.getModule("standbyPositionSensor1");
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor)this.getModule("loaderConnectedSensor0");
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor)this.getModule("loaderConnectedSensor1");
        this.trucksController = (SimuAutochangerLinearRailController)this.getModule("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule)this.getModule("trucks");
        this.simulateAutochangerTrucksIsAtStandby();
        this.lockSensorLatchXminus = (SimuPlutoGWSensor)this.getModule("lockSensorLatchXminus");
        this.unlockSensorLatchXminus = (SimuPlutoGWSensor)this.getModule("unlockSensorLatchXminus");
        this.filterPresenceSensorLatchXminus = (SimuPlutoGWSensor)this.getModule("filterPresenceSensorLatchXminus");
        this.lockSensorLatchXplus = (SimuPlutoGWSensor)this.getModule("lockSensorLatchXplus");
        this.unlockSensorLatchXplus = (SimuPlutoGWSensor)this.getModule("unlockSensorLatchXplus");
        this.filterPresenceSensorLatchXplus = (SimuPlutoGWSensor)this.getModule("filterPresenceSensorLatchXplus");
        this.latchXminusController = (SimuAutochangerLatchController)this.getModule("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController)this.getModule("latchXplusController");
        this.lockSensorClampXminus = (SimuPlutoGWSensor)this.getModule("lockSensorClampXminus");
        this.lockSensorCClampXminus = (SimuPlutoGWSensor)this.getModule("lockSensorCClampXminus");
        this.unlockSensorClampXminus = (SimuPlutoGWSensor)this.getModule("unlockSensorClampXminus");
        this.unlockSensorCClampXminus = (SimuPlutoGWSensor)this.getModule("unlockSensorCClampXminus");
        this.lockSensorClampXplus = (SimuPlutoGWSensor)this.getModule("lockSensorClampXplus");
        this.lockSensorCClampXplus = (SimuPlutoGWSensor)this.getModule("lockSensorCClampXplus");
        this.unlockSensorClampXplus = (SimuPlutoGWSensor)this.getModule("unlockSensorClampXplus");
        this.unlockSensorCClampXplus = (SimuPlutoGWSensor)this.getModule("unlockSensorCClampXplus");
        this.lockSensorClampZ = (SimuPlutoGWSensor)this.getModule("lockSensorClampZ");
        this.lockSensorCClampZ = (SimuPlutoGWSensor)this.getModule("lockSensorCClampZ");
        this.unlockSensorClampZ = (SimuPlutoGWSensor)this.getModule("unlockSensorClampZ");
        this.unlockSensorCClampZ = (SimuPlutoGWSensor)this.getModule("unlockSensorCClampZ");
        this.simulateFilterIsOnAutochanger();
        this.simulateAutochangerLatchesAreLocked();
        this.simulateAutochangerOnlineClampsAreUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "1");
        this.replaceDigitalValues(this.handoffPositionSensor1, "1");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsOnline() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "1");
        this.replaceDigitalValues(this.onlinePositionSensor1, "1");
        this.trucksController.setPosition(this.trucks.getOnlinePosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtStandby() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "1");
        this.replaceDigitalValues(this.standbyPositionSensor1, "1");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getStandbyPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsInTravel() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "1");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "0");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "1");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        this.replaceDigitalValues(this.filterPresenceSensorLatchXminus, "0");
        this.replaceDigitalValues(this.filterPresenceSensorLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
        this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
        this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "0");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "1");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "0");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.replaceDigitalValues(this.lockSensorLatchXminus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
            this.replaceDigitalValues(this.lockSensorLatchXplus, "0");
            this.replaceDigitalValues(this.unlockSensorLatchXplus, "1");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        this.simulateAutochangerOnlineClampXminusIsLocked();
        this.simulateAutochangerOnlineClampXplusIsLocked();
        this.simulateAutochangerOnlineClampZIsLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        this.simulateAutochangerOnlineClampXminusIsUnlocked();
        this.simulateAutochangerOnlineClampXplusIsUnlocked();
        this.simulateAutochangerOnlineClampZIsUnlocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor lockSensorC, SimuPlutoGWSensor unlockSensor, SimuPlutoGWSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "1");
        this.replaceDigitalValues(lockSensorC, "0");
        this.replaceDigitalValues(unlockSensor, "0");
        this.replaceDigitalValues(unlockSensorC, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor lockSensorC, SimuPlutoGWSensor unlockSensor, SimuPlutoGWSensor unlockSensorC) {
        this.replaceDigitalValues(lockSensor, "0");
        this.replaceDigitalValues(lockSensorC, "1");
        this.replaceDigitalValues(unlockSensor, "1");
        this.replaceDigitalValues(unlockSensorC, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampXminus, this.lockSensorCClampXminus, this.unlockSensorClampXminus, this.unlockSensorCClampXminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampXminus, this.lockSensorCClampXminus, this.unlockSensorClampXminus, this.unlockSensorCClampXminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampXplus, this.lockSensorCClampXplus, this.unlockSensorClampXplus, this.unlockSensorCClampXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampXplus, this.lockSensorCClampXplus, this.unlockSensorClampXplus, this.unlockSensorCClampXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampZIsLocked() {
        this.simulateAutochangerOnlineClampIsLocked(this.lockSensorClampZ, this.lockSensorCClampZ, this.unlockSensorClampZ, this.unlockSensorCClampZ);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampZIsUnlocked() {
        this.simulateAutochangerOnlineClampIsUnlocked(this.lockSensorClampZ, this.lockSensorCClampZ, this.unlockSensorClampZ, this.unlockSensorCClampZ);
    }
}

