/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerLatchController
extends SimuEPOSControllerModule {
    String latchName;
    AutochangerLatchModule latch;
    SimuAutochangerPlutoGateway plutoGateway;

    public SimuAutochangerLatchController(String aName, int aTickMillis, String nodeID, String serialNB, String latchName, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.mode = EPOSEnumerations.EposMode.CURRENT;
        this.latchName = latchName;
    }

    @Override
    public void initModule() {
        log.debug((Object)(String.valueOf(this.name) + ":latchName=" + this.latchName));
        this.latch = (AutochangerLatchModule)this.getModule(this.latchName);
        this.plutoGateway = (SimuAutochangerPlutoGateway)this.getModule("plutoGateway");
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, SDORequestException {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        fcslog.debug((Object)("=>initial current=" + this.actualCurrent));
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        int i = 1;
        while (i <= stepsNB) {
            this.actualCurrent = i < stepsNB ? currentInitial + i * step : aValue;
            this.latch.updateCurrent();
            if (this.actualCurrent == this.latch.getCurrentToOpen()) {
                log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()));
                this.plutoGateway.simulateAutochangerLatchIsUnlocked(this.latchName);
            } else if (this.actualCurrent == -this.latch.getCurrentToOpen()) {
                this.plutoGateway.simulateAutochangerLatchIsLocked(this.latchName);
            }
            this.latch.publishData();
            fcslog.debug((Object)("i=" + i + ",actualCurrent=" + this.actualCurrent));
            try {
                Thread.sleep(200L);
                if (this.latch.getHaltRequired().get()) {
                    log.debug((Object)(String.valueOf(this.name) + " STOP simulated latch motion."));
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new BadCommandException(String.valueOf(this.name) + " sleep was interrupted.");
            }
            ++i;
        }
    }

    @Override
    public String off() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException {
        this.writeCurrent(0);
        return String.valueOf(this.name) + " is OFF";
    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

