/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.FcsTcpProxy;
import org.lsst.ccs.subsystems.fcs.errors.CWrapperNotConnected;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCommunicationException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenDeviceException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenGenericException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenMotionException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenTemperatureException;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenVoltageException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenProxy
extends FcsTcpProxy
implements HardwareController {
    private final String myClientName;
    private int expectedNodesNB = 0;
    private int bootedNodesNB = 0;
    private ArrayList<CanOpenNode> nodes;
    private boolean hardwareBootProcessEnded = false;
    private boolean hardwareIdentified = false;
    private long hardwareBootTimeout;
    private long hardwareBootProcessBeginTime;
    public PieceOfHardware[] hardwareList;
    private boolean canOpenNodeNumbersOK = false;
    StringBuilder errorMessageSB;
    boolean hardwareIDError;
    private PDOStorage pdoStorage;
    public Map<String, CanOpenNode> bootedNodesMap;

    public CanOpenProxy(String aName, int aTickMillis, int portNumber, String aClientName, long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber);
        this.myClientName = aClientName;
        this.hardwareBootTimeout = hardwareBootTimeout;
        this.nodes = new ArrayList(20);
    }

    public int getExpectedNodesNB() {
        return this.expectedNodesNB;
    }

    public void setExpectedNodesNB(int nodeNB) {
        this.expectedNodesNB = nodeNB;
    }

    public long getHardwareBootTimeout() {
        return this.hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(long hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    @ConfigChanger
    public void setHardwareBootTimeout(int hardwareBootTimeout) {
        this.hardwareBootTimeout = hardwareBootTimeout;
    }

    public PieceOfHardware[] getHardwareList() {
        return this.hardwareList;
    }

    public int getBootedNodesNB() {
        return this.bootedNodesNB;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public ArrayList<CanOpenNode> getNodes() {
        return this.nodes;
    }

    public Map<String, CanOpenNode> getBootedNodesMap() {
        return this.bootedNodesMap;
    }

    public PDOStorage getPdoStorage() {
        return this.pdoStorage;
    }

    public boolean isHardwareIdentified() {
        return this.hardwareIdentified;
    }

    public void disconnectHardware() {
        this.stopServer();
        this.nodes = new ArrayList(20);
        this.hardwareBootProcessBeginTime = 0L;
        this.bootedNodesNB = 0;
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.canOpenNodeNumbersOK = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
    }

    public void connectHardware() throws HardwareException {
        this.startServer();
        this.startThreadReader();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hardwareBootProcessBeginTime = 0L;
        this.bootedNodesNB = 0;
        this.hardwareBootProcessEnded = false;
        this.hardwareIdentified = false;
        this.canOpenNodeNumbersOK = false;
        this.hardwareIDError = false;
        this.pdoStorage = new PDOStorage();
    }

    public void tick() {
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        long hardwareBootDuration = 0L;
        fcslog.debug((Object)(String.valueOf(this.name) + ": BEGIN CHECKHARDWARE"));
        if (this.hardwareBootProcessBeginTime == 0L && this.isReady(this.myClientName)) {
            this.hardwareBootProcessBeginTime = System.currentTimeMillis();
            fcslog.debug((Object)(String.valueOf(this.name) + ": A CLIENT IS CONNECTED - BOOT PROCESS BEGIN"));
        }
        while (hardwareBootDuration < this.hardwareBootTimeout && this.bootedNodesNB < this.expectedNodesNB) {
            hardwareBootDuration = System.currentTimeMillis() - this.hardwareBootProcessBeginTime;
            fcslog.debug((Object)(String.valueOf(this.name) + ":hardwareBootDuration=" + hardwareBootDuration));
        }
        this.hardwareBootProcessEnded = true;
        this.identifyHardware();
        this.publishData();
        fcslog.debug((Object)(String.valueOf(this.name) + ": END OF BOOT PROCESS"));
        fcslog.info((Object)(String.valueOf(this.name) + "=>" + this.listNodes()));
        this.checkCanOpenNodes();
        fcslog.debug((Object)(String.valueOf(this.name) + ": END CHECKHARDWARE"));
        this.publishData();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Retrieve information for booted devices and checks if CANopen node ID and serial number match thosein description file .")
    public void checkNewHardware() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + " BEGIN checkStartedToCompleteInitialization"));
        if (!this.isTcpServerStarted()) {
            throw new HardwareException(true, String.valueOf(this.name) + ": could not start tcp server.");
        }
        this.identifyHardware();
        this.checkCanOpenNodes();
    }

    public void checkStarted() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + " BEGIN checkStarted"));
    }

    public void checkStopped() throws HardwareException {
    }

    public String getNodeName(String aNodeID) {
        String nodeName = "Unbooted nodeID:" + aNodeID;
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware hardware = pieceOfHardwareArray[n2];
            if (hardware.getNodeID().equals(aNodeID)) {
                nodeName = hardware.getName();
                return nodeName;
            }
            ++n2;
        }
        return nodeName;
    }

    public boolean isBooted(String aNodeID) {
        if (this.bootedNodesNB == 0) {
            return false;
        }
        boolean nodeFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes.get(i) != null && this.nodes.get(i).getNodeID().equals(aNodeID)) {
                nodeFound = true;
            }
            ++i;
        }
        return nodeFound;
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = (values are in HEXA)");
        if (this.bootedNodesNB == 0) {
            sb.append(this.name);
            sb.append(": No booted CANopen devices.");
        }
        int i = 0;
        while (i < this.bootedNodesNB) {
            sb.append("\n");
            if (this.nodes.get(i) == null) {
                sb.append("null node");
            } else {
                sb.append(this.nodes.get(i).toString());
            }
            ++i;
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen command to the Can Bus.")
    public String sendCanOpen(String command) throws CanOpenCallTimeoutException, BadCommandException {
        if (!this.tcpServerStarted) {
            throw new BadCommandException(String.valueOf(this.name) + ": is not started, can't send CanOpen commands.");
        }
        try {
            String keyWord;
            String[] words = command.split(",");
            switch (keyWord = words[0]) {
                case "rsdo": {
                    if (words.length == 4) break;
                    throw new BadCommandException("rsdo command must have 3 parameters: nodeID, index, subindex");
                }
                case "wsdo": {
                    if (words.length == 6) break;
                    throw new BadCommandException("wsdo command must have 5 parameters: nodeID, index, subindex, size, data");
                }
                case "info": {
                    if (words.length == 2) break;
                    throw new BadCommandException("info command must have 1 parameter: nodeID");
                }
                case "sync": {
                    if (words.length == 1) break;
                    throw new BadCommandException("sync command takes no parameter");
                }
                case "srtr": {
                    if (words.length >= 2) break;
                    throw new BadCommandException("srtr command takes at least one parameter (cobib)");
                }
                case "quit": {
                    if (words.length == 1) break;
                    throw new BadCommandException("quit command takes no parameter");
                }
                default: {
                    throw new IllegalArgumentException(command);
                }
            }
            return (String)this.call(this.getMyClientName(), command);
        }
        catch (CWrapperNotConnected ex) {
            fcslog.error((Object)(String.valueOf(this.name) + ":CWrapper not connected-" + ex.toString()));
            this.getSubsystem().raiseAlarm(String.valueOf(this.name) + " can't communicate with harwdare because CWrapper is not connected." + ex.toString());
            return ex.toString();
        }
    }

    private static String buildWsdoCommand(String nodeID, String index, String subindex, String size, String data) {
        char sep = ',';
        String command = String.format("wsdo%1$s%2$s%1$s%3$s%1$s%4$s%1$s%5$s%1$s%6$s", Character.valueOf(sep), nodeID, index, subindex, size, data);
        return command;
    }

    private static String buildRsdoCommand(String nodeID, String index, String subindex) {
        char sep = ',';
        String command = String.format("rsdo%1$s%2$s%1$s%3$s%1$s%4$s", Character.valueOf(sep), nodeID, index, subindex);
        return command;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeSDO(String nodeID, String index, String subindex, String size, String value) throws SDORequestException {
        try {
            String errorCode;
            String sdoResponseLine = this.sendCanOpen(CanOpenProxy.buildWsdoCommand(nodeID, index, subindex, size, value));
            String[] words = sdoResponseLine.split(",");
            String cfr_ignored_0 = words[0];
            String cfr_ignored_1 = words[1];
            switch (errorCode = words[2]) {
                case "0": {
                    return "OK";
                }
                case "-1": {
                    fcslog.error((Object)("Wrong writeSDO command : " + sdoResponseLine));
                    throw new SDORequestException(String.valueOf(this.name) + ":Wrong writeSDO command : " + sdoResponseLine);
                }
            }
            fcslog.error((Object)"writeSDO request was going wrong");
            String error = String.format("%08d", Integer.parseInt(errorCode));
            fcslog.info((Object)("ERROR=" + error));
            String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
            throw new SDORequestException(String.valueOf(this.name) + ":writeSDO request was going wrong", nodeID, errorCode, index, subindex, errorName);
        }
        catch (BadCommandException ex) {
            SDORequestException err = new SDORequestException(String.valueOf(this.name) + ":write SDO request bad command : ", nodeID, "bad command", index, subindex, ex.getMessage());
            fcslog.error((Object)String.format("%s %s for %s this should not happen.", "malformed SDO request : ", ex.getMessage(), nodeID));
            throw err;
        }
        catch (CanOpenCallTimeoutException ex) {
            SDORequestException err = new SDORequestException(String.valueOf(this.name) + ":write SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
            fcslog.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID));
            throw err;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen writeSDO command to the Can Bus.")
    public String writeSDO(int nodeID, String index, String subindex, int size, int value) throws SDORequestException, BadCommandException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (size < 0 || size > 4) {
            throw new IllegalArgumentException("size must be > 0 and < 4");
        }
        return this.writeSDO(Integer.toHexString(nodeID), index, subindex, Integer.toHexString(size), Integer.toHexString(value));
    }

    public String readSDO(String nodeID, String index, String subindex) throws SDORequestException, ShortResponseToSDORequestException {
        try {
            String sdoLine = this.sendCanOpen(CanOpenProxy.buildRsdoCommand(nodeID, index, subindex));
            String[] words = sdoLine.split(",");
            int responseLength = words.length;
            String cfr_ignored_0 = words[0];
            String cfr_ignored_1 = words[1];
            String errorCode = words[2];
            if (errorCode.equals("0") && responseLength > 3) {
                return words[3];
            }
            if (errorCode.equals("0") && responseLength == 3) {
                String msg = String.valueOf(this.name) + ":readSDO request received a too short response=" + sdoLine;
                fcslog.warning((Object)msg);
                throw new ShortResponseToSDORequestException(msg);
            }
            if (errorCode.equals("-1")) {
                String msg = String.valueOf(this.name) + ":wrong readSDO command : " + sdoLine;
                fcslog.error((Object)msg);
                throw new SDORequestException(msg);
            }
            fcslog.error((Object)(String.valueOf(this.name) + ":readSDO request was going wrong, received response=" + sdoLine));
            String error = String.format("%08d", Integer.parseInt(errorCode));
            fcslog.info((Object)("ERROR=" + error));
            String errorName = CanOpenErrorsTable.commErrorCodes.getProperty(error);
            throw new SDORequestException("SDO request was going wrong", nodeID, errorCode, index, subindex, errorName);
        }
        catch (BadCommandException ex) {
            SDORequestException err = new SDORequestException("read SDO request: ", nodeID, "bad command", index, subindex, ex.getMessage());
            fcslog.error((Object)String.format("%s %s on node %s should not happen", "bad command : ", ex.getMessage(), nodeID));
            throw err;
        }
        catch (CanOpenCallTimeoutException ex) {
            SDORequestException err = new SDORequestException("read SDO request timeout expired : ", nodeID, "timeout expired", index, subindex, ex.getMessage());
            fcslog.error((Object)String.format("%s %s is %s stopped ?", "SDO request timeout expired : ", ex.getMessage(), nodeID));
            throw err;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Send a CanOpen readSDO command to the Can Bus.")
    public String readSDO(int nodeID, String index, String subindex) throws SDORequestException, BadCommandException, ShortResponseToSDORequestException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        return this.readSDO(Integer.toHexString(nodeID), index, subindex);
    }

    public PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        try {
            String replyToSync = this.sendCanOpen("sync");
            fcslog.finest((Object)(String.valueOf(this.name) + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage;
        }
        catch (PDOBadResponseException ex) {
            FcsHardwareException err = new FcsHardwareException(ex.toString());
            throw err;
        }
        catch (CanOpenCallTimeoutException ex) {
            FcsHardwareException err = new FcsHardwareException("Timeout expired when waiting for the reply to a sync command in readPDOs : " + ex.toString());
            throw err;
        }
    }

    public String displayReadPDOs() throws FcsHardwareException, BadCommandException {
        try {
            String replyToSync = this.sendCanOpen("sync");
            fcslog.finest((Object)(String.valueOf(this.name) + ": replyToSync=" + replyToSync));
            this.pdoStorage.updatePDOs(replyToSync);
            return this.pdoStorage.toString();
        }
        catch (PDOBadResponseException ex) {
            FcsHardwareException err = new FcsHardwareException(ex.toString());
            throw err;
        }
        catch (CanOpenCallTimeoutException ex) {
            FcsHardwareException err = new FcsHardwareException("Timeout expired when waiting for the reply to a sync command in readPDOs : " + ex.toString());
            throw err;
        }
    }

    @Deprecated
    public void identifieHardware_old() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + ":Identification of the hardware"));
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes.get(i) != null) {
                try {
                    fcslog.finest((Object)(String.valueOf(this.name) + ":Sending to can open command : info," + this.nodes.get(i).getNodeID()));
                    String result = this.sendCanOpen("info," + this.nodes.get(i).getNodeID());
                    fcslog.finest((Object)(String.valueOf(this.name) + ":Received on socket command = " + result));
                    String infoLine = result;
                    String[] words = infoLine.split(",");
                    String command = words[0];
                    String nodeID = words[1];
                    if (command.equals("info") && nodeID.equals(this.nodes.get(i).getNodeID())) {
                        fcslog.debug((Object)(String.valueOf(this.name) + ":updating Node Info for node " + nodeID));
                        String type = words[2];
                        String vendor = words[3];
                        String productCode = words[4];
                        String revision = words[5];
                        String serialNB = words[6];
                        this.nodes.get(i).setNodeInfo(type, vendor, productCode, revision, serialNB);
                    } else {
                        fcslog.error((Object)(String.valueOf(this.name) + ":ERROR for command = " + command + "NodeID = " + nodeID));
                    }
                }
                catch (BadCommandException badCommandException) {
                    String msg = String.valueOf(this.name) + " :Error in can open command : info," + this.nodes.get(i).getNodeID();
                    fcslog.error((Object)msg);
                    throw new HardwareException(false, msg);
                }
                catch (CanOpenCallTimeoutException ex) {
                    fcslog.error((Object)(String.valueOf(this.name) + ":Timeout expired during hardware identifie process for node=" + this.nodes.get(i).getNodeID()));
                    throw new HardwareException(false, (Throwable)ex);
                }
            }
            ++i;
        }
        fcslog.info((Object)(String.valueOf(this.name) + ":Hardware is identified"));
        this.hardwareIdentified = true;
        fcslog.info((Object)(String.valueOf(this.name) + "=>" + this.listNodes()));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Identification of the hardware : we want to retrieve the information \n     * stored in the hardware of the booted nodes and update the array of nodes\n     * with this information.")
    public void identifyHardware() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + ":Identification of the hardware"));
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes.get(i) != null && !this.nodes.get(i).isIdentified()) {
                try {
                    fcslog.debug((Object)(String.valueOf(this.name) + ":Sending to can open command : info," + this.nodes.get(i).getNodeID()));
                    String result = this.sendCanOpen("info," + this.nodes.get(i).getNodeID());
                    fcslog.debug((Object)(String.valueOf(this.name) + ":Received on socket command = " + result));
                    String infoLine = result;
                    String[] words = infoLine.split(",");
                    String command = words[0];
                    String nodeID = words[1];
                    if (command.equals("info") && nodeID.equals(this.nodes.get(i).getNodeID())) {
                        fcslog.debug((Object)(String.valueOf(this.name) + ":updating Node Info for node " + nodeID));
                        String type = words[2];
                        String vendor = words[3];
                        String productCode = words[4];
                        String revision = words[5];
                        String serialNB = words[6];
                        this.nodes.get(i).setNodeInfo(type, vendor, productCode, revision, serialNB);
                    } else {
                        fcslog.error((Object)(String.valueOf(this.name) + ":ERROR for command = " + command + "NodeID = " + nodeID));
                    }
                }
                catch (BadCommandException badCommandException) {
                    String msg = String.valueOf(this.name) + " :Error in can open command : info," + this.nodes.get(i).getNodeID();
                    fcslog.error((Object)msg);
                    throw new HardwareException(false, msg);
                }
                catch (CanOpenCallTimeoutException ex) {
                    fcslog.error((Object)(String.valueOf(this.name) + ":Timeout expired during hardware identifie process for node=" + this.nodes.get(i).getNodeID()));
                    throw new HardwareException(false, (Throwable)ex);
                }
            }
            ++i;
        }
        if (this.bootedNodesNB == this.expectedNodesNB) {
            fcslog.info((Object)(String.valueOf(this.name) + ":Hardware is identified"));
            this.hardwareIdentified = true;
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all hardware is booted and identified.")
    public boolean isHardwareReady() {
        fcslog.info((Object)(String.valueOf(this.name) + ":hardwareBootProcessEnded=" + this.hardwareBootProcessEnded));
        fcslog.info((Object)(String.valueOf(this.name) + ":hardwareIdentified=" + this.hardwareIdentified));
        fcslog.info((Object)(String.valueOf(this.name) + ":canOpenNodeNumbersOK=" + this.canOpenNodeNumbersOK));
        fcslog.info((Object)(String.valueOf(this.name) + ":hardwareIDError=" + this.hardwareIDError));
        return this.hardwareBootProcessEnded && this.hardwareIdentified && this.canOpenNodeNumbersOK && !this.hardwareIDError;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return CANopen node id on the CANbus for the devicewhich serial number is given as a parameter.")
    public CanOpenNode getDetectedNodeForSerialNumber(String aSerialNB) {
        CanOpenNode detectedNode = null;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes.get(i).getSerialNB().equals(aSerialNB)) {
                detectedNode = this.nodes.get(i);
            }
            ++i;
        }
        return detectedNode;
    }

    @Override
    void processBootMessage(String nodeID) {
        if (this.isBooted(nodeID)) {
            if (this.hardwareBootProcessEnded) {
                String msg = " An unsynchronous boot message is arrived for node ID = " + nodeID;
                fcslog.error((Object)msg);
                this.getSubsystem().raiseAlarm(String.valueOf(this.name) + msg + " Possible power failure for node : " + nodeID);
            }
        } else {
            this.nodes.add(new CanOpenNode(nodeID));
            this.bootedNodesNB = this.nodes.size();
            fcslog.info((Object)("Node " + nodeID + " added"));
            fcslog.info((Object)("Number of booted devices=" + this.bootedNodesNB));
            fcslog.info((Object)("Number of expected devices=" + this.getExpectedNodesNB()));
            if (this.hardwareBootProcessEnded) {
                String msg = String.valueOf(this.name) + ": boot message is arrived for node ID = " + nodeID;
                fcslog.warning((Object)msg);
                this.getSubsystem().raiseAlarm(String.valueOf(this.name) + msg + " Possible power failure for node : " + nodeID);
            }
        }
    }

    @Override
    void processEmcyMessage(String message) {
        String errorRegisterName;
        String[] words = message.split(",");
        String nodeID = words[1];
        String deviceErrorCode = words[2];
        String errReg = words[3];
        String deviceErrorName = CanOpenErrorsTable.deviceErrorCodes.getProperty(deviceErrorCode);
        if (deviceErrorName == null) {
            deviceErrorName = String.valueOf(deviceErrorCode) + "=device error code not found in deviceErrorCodes";
        }
        if ((errorRegisterName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errReg)) == null) {
            errorRegisterName = String.valueOf(errReg) + "=error register code not found in errorRegisterCodes";
        }
        String deviceName = this.getNodeName(nodeID);
        this.setChanged();
        EmergencyMessage emcyMsg = new EmergencyMessage(this.name, nodeID, deviceName, deviceErrorCode, deviceErrorName, errReg, errorRegisterName);
        this.notifyObservers(new Module.ValueUpdate((Module)this, this.name, (Object)emcyMsg));
        fcslog.error((Object)(String.valueOf(this.name) + ":Received EMERGENCY message for nodeID=" + nodeID));
        fcslog.error((Object)(String.valueOf(this.name) + ":EmergencyMessage=" + message));
        try {
            switch (errReg) {
                case "00": {
                    log.warning((Object)(String.valueOf(this.name) + " received EMERGENCY message with no error from nodeID=" + nodeID + ". Is it after a faultReset ?"));
                    break;
                }
                case "01": {
                    throw new CanOpenGenericException(deviceErrorName, nodeID, errReg);
                }
                case "04": {
                    throw new CanOpenVoltageException(deviceErrorName, nodeID, errReg);
                }
                case "08": {
                    throw new CanOpenTemperatureException(deviceErrorName, nodeID, errReg);
                }
                case "10": {
                    throw new CanOpenCommunicationException(deviceErrorName, nodeID, errReg);
                }
                case "20": {
                    throw new CanOpenDeviceException(deviceErrorName, nodeID, errReg);
                }
                case "80": {
                    throw new CanOpenMotionException(deviceErrorName, nodeID, errReg);
                }
                default: {
                    throw new CanOpenException(deviceErrorName, nodeID, errReg);
                }
            }
        }
        catch (CanOpenException ex) {
            String nodeIDToString = String.format("NodeID %s (%02d in decimal)", nodeID, Integer.parseInt(nodeID, 16));
            this.getSubsystem().raiseAlarm(String.valueOf(this.name) + ":" + nodeIDToString + ":" + ex.toString());
        }
    }

    @Override
    void processUnknownCommand(String message) {
        String[] words = message.split(",");
        String command = words[1];
        String errorMessage = "Unknown command:" + command;
        fcslog.error((Object)errorMessage);
    }

    public void checkCanOpenNodes() throws HardwareException {
        if (!this.isReady(this.myClientName)) {
            throw new HardwareException(true, String.valueOf(this.name) + ": not yet connected with Hardware CWrapper.");
        }
        fcslog.info((Object)(String.valueOf(this.name) + ":CHECKING HARDWARE CONFIGURATION "));
        if (this.bootedNodesNB == 0) {
            String msg = String.format(" (hardwareBootTimeout=%02d,bootedNodesNB=%02d,expectedNodesNB=%02d)", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
            fcslog.error((Object)(String.valueOf(this.name) + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg));
            throw new HardwareException(true, String.valueOf(this.name) + ":NO HARDWARE DETECTED - POWER FAILURE ?" + msg);
        }
        if (this.bootedNodesNB == this.expectedNodesNB) {
            this.canOpenNodeNumbersOK = true;
        }
        this.errorMessageSB = new StringBuilder(this.name);
        this.hardwareIDError = false;
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware hardware = pieceOfHardwareArray[n2];
            fcslog.info((Object)("ABOUT TO CHECK: " + hardware.getName() + " NODE_ID=" + hardware.getNodeID()));
            this.checkHardwareID(hardware);
            fcslog.info((Object)(String.valueOf(hardware.getName()) + " BOOTED AND SERIAL NUMBER OK=" + hardware.isBooted()));
            ++n2;
        }
        if (this.bootedNodesNB > this.expectedNodesNB) {
            String msg = String.format(" (hardwareBootTimeout=%02d,bootedNodesNB=%02d,expectedNodesNB=%02d)", this.hardwareBootTimeout, this.bootedNodesNB, this.expectedNodesNB);
            fcslog.error((Object)(String.valueOf(this.name) + ":MORE HARDWARE DETECTED THAN EXPECTED - CONFIGURATION ISSUE ?" + msg));
            this.errorMessageSB.append(msg);
            this.hardwareIDError = true;
        }
        if (this.hardwareIDError) {
            throw new HardwareException(true, this.errorMessageSB.toString());
        }
        this.publishData();
    }

    public void checkHardwareID(PieceOfHardware pieceOfHardware) throws HardwareException {
        String msg;
        if (this.bootedNodesNB == 0) {
            throw new HardwareException(true, String.valueOf(this.name) + "NO HARDWARE BOOTED - nothing to check");
        }
        fcslog.info((Object)(String.valueOf(this.name) + " Checking nodeID and serial number for " + pieceOfHardware.getName()));
        boolean serialNBFound = false;
        boolean nodeIDFound = false;
        int i = 0;
        while (i < this.bootedNodesNB) {
            if (this.nodes.get(i) != null && this.nodes.get(i).getNodeID().equalsIgnoreCase(pieceOfHardware.getNodeID())) {
                nodeIDFound = true;
                if (pieceOfHardware.getSerialNB().equalsIgnoreCase(this.nodes.get(i).getSerialNB())) {
                    pieceOfHardware.setBooted(true);
                    this.publishHardwareData(pieceOfHardware);
                    fcslog.info((Object)(String.valueOf(pieceOfHardware.getName()) + " is booted  :" + pieceOfHardware.toString()));
                } else {
                    pieceOfHardware.setBooted(false);
                    msg = String.valueOf(pieceOfHardware.getName()) + " has a wrong serial number. Serial number found=" + this.nodes.get(i).getSerialNB() + ", should be=" + pieceOfHardware.getSerialNB();
                    fcslog.error((Object)msg);
                    this.errorMessageSB.append(msg);
                    this.hardwareIDError = true;
                }
            }
            ++i;
        }
        if (!nodeIDFound) {
            pieceOfHardware.setBooted(false);
            i = 0;
            while (i < this.bootedNodesNB) {
                if (this.nodes.get(i) != null && this.nodes.get(i).getSerialNB().equalsIgnoreCase(pieceOfHardware.getSerialNB())) {
                    serialNBFound = true;
                    msg = String.format(String.valueOf(this.name) + ":ERROR in CONFIGURATION for HARDWARE %s" + "- %s serial number=%s - node ID found for this serial number=", pieceOfHardware.getName(), pieceOfHardware.getSerialNB(), this.nodes.get(i).getNodeID());
                    fcslog.error((Object)msg);
                    this.errorMessageSB.append(msg);
                    this.hardwareIDError = true;
                }
                ++i;
            }
            if (!serialNBFound) {
                msg = String.format(":HARDWARE NOT DETECTED - Possible power failure for node ID %s ? - (hardware:%s,serial number:%s)", pieceOfHardware.getNodeID(), pieceOfHardware.getName(), pieceOfHardware.getSerialNB());
                fcslog.error((Object)msg);
                this.errorMessageSB.append(msg);
                this.hardwareIDError = true;
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a String with the list of hardware.")
    public String listHardware() {
        StringBuilder sb = new StringBuilder("List of hardware:\n");
        PieceOfHardware[] pieceOfHardwareArray = this.hardwareList;
        int n = this.hardwareList.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware pieceOfHardware = pieceOfHardwareArray[n2];
            sb.append(pieceOfHardware.toString());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public String configAsHeartbeatProducer(String nodeID, String heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        return this.writeSDO(nodeID, "1017", "0", "2", heartbeat_time);
    }

    public String configAsHeartbeatProducer(int nodeID, int heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        return this.configAsHeartbeatProducer(Integer.toHexString(nodeID), Integer.toHexString(heartbeat_time));
    }

    public String configAsHeartbeatConsumer(int nodeID, int producerNodeID, int heartbeat_time) throws SDORequestException, TimeoutException, BadCommandException {
        if (nodeID < 0 || nodeID > 127) {
            throw new IllegalArgumentException("nodeID must be > 0 and < 128");
        }
        if (producerNodeID < 0 || producerNodeID > 127) {
            throw new IllegalArgumentException("producerNodeID must be > 0 and < 128");
        }
        if (heartbeat_time < 0 || heartbeat_time > 65025) {
            throw new IllegalArgumentException("heartbeat_time is coded on 2 bytes can't be > 65535");
        }
        String value = String.valueOf(String.format("%04x", producerNodeID)) + String.format("%04x", heartbeat_time);
        return this.writeSDO(Integer.toHexString(nodeID), "1016", "1", "4", value);
    }

    public void publishData() {
        PieceOfHardware[] pieceOfHardwareArray = this.getHardwareList();
        int n = pieceOfHardwareArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware device = pieceOfHardwareArray[n2];
            this.publishHardwareData(device);
            ++n2;
        }
    }

    public void publishHardwareData(PieceOfHardware device) {
        StatusDataPublishedByHardware status = FcsUtils.createStatusDataPublishedByHardware(device);
        log.debug((Object)(String.valueOf(this.name) + ":publishHardwareData is publishing:" + status.toString()));
        this.getSubsystem().publishStatus("tcpProxy", (Object)status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/myClientName=");
        sb.append(this.myClientName);
        return sb.toString();
    }

    public static class PDOStorage
    implements Serializable {
        String sep = "_";
        String varSuffixe = "ADC";
        private final HashMap<String, String> mapSensorsValues = new HashMap();

        void updatePDOs(String pdoLine) throws PDOBadResponseException {
            fcslog.finest((Object)(": pdoLine=" + pdoLine));
            String[] words = pdoLine.split(",");
            fcslog.finest((Object)(": words.length=" + words.length));
            int ix = 1;
            while (ix < words.length) {
                String[] toStore = words[ix].split("=");
                String varName = toStore[0];
                String varValue = toStore[1];
                String[] mots = varName.split(this.sep);
                String nodeID = mots[0].substring(3);
                fcslog.finest((Object)String.format("%nwords(%s):%s nodeID=%s", ix, words[ix], nodeID));
                if (mots.length <= 1) {
                    fcslog.error((Object)("Received a bad response from PDO request: " + pdoLine));
                    throw new PDOBadResponseException("Received a bad response from PDO request.", pdoLine);
                }
                String cfr_ignored_0 = String.valueOf(nodeID) + this.sep + mots[1];
                this.mapSensorsValues.put(varName, varValue);
                ++ix;
            }
        }

        public String getVarValue(String nodeID, String inputNB) {
            String token = String.valueOf(this.varSuffixe) + nodeID + this.sep + inputNB;
            return this.mapSensorsValues.get(token);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PDO STORAGE:");
            sb.append("(SIZE=").append(this.mapSensorsValues.size()).append(")");
            sb.append(this.mapSensorsValues.toString());
            return sb.toString();
        }
    }
}

