/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenPlutoGateway
extends PlutoGatewayModule
implements PieceOfHardware {
    CanOpenProxy tcpProxy;
    CanOpenDevice deviceDelegate;
    String station_addr;

    public CanOpenPlutoGateway(String string, int i, String nodeID, String serialNB, String station_addr) {
        super(string, i);
        this.station_addr = station_addr;
        this.deviceDelegate = new CanOpenDevice(this.name, this.tickMillis, nodeID, serialNB);
    }

    public String getStation_addr() {
        return this.station_addr;
    }

    @Override
    public String getSerialNB() {
        return this.deviceDelegate.getSerialNB();
    }

    @Override
    public String getNodeID() {
        return this.deviceDelegate.getNodeID();
    }

    @Override
    public boolean isBooted() {
        return this.deviceDelegate.isBooted();
    }

    @Override
    public void setBooted(boolean aBoolean) {
        this.deviceDelegate.setBooted(aBoolean);
    }

    @Override
    public boolean isInitialized() {
        return this.deviceDelegate.isInitialized();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize the Gateway.")
    public String initializeAndCheckHardware() throws FcsHardwareException {
        if (!this.isBooted()) {
            throw new FcsHardwareException(String.valueOf(this.name) + " is not booted - can't be initialized.");
        }
        try {
            log.info((Object)(String.valueOf(this.name) + " BEGIN initializeHardware"));
            this.configurePlutoForThreeBlocs();
            this.deviceDelegate.initialized = true;
            log.info((Object)(String.valueOf(this.name) + " is INITIALIZED."));
            this.tcpProxy.publishHardwareData(this);
            return String.valueOf(this.name) + " is INITIALIZED.";
        }
        catch (ErrorInCommandExecutionException | SDORequestException ex) {
            throw new FcsHardwareException(String.valueOf(this.name) + ex.getMessage());
        }
    }

    @Override
    public void initModule() {
        super.initModule();
        Map.Entry entry = this.getParent();
        BridgeToHardware bridge = (BridgeToHardware)entry.getValue();
        this.tcpProxy = bridge.getTcpProxy();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure this gateway to receive 3 data blocs from Pluto.")
    public String configurePlutoForThreeBlocs() throws SDORequestException, ErrorInCommandExecutionException {
        this.tcpProxy.writeSDO(this.getNodeID(), "2010", "01", "01", "01");
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "01", "02", String.valueOf(this.station_addr) + "01");
        this.tcpProxy.writeSDO(this.getNodeID(), "2011", "02", "02", String.valueOf(this.station_addr) + "02");
        this.tcpProxy.writeSDO(this.getNodeID(), "2012", "01", "02", String.valueOf(this.station_addr) + "03");
        this.tcpProxy.writeSDO(this.getNodeID(), "2002", "01", "01", "07");
        return String.valueOf(this.name) + " is configured.";
    }

    public String writeTransmissionType(String transmissionType) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        String goodAck;
        if (transmissionType == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": Can't write transmission type to device because transmaission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.getNodeID(), "2005", "1", "1", transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1801");
        }
        return String.format("Transmission type of device %s is now %s", this.name, transmissionType);
    }

    @Override
    public String[] readNewHexaValues() throws FcsHardwareException {
        if (!this.isBooted()) {
            throw new FcsHardwareException(String.valueOf(this.name) + " is not booted - can't read new values.");
        }
        try {
            this.hexaValues[0] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "03");
            fcslog.finest((Object)String.format("%s : first byte read in hexaValue= %s", this.name, this.hexaValues[0]));
            this.hexaValues[1] = this.tcpProxy.readSDO(this.getNodeID(), "6000", "04");
            fcslog.finest((Object)String.format("%s : second byte read in hexaValue= %s", this.name, this.hexaValues[1]));
            this.hexaValues[2] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "03");
            fcslog.finest((Object)String.format("%s : third byte read in hexaValue= %s", this.name, this.hexaValues[2]));
            this.hexaValues[3] = this.tcpProxy.readSDO(this.getNodeID(), "6001", "04");
            fcslog.finest((Object)String.format("%s : 4th byte read in hexaValue= %s", this.name, this.hexaValues[3]));
            this.hexaValues[4] = this.tcpProxy.readSDO(this.getNodeID(), "6002", "03");
            fcslog.finest((Object)String.format("%s : 5th byte read in hexaValue= %s", this.name, this.hexaValues[4]));
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + "=> ERROR IN READING SENSOR:" + ex.getMessage()));
        }
        catch (SDORequestException ex) {
            String message = String.valueOf(this.name) + "=> ERROR IN READING SENSOR:";
            fcslog.error((Object)(String.valueOf(message) + ex.toString()));
        }
        return this.hexaValues;
    }

    @Override
    public int readNewAnalogValue() throws FcsHardwareException {
        String hexaL = this.tcpProxy.readSDO(this.getNodeID(), "6001", "01");
        fcslog.finest((Object)(String.valueOf(this.name) + ": new analog value in hexa=" + hexaL));
        String hexaM = this.tcpProxy.readSDO(this.getNodeID(), "6001", "02");
        String valueInHexa = String.valueOf(hexaM) + hexaL;
        fcslog.finest((Object)(String.valueOf(this.name) + ": new analog value in hexa=" + valueInHexa));
        int newAnalogValue = Integer.parseInt(valueInHexa, 16);
        fcslog.finest((Object)(String.valueOf(this.name) + ": new analog value =" + newAnalogValue));
        return newAnalogValue;
    }

    @Override
    public String toString() {
        return this.deviceDelegate.toString();
    }
}

