/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenErrorsTable {
    protected static final Logger fcslog = FcsUtils.log;
    static Properties deviceErrorCodes = new Properties();
    static final String DEVICE_ERROR_CODES_FILENAME = "/maxonMotorDeviceErrors.properties";
    static InputStream deviceErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/maxonMotorDeviceErrors.properties");
    static Properties errorRegisterCodes = new Properties();
    static final String ERROR_REGISTER_CODES_FILENAME = "/errorRegister.properties";
    static InputStream errorRegisterFile = CanOpenErrorsTable.class.getResourceAsStream("/errorRegister.properties");
    static Properties commErrorCodes = new Properties();
    static final String COMM_ERROR_CODES_FILENAME = "/commErrors.properties";
    static InputStream commErrorFile = CanOpenErrorsTable.class.getResourceAsStream("/commErrors.properties");

    public static void loadDeviceErrorTable() throws DeploymentException {
        try {
            fcslog.debug((Object)("DEVICE ERROR TABLE= " + deviceErrorFile.toString()));
            deviceErrorCodes.load(deviceErrorFile);
            int size = deviceErrorCodes.size();
            fcslog.debug((Object)("Size of the maxon device error codes table = " + size));
        }
        catch (IOException ex) {
            throw new DeploymentException("Error in reading file: /maxonMotorDeviceErrors.properties" + ex.getMessage());
        }
    }

    public static String getDeviceErrorNameByCode(String aCode) {
        fcslog.debug((Object)deviceErrorCodes.getProperty(aCode.toUpperCase()));
        return deviceErrorCodes.getProperty(aCode.toUpperCase());
    }

    public static void loadErrorRegisterTable() throws DeploymentException {
        try {
            fcslog.debug((Object)("ERROR REGISTER TABLE=" + errorRegisterFile.toString()));
            errorRegisterCodes.load(errorRegisterFile);
            int size = errorRegisterCodes.size();
            fcslog.debug((Object)("Size of the error register codes table = " + size));
        }
        catch (IOException ex) {
            fcslog.error((Object)("Error in reading file: /errorRegister.properties" + ex.getMessage()));
            throw new DeploymentException("Error in reading file: /errorRegister.properties" + ex.getMessage());
        }
    }

    public static void loadCommunicationErrorTable() throws DeploymentException {
        try {
            fcslog.debug((Object)("COMMUNICATION ERROR TABLE=" + commErrorFile.toString()));
            commErrorCodes.load(commErrorFile);
            int size = commErrorCodes.size();
            fcslog.debug((Object)("Size of the error register codes table = " + size));
        }
        catch (IOException ex) {
            fcslog.error((Object)("Error in reading file: /commErrors.properties" + ex.getMessage()));
            throw new DeploymentException("Error in reading file: /commErrors.properties" + ex.getMessage());
        }
    }

    public static void main(String[] args) throws DeploymentException {
        CanOpenErrorsTable.loadDeviceErrorTable();
        CanOpenErrorsTable.loadErrorRegisterTable();
        CanOpenErrorsTable.loadCommunicationErrorTable();
        String errReg = "10";
        String errorName = errorRegisterCodes.getProperty(errReg);
        System.out.println(errorName);
    }
}

