/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenDevice
extends Module
implements PieceOfHardware {
    protected static final Logger fcslog = FcsUtils.log;
    CanOpenProxy tcpProxy;
    BridgeToHardware bridge;
    String serialNB;
    String nodeID;
    boolean booted;
    boolean initialized;

    public CanOpenDevice(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis);
        this.nodeID = nodeID;
        this.serialNB = serialNB;
        this.booted = false;
        this.initialized = false;
    }

    @Override
    public void setBooted(boolean booted) {
        this.booted = booted;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's serial number.")
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this CANopen device's node ID.")
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this CANopen node is booted.")
    public boolean isBooted() {
        return this.booted;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void initModule() {
        Map.Entry entry = this.getParent();
        this.bridge = (BridgeToHardware)entry.getValue();
        this.tcpProxy = this.bridge.getTcpProxy();
        this.initialized = false;
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        this.initialized = true;
        return String.valueOf(this.getName()) + ": no hardware initialization for this device to be done.";
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Write on the Can Open Device with a command wsdo.")
    public String writeSDO(String index, String subindex, String length, String newValue) throws SDORequestException {
        return this.tcpProxy.writeSDO(this.nodeID, index, subindex, length, newValue);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads the Can Open Device with a command rsdo.")
    public String readSDO(String index, String subindex) throws SDORequestException, ShortResponseToSDORequestException {
        return this.tcpProxy.readSDO(this.nodeID, index, subindex);
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Reads Error Register on the controller - in hexa (index 1001).")
    public String readErrorRegister() throws SDORequestException, ShortResponseToSDORequestException {
        String error = this.readSDO("1001", "0");
        return String.format("%02x", Integer.parseInt(error));
    }

    @Command(type=Command.CommandType.QUERY, level=3, description="Display Error Register on the controller (index 1001).")
    public String displayErrorRegister() throws SDORequestException, ShortResponseToSDORequestException {
        String errorInHexa = this.readErrorRegister();
        String errorName = CanOpenErrorsTable.errorRegisterCodes.getProperty(errorInHexa);
        fcslog.debug((Object)("error register=" + errorInHexa + " error name=" + errorName));
        return errorName;
    }

    public String[] readErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        int numberOfErrors = this.readNumberOfErrors();
        String[] errors = new String[numberOfErrors];
        int i = 0;
        while (i < numberOfErrors) {
            String subindex = Integer.toHexString(i + 1);
            errors[i] = this.readSDO("1003", subindex);
            ++i;
        }
        return errors;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display Error Register on the controller (index 1001).")
    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        String[] errorHistory = this.readErrorHistory();
        StringBuilder sb = new StringBuilder("Error history contains " + errorHistory.length + " errors.");
        if (errorHistory.length != 0) {
            sb.append("\nList of errors in history,the newest is the first, the oldest the last :\n");
            int ix = 0;
            while (ix < errorHistory.length) {
                sb.append("Error code (in hexa)=");
                sb.append(errorHistory[ix]);
                sb.append("/ error name= ");
                sb.append(CanOpenErrorsTable.deviceErrorCodes.getProperty(errorHistory[ix].toUpperCase()));
                sb.append("\n");
                ++ix;
            }
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read and returns the number of errors registred in the Error History.")
    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException {
        String errorNBinHEXA = this.readSDO("1003", "0");
        return Integer.parseInt(errorNBinHEXA, 16);
    }

    public String[] getErrorHistoryNames() throws SDORequestException, ShortResponseToSDORequestException {
        String[] errorHistoryList = this.readErrorHistory();
        String[] errorHistoryNames = new String[errorHistoryList.length];
        if (errorHistoryList.length != 0) {
            int i = 0;
            while (i < errorHistoryList.length) {
                String errorCode = errorHistoryList[i];
                fcslog.debug((Object)("errorCode=" + errorCode));
                String errorName = CanOpenErrorsTable.deviceErrorCodes.getProperty(errorCode.toUpperCase());
                fcslog.debug((Object)("errorName=" + errorName));
                errorHistoryNames[i] = String.valueOf(errorCode) + "=" + errorName;
                ++i;
            }
        }
        return errorHistoryNames;
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="This method saves the parameters in the controller memory.")
    public Object saveParameters() throws SDORequestException {
        return this.writeSDO("1010", "1", "4", "65766173");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print CANopen device.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/SerialNumber=");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID, 16);
        sb.append("/NodeID_in_decimal=");
        sb.append(x);
        sb.append("/");
        if (this.tcpProxy == null) {
            return sb.toString();
        }
        if (this.isBooted()) {
            sb.append("BOOTED/");
        } else {
            sb.append("NOT YET BOOTED/");
        }
        return sb.toString();
    }
}

