/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenADC
extends CanOpenDevice {
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    String transmissionType;

    public CanOpenADC(String aName, int aTickMillis, String nodeID, String serialNB, String transmissionType) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.transmissionType = transmissionType;
    }

    public String getTransmissionType() {
        return this.transmissionType;
    }

    public void setTransmissionType(String transmission_type) {
        this.transmissionType = transmission_type;
    }

    public String readAnalogInput(int inputNB) throws SDORequestException, HardwareNotDetectedException, ShortResponseToSDORequestException {
        if (!this.bridge.isCWrapperConnected()) {
            throw new HardwareNotDetectedException(String.valueOf(this.name) + ": hardware not connected.");
        }
        if (this.isBooted()) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            String input = Integer.toHexString(inputNB);
            return this.tcpProxy.readSDO(this.nodeID, "6401", input);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        fcslog.error((Object)message);
        throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(), this.nodeID, this.serialNB);
    }

    public double readVoltage(int inputNB) throws SDORequestException, HardwareNotDetectedException, ShortResponseToSDORequestException {
        String hexa = this.readAnalogInput(inputNB);
        int valueInt = Integer.parseInt(hexa, 16);
        return (double)valueInt * 0.3125;
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        try {
            this.writeTransmissionTypeToDevice();
        }
        catch (BadCommandException | ErrorInCommandExecutionException | SDORequestException ex) {
            throw new FcsHardwareException(String.valueOf(this.name) + ex.getMessage());
        }
        this.initialized = true;
        return String.valueOf(this.getName()) + "is initialized with transmission type =" + this.transmissionType;
    }

    private String writeTransmissionTypeToDevice() throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        String goodAck;
        if (this.transmissionType == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": Can't write transmission type to device because transmaission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.nodeID, "1801", "2", "1", this.transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1801");
        }
        String ack2 = this.tcpProxy.writeSDO(this.nodeID, "1802", "2", "1", this.transmissionType);
        if (!ack2.equals(goodAck)) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1802");
        }
        return String.format("Transmission type of device %s is now %s", this.name, this.transmissionType);
    }
}

