/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected static final Logger fcslog = FcsUtils.log;
    protected CanOpenProxy tcpProxy;
    protected boolean configurationChecked = false;
    protected boolean hardwareInitialized = false;
    protected Map<String, PieceOfHardware> hardwareMap;

    public BridgeToCanOpenHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy) {
        super(aName, aTickMillis);
        this.tcpProxy = tcpProxy;
    }

    public PieceOfHardware[] listHardware() {
        LinkedHashMap children = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] list = new PieceOfHardware[children.size()];
        int i = 0;
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key));
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            fcslog.debug((Object)("hardware=" + device.getName() + "#" + device.toString()));
            list[i] = device;
            ++i;
        }
        return list;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren() {
        LinkedHashMap children = this.getChildren(PieceOfHardware.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key));
            PieceOfHardware device = (PieceOfHardware)entry.getValue();
            fcslog.debug((Object)("hardware=" + device.getName() + "#" + device.toString()));
        }
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    @Override
    public boolean isRealHardware() {
        return true;
    }

    public void initModule() {
        fcslog.info((Object)(String.valueOf(this.name) + ": init MODULE BRIDGE TO HARDWARE."));
        this.hardwareMap = this.getChildren(PieceOfHardware.class);
        PieceOfHardware[] hardwareList = this.listHardware();
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        fcslog.info((Object)(String.valueOf(this.name) + ":NUMBER OF CAN OPEN DEVICES EXPECTED =" + numberOfNodes));
        fcslog.info((Object)this.toString());
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            fcslog.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"));
            this.getSubsystem().raiseAlarm("Could not load CanOpen Error Tables" + ex.toString());
        }
    }

    public Object sendCanOpen(String command) throws InterruptedException, CanOpenCallTimeoutException, BadCommandException {
        return this.tcpProxy.sendCanOpen(command);
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        fcslog.debug((Object)(String.valueOf(this.name) + "/readPDOS"));
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(": tickmillis=");
        sb.append(String.valueOf(this.tickMillis));
        sb.append(", tcpProxy=");
        sb.append(String.valueOf(this.tcpProxy.toString()));
        return sb.toString();
    }
}

