/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public interface EPOSController
extends Actuator,
PieceOfHardware {
    public void setOn(boolean var1);

    public int getMaxCurrent();

    public int getMinCurrent();

    public int getMaxSpeed();

    public int getMaxPosition();

    public int getMinPosition();

    public String changeMode(EPOSEnumerations.EposMode var1) throws SDORequestException;

    public boolean checkMotorParameters() throws EPOSConfigurationException, SDORequestException, ShortResponseToSDORequestException;

    @Command(type=Command.CommandType.ACTION, level=1, description="Defines the actual position as the absolute position which value is given as an argument.")
    public void defineAbsolutePosition(int var1) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException;

    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException;

    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException;

    public void checkFault() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void writeParameters(EPOSEnumerations.EposMode var1) throws SDORequestException, ErrorInCommandExecutionException;

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1) throws BadCommandException, SDORequestException;

    public void writeParameters(Map<String, Integer> var1) throws SDORequestException;

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws BadCommandException, EPOSConfigurationException, SDORequestException;

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the target position has been reached.")
    public boolean isTargetPositionReached(int var1) throws SDORequestException, ShortResponseToSDORequestException;

    public int readPosition() throws SDORequestException, ShortResponseToSDORequestException;

    public int readSSIPosition() throws SDORequestException, ShortResponseToSDORequestException;

    public int readCurrent() throws BadCommandException, SDORequestException, ShortResponseToSDORequestException;

    public String readParameters(EPOSEnumerations.EposMode var1) throws SDORequestException, ShortResponseToSDORequestException;

    public int readProfileVelocity() throws SDORequestException, ShortResponseToSDORequestException;

    public String enable() throws SDORequestException;

    public boolean isEnabled() throws SDORequestException;

    public EPOSEnumerations.EposMode readMode() throws SDORequestException, ShortResponseToSDORequestException;

    public void quickStop() throws SDORequestException;

    public void checkParameters(String var1) throws HardwareException, FcsHardwareException, SDORequestException, ShortResponseToSDORequestException;

    public void checkParameters(EPOSEnumerations.EposMode var1) throws HardwareException, FcsHardwareException, SDORequestException, ShortResponseToSDORequestException;

    public void writeControlWord(String var1) throws SDORequestException;

    public String shutdown() throws SDORequestException;

    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException;

    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException;

    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException;

    public void switchOnEnableOperation() throws SDORequestException;

    public Map<String, Integer> getParamsForCurrent();

    public Map<String, Integer> getParamsForHoming();

    public Map<String, Integer> getParamsForProfilePosition();

    public boolean isEnabledToPublish();

    public boolean isInError();

    public String getErrorRegister();

    public String[] getErrorHistory();

    public String getModeInString();

    public String writeParameterInHexa(EPOSEnumerations.Parameter var1, String var2) throws SDORequestException;

    public void disable() throws SDORequestException, ShortResponseToSDORequestException;
}

