/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderModule
extends Module
implements HardwareController {
    private static final Logger fcslog = FcsUtils.log;
    private final LoaderCarrierModule carrier;
    private final LoaderClampModule clamp;
    private BridgeToHardware bridgeToLoader;
    private final NumericSensor filterPresenceSensor0;
    private final NumericSensor filterPresenceSensor1;
    private final NumericSensor loaderOnCameraSensor0;
    private final NumericSensor loaderOnCameraSensor1;
    private NumericSensor autochangerHoldingFilterSensor;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    private boolean autochangerHoldingFilter;
    private boolean connectedOnCamera;
    private boolean empty;
    private boolean filterPresenceSensorsInError;
    private boolean loaderOnCameraSensorsInError;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public LoaderModule(String moduleName, int aTickMillis, LoaderCarrierModule carrier, LoaderClampModule clamp, String plutoGatewayName, NumericSensor filterPresenceSensor0, NumericSensor filterPresenceSensor1, NumericSensor loaderOnCameraSensor0, NumericSensor loaderOnCameraSensor1) {
        super(moduleName, aTickMillis);
        this.carrier = carrier;
        this.clamp = clamp;
        this.plutoGatewayName = plutoGatewayName;
        this.empty = false;
        this.connectedOnCamera = false;
        this.autochangerHoldingFilter = false;
        this.filterPresenceSensorsInError = false;
        this.loaderOnCameraSensorsInError = false;
        this.filterPresenceSensor0 = filterPresenceSensor0;
        this.filterPresenceSensor1 = filterPresenceSensor1;
        this.loaderOnCameraSensor0 = loaderOnCameraSensor0;
        this.loaderOnCameraSensor1 = loaderOnCameraSensor1;
    }

    Boolean isHaltRequired() {
        return ((MainModule)this.getModule("main")).getHaltRequired().get();
    }

    Boolean isStopRequired() {
        return ((MainModule)this.getModule("main")).getStopRequired().get();
    }

    public NumericSensor getFilterPresenceSensor0() {
        return this.filterPresenceSensor0;
    }

    public NumericSensor getFilterPresenceSensor1() {
        return this.filterPresenceSensor1;
    }

    public NumericSensor getLoaderOnCameraSensor0() {
        return this.loaderOnCameraSensor0;
    }

    public NumericSensor getLoaderOnCameraSensor1() {
        return this.loaderOnCameraSensor1;
    }

    public NumericSensor getAutochangerHoldingFilterSensor() {
        return this.autochangerHoldingFilterSensor;
    }

    public boolean isFilterPresenceSensorsInError() {
        return this.filterPresenceSensorsInError;
    }

    public boolean isLoaderOnCameraSensorsInError() {
        return this.loaderOnCameraSensorsInError;
    }

    public boolean isEmptyToPublish() {
        return this.empty;
    }

    public boolean isOnCameraToPublish() {
        return this.connectedOnCamera;
    }

    public boolean isAutochangerHoldingFilterToPublish() {
        return this.autochangerHoldingFilter;
    }

    public EPOSController getHooksController() {
        return (EPOSController)this.getModule("hooksController");
    }

    public EPOSController getCarrierController() {
        return (EPOSController)this.getModule("carrierController");
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
        this.autochangerHoldingFilterSensor = (NumericSensor)this.getModule("autochangerHoldingFilterSensor");
        this.bridgeToLoader = (BridgeToHardware)this.getModule("bridge");
    }

    public boolean isHardwareReady() {
        return this.bridgeToLoader.isHardwareReady() && this.isInitialized();
    }

    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && ((EPOSController)this.getModule("hooksController")).isInitialized() && ((EPOSController)this.getModule("carrierController")).isInitialized();
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a filter is there and it is held by the clamp.")
    public boolean isHoldingAFilter() throws SDORequestException, BadCommandException, FcsHardwareException {
        this.updateStateWithSensors();
        this.clamp.updatePosition();
        return !this.isEmpty() && this.clamp.isAtClampedPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the clamp or the carrier are in action.")
    public boolean isMoving() {
        return this.clamp.isMoving() || this.carrier.isMoving();
    }

    public LoaderClampModule getClamp() {
        return this.clamp;
    }

    public LoaderCarrierModule getCarrier() {
        return this.carrier;
    }

    public boolean isCarrierAtStoragePosition() {
        return this.carrier.isAtStoragePosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Initialize loader hardware.")
    public void initializeHardware() throws HardwareException {
        this.checkHardware();
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.clamp.checkHardware();
        this.carrier.checkHardware();
        try {
            this.clamp.initializeHardware();
        }
        catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
            throw new HardwareException(true, ex);
        }
        if (this.carrier.isEmpty() && this.clamp.isLocked()) {
            String msg = String.valueOf(this.name) + ": carrier is empty and clamp is LOCKED - can't start.";
            log.error((Object)msg);
            throw new HardwareException(true, msg);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void checkStarted() throws HardwareException {
        fcslog.info((Object)(String.valueOf(this.name) + " BEGIN checkStarted"));
        this.bridgeToLoader.getTcpProxy().checkNewHardware();
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.clamp.checkHardware();
        this.carrier.checkHardware();
        try {
            this.clamp.initializeHardware();
        }
        catch (BadCommandException ex) {
            log.warning((Object)ex);
        }
        catch (ErrorInCommandExecutionException | FcsHardwareException ex) {
            throw new HardwareException(true, ex);
        }
        if (this.carrier.isEmpty() && this.clamp.isLocked()) {
            String msg = String.valueOf(this.name) + ": carrier is empty and clamp is LOCKED - can't start.";
            log.error((Object)msg);
            throw new HardwareException(true, msg);
        }
    }

    public void checkStopped() throws HardwareException {
    }

    public void tick() {
        this.publishData();
        this.carrier.publishData();
        this.clamp.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the carrier can move.")
    public boolean checkPreConditionsForCarrierMotion() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for carrier motion"));
        this.updateStateWithSensors();
        if (!this.clamp.isInitialized()) {
            String msg = String.valueOf(this.name) + ": clamp is not intialized. PLease initialize hardware first.";
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.clamp.isInError()) {
            throw new BadCommandException(String.valueOf(this.name) + " carrier can't move because clamp is in ERROR.");
        }
        if (this.carrier.isEmpty()) {
            return true;
        }
        if (!this.isConnectedOnCamera()) {
            return true;
        }
        if (this.isHoldingAFilter() && this.isAutochangerHoldingFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + " carrier can't move because a filter is in the loader" + " and it's held by loader AND autochanger.");
        }
        if (!this.isHoldingAFilter() && !this.isAutochangerHoldingFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + " carrier can't move because the filter in the loader is not held" + " neither by loader neither by autochanger. " + "Close loader clamp or autochanger latches");
        }
        return true;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be open.")
    public boolean checkPreConditionsForOpeningHooks() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for opening hooks"));
        this.updateStateWithSensors();
        if (!this.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + ": Loader not connected - can't open clamp.");
        }
        if (!this.clamp.isInitialized()) {
            String msg = String.valueOf(this.name) + ": clamp is not intialized. PLease initialize hardware first.";
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.clamp.isInError()) {
            String msg = String.valueOf(this.name) + ": clamp is in ERROR state - can't open clamp.";
            log.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (this.carrier.isEmpty()) {
            return true;
        }
        if (!this.carrier.isAtHandoffPosition()) {
            String msg = String.valueOf(this.name) + ": carrier is loaded with a filter but is not " + "at handoff position - can't open clamp.";
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (!this.isAutochangerHoldingFilter()) {
            String msg = String.valueOf(this.name) + ": A filter is in the loader but autochanger and " + "not holding it - can't open clamp.";
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        return true;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be closed.")
    public boolean checkPreConditionsForClosingHooks() throws SDORequestException, BadCommandException, FcsHardwareException, ErrorInCommandExecutionException {
        fcslog.info((Object)(String.valueOf(this.name) + " checking pre-conditions for closing hooks"));
        this.updateStateWithSensors();
        this.clamp.updatePosition();
        if (!this.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + ": Loader not connected - can't execute close command.");
        }
        if (!this.clamp.isInitialized()) {
            String msg = String.valueOf(this.name) + ": clamp is not intialized. PLease initialize hardware first.";
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.clamp.isInError()) {
            String msg = String.valueOf(this.name) + ": clamp is in ERROR state - can't execute command open.";
            log.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
        if (this.carrier.isEmpty()) {
            String msg = String.valueOf(this.name) + ": no filter in carrier - can't execute close command for Module " + this.clamp.getName();
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        if (this.clamp.isAtClampedPosition()) {
            String msg = String.valueOf(this.name) + ": a filter is already clamped - can't execute close or clamp command for Module " + this.clamp.getName();
            log.error((Object)msg);
            throw new BadCommandException(msg);
        }
        return true;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close hooks.")
    public String closeHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.clamp.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp hooks.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.clamp.clamp();
    }

    @Command(level=1, type=Command.CommandType.ACTION, description="Open the hooks")
    public String openHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.clamp.open();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the loader carrier to HANDOFF position")
    public String goToHandoff() throws BadCommandException, FcsHardwareException, SDORequestException, ErrorInCommandExecutionException {
        return this.carrier.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move the loader carrier to STORAGE position")
    public String goToStorage() throws BadCommandException, FcsHardwareException, SDORequestException, ErrorInCommandExecutionException {
        return this.carrier.goToStorage();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        if (!this.plutoGateway.isBooted()) {
            throw new FcsHardwareException(String.valueOf(this.name) + ": plutoGateway not booted - can't read sensors");
        }
        if (!this.plutoGateway.isInitialized()) {
            throw new FcsHardwareException(String.valueOf(this.name) + ": plutoGateway not initialized - can't read sensors");
        }
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            fcslog.finest((Object)("readHexaValues[0]=" + readHexaValues[0]));
            fcslog.finest((Object)("readHexaValues[1]=" + readHexaValues[1]));
            this.filterPresenceSensor0.updateValue(readHexaValues);
            this.filterPresenceSensor1.updateValue(readHexaValues);
            this.loaderOnCameraSensor0.updateValue(readHexaValues);
            this.loaderOnCameraSensor1.updateValue(readHexaValues);
            this.autochangerHoldingFilterSensor.updateValue(readHexaValues);
            this.clamp.updateStateWithSensors(readHexaValues);
            this.carrier.updateStateWithSensors(readHexaValues);
            this.empty = this.filterPresenceSensor0.digitalValue == 0 && this.filterPresenceSensor1.digitalValue == 0;
            this.connectedOnCamera = this.loaderOnCameraSensor0.getDigitalValue() == 1 && this.loaderOnCameraSensor1.getDigitalValue() == 1;
            this.autochangerHoldingFilter = this.autochangerHoldingFilterSensor.getDigitalValue() == 1;
            this.filterPresenceSensorsInError = this.filterPresenceSensor0.getDigitalValue() != this.filterPresenceSensor1.getDigitalValue();
            this.loaderOnCameraSensorsInError = this.loaderOnCameraSensor0.getDigitalValue() != this.loaderOnCameraSensor1.getDigitalValue();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
            this.clamp.publishData();
            this.carrier.publishData();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Load a filter from the loader into the camera.")
    public String loadFilterInCamera() throws BadCommandException, FcsHardwareException, ErrorInCommandExecutionException, InterruptedException {
        if (!this.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + ":loader has to be connected to camera first.");
        }
        if (!this.isHoldingAFilter()) {
            throw new BadCommandException(String.valueOf(this.name) + ":loader is not holding a filter : can't load a filter into camera.");
        }
        if (!this.isCarrierAtStoragePosition()) {
            throw new BadCommandException(String.valueOf(this.name) + ":carrier loader is not at storage position : can't load a filter into camera.");
        }
        this.carrier.goToHandOff();
        if (!this.isHaltRequired().booleanValue() && !this.isStopRequired().booleanValue()) ** GOTO lbl16
        msg = String.valueOf(this.name) + ": received HALT or STOP command.";
        return msg;
lbl-1000:
        // 1 sources

        {
            LoaderModule.fcslog.debug((Object)(String.valueOf(this.name) + " waiting until autochanger holds the filter..."));
            Thread.sleep(300L);
            this.updateStateWithSensors();
lbl16:
            // 2 sources

            ** while (!this.isAutochangerHoldingFilter())
        }
lbl17:
        // 1 sources

        if (this.isAutochangerHoldingFilter()) {
            this.openHooks();
        }
        if (this.isHaltRequired().booleanValue() || this.isStopRequired().booleanValue()) {
            msg = String.valueOf(this.name) + ": received HALT or STOP command.";
            return msg;
        }
        return this.goToStorage();
    }

    /*
     * Unable to fully structure code
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Unload a filter from the camera into the loader.")
    public String unloadFilterFromCamera() throws BadCommandException, FcsHardwareException, InterruptedException, SDORequestException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (!this.isConnectedOnCamera()) {
            throw new BadCommandException(String.valueOf(this.name) + ":loader has to be connected to " + "camera first.");
        }
        if (!this.isHoldingAFilter()) ** GOTO lbl10
        throw new BadCommandException(String.valueOf(this.name) + ":loader is holding a filter : " + "can't unload a filter from camera.");
lbl-1000:
        // 1 sources

        {
            LoaderModule.fcslog.debug((Object)(String.valueOf(this.name) + " waiting until autochanger holds the filter..."));
            Thread.sleep(300L);
            this.updateStateWithSensors();
lbl10:
            // 2 sources

            ** while (!this.isAutochangerHoldingFilter())
        }
lbl11:
        // 1 sources

        this.goToHandoff();
        if (this.isHaltRequired().booleanValue() || this.isStopRequired().booleanValue()) {
            msg = String.valueOf(this.name) + ": received HALT or STOP command.";
            return msg;
        }
        this.updateStateWithSensors();
        if (this.isEmpty()) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.name) + ": loader presence filter sensor doesn't detect a filter" + " - can't go on.");
        }
        this.closeHooks();
        while (this.isAutochangerHoldingFilter()) {
            LoaderModule.fcslog.debug((Object)(String.valueOf(this.name) + " waiting until autochanger releases the filter..."));
            Thread.sleep(300L);
            this.updateStateWithSensors();
        }
        this.clampHooks();
        if (this.isHaltRequired().booleanValue() || this.isStopRequired().booleanValue()) {
            msg = String.valueOf(this.name) + ": received HALT or STOP command.";
            return msg;
        }
        return this.goToStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display info on the hooks.")
    public String listHooks() {
        return this.clamp.listHooks();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display hooks sensors values.")
    public String listSensorsValues() {
        return this.clamp.listSensorsValues();
    }

    public StatusDataPublishedByLoader getStatusData() {
        StatusDataPublishedByLoader status = FcsUtils.createStatusDataPublishedByLoader(this);
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoader status = this.getStatusData();
        this.getSubsystem().publishStatus("loaderGeneral", (Object)status);
    }

    public void test() {
        CurrentCommandContext currentCmdContext = (CurrentCommandContext)Subsystem.LOCAL_EXECUTION_INFO.get();
        fcslog.debug((Object)("Command running:" + currentCmdContext.getCommandName()));
        fcslog.info((Object)("coming from:" + currentCmdContext.getCommandOriginator()));
        this.getSubsystem().interruptActionThread();
    }
}

