/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class FcsMainModule
extends MainModule {
    private static final long serialVersionUID = 7669526660659959402L;
    private CarouselModule carousel;
    private AutoChangerModule autochanger;
    private LoaderModule loader;
    private Double standbyPosition;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private static final String ack = "[FCSMainModule]";

    public FcsMainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    @Override
    public void initModule() {
        fcslog.info((Object)"[FcsMainModule] Initializing the FCS Main module ");
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
        this.loader = (LoaderModule)this.getModule("loader");
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.getSubsystem().publishStatus(v.getName(), v.getValue());
    }

    public String printFilters() {
        StringBuilder mess = new StringBuilder(ack);
        mess.append(" printFilters %n ");
        for (String key : this.filters.keySet()) {
            mess.append(this.filters.get(key).getName());
            mess.append(" ");
            mess.append(this.filters.get(key).getFilterLocation());
            if (this.filters.get(key).isOnCarousel()) {
                mess.append(" position: ").append(this.carousel.getFilterPosition(this.filters.get(key)));
                mess.append(" socket number: ").append(this.carousel.getSocketNumber(this.filters.get(key)));
                mess.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.filters.get(key)));
            }
            mess.append(" %n ");
        }
        fcslog.info((Object)mess.toString());
        return mess.toString();
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getSubsystem().getName()).append("\n  ");
        sb.append(this.carousel.toString()).append("\n  ");
        sb.append(((Object)((Object)this.autochanger)).toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.carousel.toString());
        sb.append(((Object)((Object)this.autochanger)).toString());
        return sb.toString();
    }

    public String moveFilterToOnline(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        this.controlFilterName(filterName);
        fcslog.info((Object)("Filter to move : " + filterName));
        fcslog.info((Object)("Filter location :" + this.getFilterByName((String)filterName).getFilterLocation()));
        return ack + this.moveFilterToOnline(this.getFilterByName((String)filterName));
    }

    public String moveFilterToStandby(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException {
        this.controlFilterName(filterName);
        fcslog.info((Object)("Filter to move : " + filterName));
        fcslog.info((Object)("Filter location : " + this.getFilterByName((String)filterName).getFilterLocation()));
        return ack + this.moveFilterToStandby(this.getFilterByName((String)filterName));
    }

    private void locateFilters() {
        this.carousel.getSockets()[0].putFilterOnSocket(this.filters.get("filterU"));
        this.carousel.getSockets()[1].putFilterOnSocket(this.filters.get("filterG"));
        this.carousel.getSockets()[2].putFilterOnSocket(this.filters.get("filterR"));
        this.carousel.getSockets()[3].putFilterOnSocket(this.filters.get("filterI"));
        this.carousel.getSockets()[4].putFilterOnSocket(this.filters.get("filterZ"));
        this.carousel.engageClampsContact();
        this.filters.get("filterY").setFilterLocation(FcsEnumerations.FilterLocation.OUT);
    }

    private String moveFilterToOnline(Filter filter) throws InterruptedException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, CanOpenException {
        String message = "Panic : filter is neither on carousel, neither on autochanger";
        fcslog.error((Object)message);
        return message;
    }

    private String moveFilterToStandby(Filter filter) throws BadCommandException, InterruptedException, ErrorInCommandExecutionException {
        String message = null;
        return message;
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    protected void controlFilterName(Object o) throws IllegalArgumentException {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Incorrect filter name : " + o);
        }
        String filterName = (String)o;
        if (!this.filters.containsKey(filterName)) {
            throw new IllegalArgumentException("Unknown filter name : " + o);
        }
        if (this.getFilterByName(filterName).isUnknown()) {
            throw new IllegalArgumentException("Filter: " + o + " is at unknown location.");
        }
        if (this.getFilterByName(filterName).isOut()) {
            throw new IllegalArgumentException("Filter: " + o + " is out of the camera.");
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filters.get(filterName);
    }

    public boolean isEmptyStandBy() {
        return false;
    }

    public boolean isEmptyOnline() {
        return true;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(Double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public void loadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        this.connectLoader();
        if (!this.loader.isHoldingAFilter() || !this.loader.isCarrierAtStoragePosition()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.goToHandoff();
        this.autochanger.goToHandOff();
        this.autochanger.grabFilterAtHandoff(aFilter);
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.ONAUTOCHANGER);
        this.loader.openHooks();
        this.loader.goToStorage();
        this.disconnectLoader();
    }

    public void unloadFilter(Filter aFilter) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!aFilter.isOnCarousel()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " " + aFilter.getName() + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isOnStandby(aFilter)) {
            throw new BadCommandException(String.valueOf(this.getName()) + " " + aFilter.getName() + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        this.connectLoader();
        fcslog.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.grabFilterAtStandby(aFilter);
        fcslog.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(aFilter);
        fcslog.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.");
        this.autochanger.moveFilterToHandoff(aFilter);
        fcslog.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        this.loader.goToHandoff();
        this.loader.closeHooks();
        this.autochanger.ungrabFilterAtHandoff(aFilter);
        this.loader.clampHooks();
        this.loader.goToStorage();
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.OUT);
        this.disconnectLoader();
    }

    private void connectLoader() {
    }

    private void disconnectLoader() {
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

