/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoLatches
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerLatchModule latchXminus;
    private final AutochangerLatchModule latchXplus;
    private volatile FcsEnumerations.LockStatus lockStatus;
    private volatile FcsEnumerations.FilterPresenceStatus filterPresenceStatus;
    private long timeoutForClosing;
    private long timeoutForOpening;
    private final Condition stateUpdated;
    protected volatile boolean updatingState;

    public AutochangerTwoLatches(String moduleName, int aTickMillis, AutochangerLatchModule latchXminus, AutochangerLatchModule latchXplus) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.timeoutForClosing = Math.max(latchXminus.getTimeoutForClosing(), latchXplus.getTimeoutForClosing());
        this.timeoutForOpening = Math.max(latchXminus.getTimeoutForOpening(), latchXplus.getTimeoutForOpening());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 2 latches are initialized.")
    boolean isInitialized() {
        return this.latchXminus.isInitialized() && this.latchXplus.isInitialized();
    }

    boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns lockStatus.")
    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns filterPresenceStatus.")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public EPOSController getLatchXminusController() {
        return this.latchXminus.getLatchController();
    }

    public EPOSController getLatchXplusController() {
        return this.latchXplus.getLatchController();
    }

    public AutochangerLatchModule getLatchXminus() {
        return this.latchXminus;
    }

    public AutochangerLatchModule getLatchXplus() {
        return this.latchXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockStatus=LOCKED.")
    public boolean isLocked() {
        return this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
    }

    @Override
    public boolean isHardwareReady() {
        return this.autochanger.isHardwareReady() && this.isInitialized();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.latchXminus.checkHardware();
        this.latchXplus.checkHardware();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPENLATCHES: {
                return this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked();
            }
            case CLOSELATCHES: {
                return this.latchXminus.isLocked() && this.latchXplus.isLocked();
            }
        }
        return false;
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            boolean inTravel;
            this.updatingState = true;
            this.latchXminus.updateStateWithSensors(readHexaValues);
            this.latchXplus.updateStateWithSensors(readHexaValues);
            boolean inError = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
            boolean locked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
            boolean unlocked = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
            boolean bl = inTravel = this.latchXminus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL && this.latchXplus.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (unlocked ? FcsEnumerations.LockStatus.UNLOCKED : (inTravel ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
            this.filterPresenceStatus = this.latchXminus.isEmpty() && this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.NOFILTER : (!this.latchXminus.isEmpty() && !this.latchXplus.isEmpty() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.UNKNOWN);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update autochanger state in reading sensors.")
    public void updateStateWithSensors() throws FcsHardwareException {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latches.")
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
            throw new BadCommandException(String.valueOf(this.name) + " are already LOCKED.");
        }
        this.autochanger.checkPreConditionsForClosingLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latches.")
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (this.latchXminus.isUnlocked() && this.latchXplus.isUnlocked()) {
            throw new BadCommandException(String.valueOf(this.name) + " are already UNLOCKED.");
        }
        this.autochanger.checkPreConditionsForOpeningLatches();
        return this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpening);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        switch (action) {
            case OPENLATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(this.latchXminus.getCurrentToOpen());
                this.latchXplus.getLatchController().writeCurrent(this.latchXplus.getCurrentToOpen());
                break;
            }
            case CLOSELATCHES: {
                this.latchXminus.getLatchController().enable();
                this.latchXplus.getLatchController().enable();
                this.latchXminus.getLatchController().writeCurrent(-this.latchXminus.getCurrentToOpen());
                this.latchXplus.getLatchController().writeCurrent(-this.latchXplus.getCurrentToOpen());
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        fcslog.debug((Object)(String.valueOf(this.name) + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.latchXminus.getLatchController().off();
        this.latchXplus.getLatchController().off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StatusDataPublishedByAutochangerTwoLatches getStatusData() {
        return FcsUtils.createStatusDataPublishedByTwoLatches(this);
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishStatus("autochangerLatches", (Object)this.getStatusData());
    }
}

