/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerMainModule
extends MainModule {
    AutoChangerModule autochanger;
    InclinometerModule inclinometer;

    public AutochangerMainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    public AutochangerMainModule(String aName, int aTickMillis, BridgeToHardware bridge, AutoChangerModule autochanger, InclinometerModule inclinometer) {
        super(aName, aTickMillis, bridge);
        this.autochanger = autochanger;
        this.inclinometer = inclinometer;
    }

    public AutoChangerModule getAutochanger() {
        return this.autochanger;
    }

    public EPOSController getLinearRailMasterController() {
        return this.autochanger.getTrucks().getLinearRailMasterController();
    }

    public EPOSController getLinearRailSlaveController() {
        return this.autochanger.getTrucks().getLinearRailSlaveController();
    }

    public EPOSController getLatchXminusController() {
        return this.autochanger.getLatches().getLatchXminusController();
    }

    public EPOSController getLatchXplusController() {
        return this.autochanger.getLatches().getLatchXplusController();
    }

    public PlutoGatewayModule getPlutoGateway() {
        return this.autochanger.getPlutoGateway();
    }

    public AutoChangerTrucksModule getAutochangerTrucks() {
        return this.autochanger.getTrucks();
    }

    public EPOSController getOnlineClampXminusController() {
        return this.autochanger.getOnlineClamps().getOnlineClampXminusController();
    }

    public EPOSController getOnlineClampXplusController() {
        return this.autochanger.getOnlineClamps().getOnlineClampXplusController();
    }

    public EPOSController getOnlineClampZController() {
        return this.autochanger.getOnlineClamps().getOnlineClampZController();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="The GUIs need that for the initialization.")
    public AutochangerConfig getFullState() {
        try {
            return FcsUtils.createAutochangerConfig(this);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update autochanger state in reading the sensors.")
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }
}

