#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import *
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *
from org.lsst.ccs.messaging import BadCommandException

#
CCS.setThrowExceptions(True);

sft = CCS.attachSubsystem("single-filter-test");

print "single-filter-test switchToEngineeringMode";
sft.synchCommandLine(10,"switchToEngineeringMode");

sft = CCS.attachSubsystem("single-filter-test/carousel");
print "single-filter-test/carousel isHoldingFilterAtStandby";
isHoldingFilterAtStandby = sft.synchCommandLine(10,"isHoldingFilterAtStandby");
if not isHoldingFilterAtStandby.getResult():
     raise Exception("carousel not holding a filter at standby");

sft = CCS.attachSubsystem("single-filter-test/autochanger");
print "single-filter-test/autochanger isAtStandby";
isAtStandby = sft.synchCommandLine(10,"isAtStandby");
if isAtStandby.getResult():
     raise Exception("autochanger should not be at standby");

print "single-filter-test/autochanger isAtStandback";
isAtStandback = sft.synchCommandLine(10,"isAtStandback");
if not isAtStandback.getResult():
     raise Exception("autochanger should be at standback");

print "single-filter-test/autochanger isHoldingFilterAtStandback";
isHoldingFilterAtStandback = sft.synchCommandLine(10,"isHoldingFilterAtStandback");
if isHoldingFilterAtStandback.getResult():
     raise Exception("autochanger should not be holding a filter at standback");

print "single-filter-test/autochanger isHoldingFilterAtStandby";
isHoldingFilterAtStandby = sft.synchCommandLine(10,"isHoldingFilterAtStandby");
if isHoldingFilterAtStandby.getResult():
     raise Exception("autochanger should not be holding a filter at standby");

CCS.setThrowExceptions(False);

sft = CCS.attachSubsystem("single-filter-test/carousel");
print "single-filter-test/carousel unlockClamps";
result = sft.synchCommandLine(10,"unlockClamps");
if not isinstance(result.getResult(),CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception");

CCS.setThrowExceptions(True);

sft = CCS.attachSubsystem("single-filter-test/autochanger");
print "Moving autochanger to standby position";
sft.synchCommandLine(60,"goToStandby");

CCS.setThrowExceptions(False);

sft = CCS.attachSubsystem("single-filter-test/carousel");
print "single-filter-test/carousel unlockClamps";
result = sft.synchCommandLine(10,"unlockClamps");
if not isinstance(result.getResult(),CommandInvocationException):
     raise Exception("unclamp the filter should throw an exception");

CCS.setThrowExceptions(True);

sft = CCS.attachSubsystem("single-filter-test/autochanger");
print "single-filter-test/autochanger closeLatchesAtStandby";
sft.synchCommandLine(10, "closeLatchesAtStandby");

sft = CCS.attachSubsystem("single-filter-test/carousel");
print "single-filter-test/carousel unlockClamps";
sft.synchCommandLine(10,"unlockClamps");

CCS.setThrowExceptions(False);

sft = CCS.attachSubsystem("single-filter-test/autochanger");
print "single-filter-test/autochanger openLatchesAtStandby";
result = sft.synchCommandLine(10, "openLatchesAtStandby");
if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("openLatchesAtStandby should throw an exception");


