#import CCS Scripting Implementation                                                                                          
from org.lsst.ccs.scripting import *
#import the definition for a Java Exception                                                                                   
from java.lang import Exception
from java.lang import RuntimeException
from org.lsst.ccs.command import *

#
CCS.setThrowExceptions(True);

loader = CCS.attachSubsystem("testbenchLPSC");

print "Connected to loader ",loader

#getting timeouts
loaderConfigFuture = loader.asynchCommandLine("getFullState");
print "getting loader configuration";
loaderConfig = loaderConfigFuture.get();
loaderCarrierConfig = loaderConfig.getLoaderCarrierConfig();
loaderClampConfig = loaderConfig.getLoaderClampConfig();

CCS.setThrowExceptions(False);

#Handle the thrown exceptions                                                                                                 
print "hooks opening ";
result = loader.synchCommandLine(loaderClampConfig.getTimeoutToOpen(), "openHooks");

if not isinstance(result.getResult(), CommandInvocationException):
     raise Exception("Clamps must not open when carrier is loaded with a filter but is not at handoff position");

CCS.setThrowExceptions(True);
result = loader.synchCommandLine(loaderCarrierConfig.getTimeoutToGoToHandoff(),"goToHandoff");
print "Gone to handoff";
result = loader.synchCommandLine(loaderCarrierConfig.getTimeoutToGoToStorage(), "goToStorage");
print "Gone to storage "
