/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.beans.ConstructorProperties;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This is the Main Module for the LPSC test bench control software.
 * The test bench is to test the hardware of the loader.
 * @author virieux
 */
public class LoaderTestBenchMainModule  extends MainModule {
 
    
    private LoaderModule loader;
    private AutoChangerModule autochanger;
    private final NumericSensor autochangerHoldingFilterSensor;
    
    @ConstructorProperties({"name", "tickmillis", 
        "bridge", 
        "autochangerHoldingFilterSensor"})
    public LoaderTestBenchMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge,
            NumericSensor autochangerHoldingFilterSensor) {
        super(aName, aTickMillis, bridge);
        this.autochangerHoldingFilterSensor = autochangerHoldingFilterSensor;
    }

    public LoaderModule getLoader() {
        return loader;
    }
       

    @Override
    public void initModule() {
        super.initModule();
        this.loader = (LoaderModule)this.getModule("loader");
        this.autochanger = (AutoChangerModule) this.getModule("autochanger");
    }
    
    /**
     * This command can be launched when a filter is in the loader
     * and we want to put in inside the camera.
     * @return
     * @throws BadCommandException
     * @throws FcsHardwareException
     * @throws ErrorInCommandExecutionException
     * @throws InterruptedException 
     */
    @Command (type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Load a filter from the loader into the camera.")
    public String loadFilterInCamera() throws BadCommandException, 
            FcsHardwareException, ErrorInCommandExecutionException, 
            InterruptedException {
        return loader.loadFilterInCamera();
        ////Moved to LoaderModule 29 april 2015
//        if (!loader.isConnectedOnCamera())
//            throw new BadCommandException(name 
//                    +":loader has to be connected to camera first.");
//        if (!loader.isHoldingAFilter()) 
//            throw new BadCommandException(name 
//                    +":loader is not holding a filter : can't load a filter into camera.");
//        if (!loader.isCarrierAtStoragePosition()) //TODO : what do we do in this case ?
//            throw new BadCommandException(name 
//                    +":carrier loader is not at storage position : can't load a filter into camera.");
//        
//        //go to Handoff position with the filter
//        loader.getCarrier().goToHandOff();
//        if (this.haltRequired.get()||this.stopRequired.get()) {
//            String msg = name + ": received HALT or STOP command.";
//            return msg;
//        }
//        //wait until the autochanger hold the filter
//        while (!loader.isAutochangerHoldingFilter()) {
//            Thread.sleep(300);
//            updateStateWithSensors();
//        }
//        
//        if (loader.isAutochangerHoldingFilter()) {
//            loader.openHooks();
//        }
//        if (this.haltRequired.get()||this.stopRequired.get()) {
//            String msg = name + ": received HALT or STOP command.";
//            return msg;
//        }
//        
//        // empty carrier go to Storage
//        return loader.goToStorage(); 
    }
    
    /**
     * This command can be launched when the loader is empty 
     * and we want to take a filter from the camera.
     * A filter must be at handoff position and held by autochanger.
     * @return
     * @throws BadCommandException
     * @throws FcsHardwareException
     * @throws InterruptedException
     * @throws SDORequestException
     * @throws ErrorInCommandExecutionException 
     */
    @Command (type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Unload a filter from the camera into the loader.")
    public String unloadFilterFromCamera() throws BadCommandException, 
            FcsHardwareException, InterruptedException, SDORequestException, 
            ErrorInCommandExecutionException {
        return loader.unloadFilterFromCamera();
        ////moved to LoaderModule 29 april 2015
//        updateStateWithSensors();
//        if (!loader.isConnectedOnCamera())
//            throw new BadCommandException(name +":loader has to be connected to "
//                    + "camera first.");
//        if (loader.isHoldingAFilter()) 
//            throw new BadCommandException(name +":loader is holding a filter : "
//                    + "can't unload a filter from camera.");
//        
//        //wait for the autochanger to put a filter at handoff position
//        //in loader test bench it's just a switch to put on.
//        while (!loader.isAutochangerHoldingFilter()) {
//            Thread.sleep(300);
//            updateStateWithSensors();
//        }
//        
//        //go tho Handoff position - carrier empty
//        loader.goToHandoff();    
//        if (this.haltRequired.get()||this.stopRequired.get()) {
//            String msg = name + ": received HALT or STOP command.";
//            return msg;
//        } 
//        
//        //at handoff position a filter should be here.
//        updateStateWithSensors();
//        if (loader.isEmpty())
//            throw new ErrorInCommandExecutionException(name 
//                    +": loader presence filter sensor doesn't detect a filter"
//                    + " - can't go on.");
//        loader.closeHooks();
//        
//        //wait for the autochanger to unlock the filter at handoff position
//        //in loader test bench it's just a switch to put off.(switch A22)
//        while (loader.isAutochangerHoldingFilter()) {
//            Thread.sleep(300);
//            updateStateWithSensors();
//        }
//        
//        //close more fermely the hooks to hold the filter.
//        loader.clampHooks();
//        if (this.haltRequired.get()||this.stopRequired.get()) {
//            String msg = name + ": received HALT or STOP command.";
//            return msg;
//        }
//        
//        //carrier holding filter goes to storage position.
//        return loader.goToStorage();
    }
    
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Open the loader clamp.")
    public String openHooks() throws SDORequestException, BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
       return loader.openHooks();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Close the loader clamp.")
    public String closeHooks() throws BadCommandException, SDORequestException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return loader.closeHooks();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Clamp the loader clamp.")
    public String clampHooks() throws BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return loader.clampHooks();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="Update loader state in reading the sensors.")
    @Override
    public void updateStateWithSensors() 
            throws FcsHardwareException, ErrorInCommandExecutionException, 
            BadCommandException {
        super.updateStateWithSensors();
        loader.updateStateWithSensors();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Carrier go to Handoff.")
    public String goToHandoff() throws BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return loader.goToHandoff();
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.NORMAL, 
            description="Carrier go to Storage.")
    public String goToStorage() throws BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        return loader.goToStorage();
    }
       
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="List and display hooks sensors.")
    public String listHooksSensors() {
        return this.loader.getClamp().listHooks();
    }
    
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="List and display the hooks sensors values.")
    public String listSensorsValues() {
        return this.loader.getClamp().listSensorsValues();
    }
    
    /**
     * For the GUI.
     * @return 
     */
    @Command(type=Command.CommandType.QUERY, level=Command.NORMAL, 
            description="The GUIs need that for the initialization.")
    public LoaderConfig getFullState() {
        try {
            return FcsUtils.createLoaderConfig(this);
        } catch (Exception e) {
            log.error(e);
        }
        return null;           
    }
    

//Moved to MainModule in March 2015
//    @Override
//    public TreeWalkerDiag signal(Signal signal) {
//        switch(signal.getLevel()) {
//            case HALT :
//                fcslog.debug("HALT required");
//                this.haltRequired.set(true);
//                break;
//            case STOP :
//                fcslog.debug("STOP required");
//                this.stopRequired.set(true);
//                break;
//            case INTERRUPT1 :
//                break;
//            case INTERRUPT2 :
//                break;
//            case RE_START :
//                this.haltRequired.set(false);
//                this.stopRequired.set(false);
//                break;
//        }
//        //we want the signal to go to all my children.
//        return TreeWalkerDiag.GO;
//    }
 
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(name);
        sb.append("\n").append(loader.toString());
        sb.append("\n").append(autochangerHoldingFilterSensor.toString());       
        return sb.toString();
    }

    
    
}
