/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 * A hygrometry, pressure and temperature gauge used for the test bench at LPC in Clermont-Ferrand.
 * @author virieux
 */
public class CanOpenLPCGaugeHD2001 extends CanOpenSensor14bits implements Thermometer, PressureSensor, HygrometrySensor {
    
    private final int offsetTemp;
    private final int offsetPressure;
    private double temperature;

    public CanOpenLPCGaugeHD2001(String moduleName, int aTickMillis, 
            String adcName, 
            int numOfAnalogInput,
            int offsetTemp,
            int offsetPressure) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
//        this.offsetTemp = -20;
//        this.offsetPressure = 600;
        this.offsetTemp = offsetTemp;
        this.offsetPressure = offsetPressure;
    }
    
    /**
     * Read the temparature and returns the new value in degree celcius.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Override
    public double readTemperature() throws SDORequestException, HardwareNotDetectedException {
        try {
            double voltage = getAdc().readVoltage(getNumOfAnalogInput());
            temperature =  (voltage / 100) + this.offsetTemp;

        } catch (ShortResponseToSDORequestException ex) {
            fcslog.warning(name + " couldn't read temperature : " + ex.getMessage());
        }
        return temperature;
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    /**
     * Read the pressure sensors and returns the new value in mbar 
     * @return pressure in mbar
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Override
    public double readPressure() throws FcsHardwareException {
        double voltage = getAdc().readVoltage(getNumOfAnalogInput());
        return (voltage / 500) + offsetPressure;
    }

    /**
     * Read the hygrometry with the sensor and returns the new value in %RH
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Override
    public double readHygrometry() throws FcsHardwareException {
        double voltage = getAdc().readVoltage(getNumOfAnalogInput());
        return (voltage / 100);
    }
    
}
