/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDIO;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

/**
 * This class is to list the hardware we have to control in the single-filter-test
 * @author virieux
 */
public class BridgeToSFTHardware extends BridgeToCanOpenHardware {

    public BridgeToSFTHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy, 
            CanOpenADC ai814,
            CanOpenDAC ao412,
            CanOpenDIO dio8n1,
            CanOpenDIO dio8n2,
//            CanOpenClampActuatorModule clampActuatorXminus, 
//            CanOpenClampActuatorModule clampActuatorXplus) {
            CanOpenEPOS24 clampActuatorXminus, 
            CanOpenEPOS24 clampActuatorXplus) {
        super(aName, aTickMillis, tcpProxy);

        this.ai814 = ai814;
        this.ao412 = ao412;
        this.dio8n1 = dio8n1;
        this.dio8n2 = dio8n2;
        this.clampActuatorXminus = clampActuatorXminus;
        this.clampActuatorXplus = clampActuatorXplus;
    }
   
    
    /*The ADC that we have to control on the Single Filter test bench.*/
    private final CanOpenADC ai814;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CanOpenDAC ao412;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CanOpenDIO dio8n1;
    
    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CanOpenDIO dio8n2;
    
    /*Controller for clampXminus */
    private final CanOpenEPOS24 clampActuatorXminus;
    
    /*Controller for clampXplus.*/
    private final CanOpenEPOS24 clampActuatorXplus;
    
//        /*A third clamp motor that we have to control on the Single Filter test bench.*/
//    private final CanOpenClampActuatorModule clampActuatorXminus;
//    
//    /*Another clamp motor that we have to control on the Single Filter test bench.*/
//    private final CanOpenClampActuatorModule clampActuatorXplus;


//    @Override
//    public PieceOfHardware[] listHardware() {
//        PieceOfHardware[] hardwareList =  {ai814, ao412, dio8n1, dio8n2, clampActuatorXminus, clampActuatorXplus};
//        return hardwareList;
//    }
    
    
}
