/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;


import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 *
 * @author virieux
 */
public class SimuLoaderCarrierController extends SimuEPOSControllerModule {
    
    LoaderCarrierModule carrier;
    SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderCarrierController(String aName, int aTickMillis, 
            String nodeID, String serialNB,
            Map<String, Integer> paramsForCurrent,            
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming
        ) {
        super(aName, aTickMillis, nodeID, serialNB,paramsForCurrent,paramsForProfilePosition,paramsForHoming);
        
    }
    
    
    
    
    @Override
    public void initModule() {
        super.initModule();
        carrier = (LoaderCarrierModule)this.getModule("carrier");
        plutoGateway = (SimuLoaderPlutoGateway)this.getModule("plutoGateway");
    }
    
    @Override
    public void writeTargetPosition(int positionToReached) 
            throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug("loader carrier is moving.");
        fcslog.debug(name + "=>position intitiale="+position);
        int stepsNB = 20;
        int step = (targetPosition - this.position)/stepsNB;
        
        for (int i=1; i<stepsNB; i++) {           
            try {           
                
                this.position = positionInitiale + (i*step);
                carrier.updatePosition();
                if (position == carrier.getHandoffPosition() ) {
                    log.debug("plutoGateway="+ plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (position == carrier.getStoragePosition() ) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                carrier.updateStateWithSensors();
                carrier.publishData();
                fcslog.debug(name +"i="+i+",position="+position);
                try {
                    Thread.sleep(500);
                    if (carrier.getHaltRequired().get()) {
                        log.debug(name + " STOP simulated carrrier motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new BadCommandException(name+" sleep was interrupted.");
                }
                
            } catch (FcsHardwareException ex) {
                throw new BadCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == carrier.getHandoffPosition() ) {
            log.debug("plutoGateway="+ plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (position == carrier.getStoragePosition() ) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }
        
    }

    
//    public String[] readErrorHistory() {
//        String[] hist = {"4210","ff09"};
//        return hist;
//    }

    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }



    
    
    
}
