/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This class is to simulate an EPOS Controller.
 * @author virieux
 */
public abstract class SimuEPOSControllerModule extends CanOpenDevice implements EPOSController {
    
    
    
    public boolean on;
    public boolean enabled;
    public boolean enabledToPublish;
    EposMode mode;
    int targetPosition;
    int position;
    int ssiPosition;
    int targetCurrent;
    int actualCurrent;
    
    /* Parameters */
    Map<String,Integer> paramsForHoming;   
    Map<String,Integer> paramsForProfilePosition;
    Map<String,Integer> paramsForCurrent;

    private boolean inError;
    private String[] errorHistory;
    private String errorRegister;

    public SimuEPOSControllerModule(String aName, int aTickMillis, 
            String nodeID, String serialNB,
            Map<String, Integer> paramsForCurrent,            
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming
            ) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.paramsForHoming = paramsForHoming;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForCurrent = paramsForCurrent;
        this.position = 0;
        this.inError = false;
        this.errorRegister = "NO ERROR";
//        String[] hist = {"4210","ff09"};
//        this.errorHistory = hist;
        this.errorHistory = null;
        this.mode = EposMode.PROFILE_POSITION;
    }
    

    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    public void setActualCurrent(int actualCurrent) {
        this.actualCurrent = actualCurrent;
    }

    public boolean isEnabledToPublish() {
        return enabledToPublish;
    }
    
    

    //For GUI
    @Override
    public Map<String, Integer> getParamsForHoming() {
        return paramsForHoming;
    }

    //For GUI
    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        return paramsForProfilePosition;
    }

    @Override
    public boolean isInError() {
        return inError;
    }

    public String getErrorRegister() {
        return errorRegister;
    }

    public String[] getErrorHistory() {
        return errorHistory;
    }
    
    
    @Override
    public String getModeInString() {
        return mode.toString();
    }

    //For GUI
    @Override
    public Map<String, Integer> getParamsForCurrent() {
        return paramsForCurrent;
    }

     /**
     * This methods is called during INITIALIZATION phase.
     * We want to publish data in order for the controllers GUIs to be refreshed.
     * @return a message 
     */
    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        super.initializeAndCheckHardware();
        publishData();
        return name + " is INITIALIZED.";
        
    }
    
     /**
     * Changes the mode to the new mode given as a String argument.
     * @param modeInString
     * @return
     * @throws SDORequestException 
     */
    public String changeMode(String modeInString) throws SDORequestException {
        EposMode newMode = EposMode.valueOf(modeInString.trim().toUpperCase());
        return changeMode(newMode);
    }

    @Override
    public String changeMode(EposMode newMode) throws SDORequestException {
        this.mode = newMode;
        return getName() + " mode changed to=" + newMode.toString();
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException {
        //throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, 
            ErrorInCommandExecutionException, BadCommandException {
        this.position = position;
    }
    
    @Override
    public void disable() throws SDORequestException, ShortResponseToSDORequestException {
        this.enabled = true;
        this.enabledToPublish = true;
    }

    @Override
    public void writeParameters(EposMode mode) throws SDORequestException, ErrorInCommandExecutionException { 
    }
    
    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) 
            throws SDORequestException {
        return name + " " + parameter.toString() + " set to value in HEXA=" + string;
    }

    @Override
    public void writeTargetPosition(int position) 
            throws BadCommandException, SDORequestException {
        //this.targetPosition = position;
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) 
            throws SDORequestException {
    }

    @Override
    public void writeCurrent(int aValue) throws BadCommandException, 
            SDORequestException {
        this.actualCurrent = aValue;
    }

    @Override
    public String on() throws SDORequestException, BadCommandException, 
            ErrorInCommandExecutionException {
        return name + " is ON";
    }
    

    @Override
    public String off() throws SDORequestException, BadCommandException, 
            ErrorInCommandExecutionException {
        return name + " is OFF";
    }

    @Override
    public boolean isOn() {
        return on;
    }

    @Override
    public boolean isOff() {
        return !on;
    }
    
        @Override
    public void setOn(boolean on) {
        this.on = on;
    }


    @Override
    public int getReadActualCurrent() {
        return this.actualCurrent;
    }

    @Override
    public int getSentCurrentValue() {
        return this.targetCurrent;
    }

    @Override
    public int getSentCurrentMinValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getSentCurrentMaxValue() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean isTargetPositionReached(int targetPosition) {
        return (this.position == targetPosition);
    }


    @Override
    public int readPosition() throws SDORequestException {
        return this.position;
    }
    
        /**
     * Read the position returned by the absolute encoder (single serial data).
     * @return
     * @throws SDORequestException
     * @throws ShortResponseToSDORequestException 
     */
    @Override
    public int readSSIPosition() throws SDORequestException,                           
            ShortResponseToSDORequestException {
        return this.ssiPosition;
    }

    @Override
    public String enable() throws SDORequestException {
        enabled = true;
        return name + "IS ENABLED";
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        return actualCurrent;
    }

    @Override
    public EposMode readMode() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxCurrent() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMinCurrent() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxSpeed() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxPosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMinPosition() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
   

    @Override
    public void quickStop() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException {
        return 0;
    }
    

    @Override
    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        return "No ERROR";
    }

    @Override
    public void checkFault() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException {        
    }
    
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
        description="Clear faults on the controller.")
    public void faultReset() throws SDORequestException {
        writeControlWord("80");
        setChanged();
        this.notifyObservers(new ValueUpdate(name,"faultReset"));
        this.inError = false;
        this.errorRegister = "NO ERROR";
        this.errorHistory = null;
        publishData();
    }

    @Override
    public int readProfileVelocity() throws SDORequestException, 
            ShortResponseToSDORequestException {
        //TODO return a value of current in random between min and max
        return 0;
    }

    @Override
    public String readParameters(EposMode mode) throws SDORequestException, ShortResponseToSDORequestException {
        return name + ":no parameter to read.";
    }

    @Override
    public void checkParameters(String modeInString) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void checkParameters(EposMode aMode) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
        
    }

    @Override
    public void writeControlWord(String f) throws SDORequestException {
        fcslog.debug(name + "writeControlWord :" + f);
    }

    @Override
    public String shutdown() throws SDORequestException {
        fcslog.debug(name + " is SHUTDOWN");
        return name + " is SHUTDOWN";
    }

    @Override
    public boolean isEnabled() throws SDORequestException {
        return enabled;
    }

    @Override
    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException {
        fcslog.debug(name + " brake is released.");
    }

    @Override
    public void switchOnEnableOperation() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException {
        fcslog.debug(name + " brake is activated.");
    }
    
    public StatusDataPublishedByEPOSController getStatusData() {
        StatusDataPublishedByEPOSController status = FcsUtils.createStatusDataPublishedByEPOSController(this);
        return status;
    }   
    
     /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    public void publishData() {
        StatusDataPublishedByEPOSController status = this.getStatusData();
        this.getSubsystem().publishStatus(name, status);
    }







    
    
}
