/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * A very basic simulated filter clamp module.
 * It has no sensor to know if the clamp is locked or not.
 * This clamp is locked when the clamps actuator of the carousel are off.
 * And its filter presence sensor is configured to returns the value we expect!
 * 
 * @author virieux
 */
public class SimuCarouselClampModule extends CarouselClampModule {

   
    protected CarouselModule carousel;
    protected Filter dummyFilter;
    //TODO just for tests (cf tick method). 
    private BasicAutoChangerModule autochanger;
    
    public SimuCarouselClampModule(String aName, int aTickMillis, 
            Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, Thermometer thermometer, 
            int filterPositionValueA, int filterPositionValueB, int filterPositionValueC, 
            int filterPositionOffset, 
            int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, 
            int lockSensorOffset, int timeoutForUnlocking, int timeoutForReleasing,
            int currentToUnlock, int currentToMaintainUnlocked) {
        super(aName, aTickMillis, filterPresenceSensor, lockSensor, thermometer, 
                filterPositionValueA, filterPositionValueB, filterPositionValueC, 
                filterPositionOffset, lockSensorValueA, lockSensorValueB, lockSensorValueC, 
                lockSensorOffset, timeoutForUnlocking, timeoutForReleasing,
                currentToUnlock, currentToMaintainUnlocked);
    }
    
    

    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }








    
    

    @Override
    public double updateTemperature() {
        throw new UnsupportedOperationException(getName() + "updateTYemperature : Not supported yet.");
    }


    @Override
    public void initModule() {
        this.carousel = (CarouselModule) this.getModule("carousel");
        this.autochanger = (BasicAutoChangerModule) this.getModule("autochanger");
        
        this.filterPresenceStatus = FilterPresenceStatus.LOCKABLE;

        this.clampState = FilterClampState.CLAMPEDONFILTER;
        //((SimuSensor14bits) getFilterPresenceSensor()).setNewRange(getFilterPositionValueA(), getFilterPositionValueB());
        ((SimuClampFilterPresenceSensor) getFilterPresenceSensor()).simulateFilterIsLockable(this);
        //simu clamp is LOCKED
        //((SimuSensor14bits) getLockSensor()).setNewRange(this.getLockSensorValueB(),this.getLockSensorValueC());
        ((SimuClampLockSensor) getLockSensor()).simulateClampIsLOCKED(this);
        this.setLockStatus(LockStatus.LOCKED);
    }
    
    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws SDORequestException, BadCommandException, 
            ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals(FcsEnumerations.MobileItemAction.UNLOCK)) {
            this.actuator.on();
        } else if (action.equals(FcsEnumerations.MobileItemAction.RELEASE)) {
            this.actuator.off();
        } else throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        
    }
    
    @Override
    public void updateStateWithSensors() throws FcsHardwareException {
        updateStateWithSensorsFromSDO();
    }
    
}
